/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.testrunner;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.netbeans.api.extexecution.input.LineProcessors;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.api.extexecution.print.LineConvertors;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gsf.testrunner.api.Manager;
import org.netbeans.modules.gsf.testrunner.api.OutputLineHandler;
import org.netbeans.modules.gsf.testrunner.api.RerunHandler;
import org.netbeans.modules.gsf.testrunner.api.TestRunnerNodeFactory;
import org.netbeans.modules.gsf.testrunner.api.TestSession;
import org.netbeans.modules.gsf.testrunner.api.TestSuite;
import org.netbeans.modules.gsf.testrunner.api.Testcase;
import org.netbeans.modules.gsf.testrunner.api.Trouble;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.phpunit.PhpUnit;
import org.netbeans.modules.php.project.ui.testrunner.PhpTestRunnerNodeFactory;
import org.netbeans.modules.php.project.ui.testrunner.PhpUnitLogParser;
import org.netbeans.modules.php.project.ui.testrunner.TestSessionVO;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.windows.OutputWriter;

public final class UnitTestRunner {
    private static final Logger LOGGER = Logger.getLogger(UnitTestRunner.class.getName());
    private static final Manager MANAGER = Manager.getInstance();
    private static final PhpOutputLineHandler PHP_OUTPUT_LINE_HANDLER = new PhpOutputLineHandler();
    private final PhpProject project;
    private final TestSession testSession;
    private final boolean allTests;
    private volatile boolean started = false;

    public UnitTestRunner(PhpProject phpProject, TestSession.SessionType sessionType, RerunHandler rerunHandler, boolean bl) {
        assert (phpProject != null);
        assert (sessionType != null);
        assert (rerunHandler != null);
        this.project = phpProject;
        this.allTests = bl;
        this.testSession = new TestSession("PHPUnit test session", (Project)phpProject, sessionType, (TestRunnerNodeFactory)new PhpTestRunnerNodeFactory());
        this.testSession.setRerunHandler(rerunHandler);
        this.testSession.setOutputLineHandler((OutputLineHandler)PHP_OUTPUT_LINE_HANDLER);
    }

    public void start() {
        MANAGER.testStarted(this.testSession);
        this.started = true;
    }

    public void showResults() {
        Object object;
        BufferedReader bufferedReader;
        if (!this.started) {
            throw new IllegalStateException("Test runner must be started. Call start() method first.");
        }
        try {
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(PhpUnit.XML_LOG), "UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Exceptions.printStackTrace((Throwable)unsupportedEncodingException);
            return;
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.processPhpUnitError();
            return;
        }
        TestSessionVO testSessionVO = new TestSessionVO();
        PhpUnitLogParser.parse(bufferedReader, testSessionVO);
        if (!PhpUnit.KEEP_LOGS) {
            PhpUnit.XML_LOG.delete();
        }
        if (this.allTests && (object = PhpUnit.getCustomSuite(this.project)) != null) {
            MANAGER.displayOutput(this.testSession, NbBundle.getMessage(UnitTestRunner.class, (String)"MSG_CustomSuiteUsed", (Object)((File)object).getAbsolutePath()), false);
            MANAGER.displayOutput(this.testSession, "", false);
        }
        for (TestSessionVO.TestSuiteVO testSuiteVO : testSessionVO.getTestSuites()) {
            MANAGER.displaySuiteRunning(this.testSession, testSuiteVO.getName());
            TestSuite testSuite = new TestSuite(testSuiteVO.getName());
            this.testSession.addSuite(testSuite);
            for (TestSessionVO.TestCaseVO testCaseVO : testSuiteVO.getTestCases()) {
                Testcase testcase = new Testcase(testCaseVO.getName(), "PHPUnit test case", this.testSession);
                testcase.setTimeMillis(testCaseVO.getTime());
                testcase.setStatus(testCaseVO.getStatus());
                String[] stringArray = testCaseVO.getStacktrace();
                if (stringArray.length > 0) {
                    boolean bl = testCaseVO.isError();
                    Trouble trouble = new Trouble(bl);
                    trouble.setStackTrace(stringArray);
                    testcase.setTrouble(trouble);
                    MANAGER.displayOutput(this.testSession, testSuiteVO.getName() + "::" + testCaseVO.getName() + "()", bl);
                    this.testSession.addOutput("<u>" + testCaseVO.getName() + ":</u>");
                    for (String string : stringArray) {
                        MANAGER.displayOutput(this.testSession, string, bl);
                        this.testSession.addOutput(string);
                    }
                    MANAGER.displayOutput(this.testSession, "", false);
                    this.testSession.addOutput("");
                }
                this.testSession.addTestCase(testcase);
            }
            MANAGER.displayReport(this.testSession, this.testSession.getReport(testSuiteVO.getTime()));
        }
        MANAGER.displayOutput(this.testSession, NbBundle.getMessage(UnitTestRunner.class, (String)"MSG_OutputInOutput"), false);
        MANAGER.sessionFinished(this.testSession);
    }

    private void processPhpUnitError() {
        LOGGER.info(String.format("File %s not found. If there are no errors in PHPUnit output (verify in Output window), please report an issue (http://www.netbeans.org/issues/).", PhpUnit.XML_LOG));
        MANAGER.displayOutput(this.testSession, NbBundle.getMessage(UnitTestRunner.class, (String)"MSG_PerhapsError"), true);
        MANAGER.sessionFinished(this.testSession);
    }

    private static final class PhpOutputLineHandler
    implements OutputLineHandler {
        private static final LineConvertor CONVERTOR = LineConvertors.filePattern(null, (Pattern)PhpUnit.LINE_PATTERN, null, (int)1, (int)2);

        private PhpOutputLineHandler() {
        }

        public void handleLine(OutputWriter outputWriter, String string) {
            LineProcessors.printing((OutputWriter)outputWriter, (LineConvertor)CONVERTOR, (boolean)true).processLine(string);
        }
    }
}

