/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.actions.support;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.modules.php.api.phpmodule.PhpProgram;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.api.util.UiUtils;
import org.netbeans.modules.php.project.PhpActionProvider;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.phpunit.PhpUnit;
import org.netbeans.modules.php.project.ui.actions.Command;
import org.netbeans.modules.php.project.ui.options.PhpOptions;
import org.netbeans.modules.web.client.tools.api.WebClientToolsProjectUtils;
import org.netbeans.modules.web.client.tools.api.WebClientToolsSessionStarterService;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CommandUtils {
    private static final String HTML_MIME_TYPE = "text/html";

    private CommandUtils() {
    }

    public static boolean isPhpOrHtmlFile(FileObject fileObject) {
        assert (fileObject != null);
        String string = FileUtil.getMIMEType((FileObject)fileObject, (String[])new String[]{"text/x-php5", HTML_MIME_TYPE});
        return "text/x-php5".equals(string) || HTML_MIME_TYPE.equals(string);
    }

    public static boolean warnNoMoreDebugSession() {
        String string = NbBundle.getMessage(CommandUtils.class, (String)"MSG_NoMoreDebugSession");
        NotifyDescriptor.Confirmation confirmation = new NotifyDescriptor.Confirmation((Object)string, 2);
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)confirmation) == NotifyDescriptor.OK_OPTION;
    }

    public static PhpUnit getPhpUnit(boolean bl) {
        try {
            return PhpUnit.getDefault();
        }
        catch (PhpProgram.InvalidPhpProgramException invalidPhpProgramException) {
            if (bl) {
                UiUtils.invalidScriptProvided((String)invalidPhpProgramException.getLocalizedMessage(), (String)"PhpUnit");
            }
            return null;
        }
    }

    public static List<FileObject> getFileObjects(Node[] nodeArray) {
        if (nodeArray.length == 0) {
            return Collections.emptyList();
        }
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>(nodeArray.length);
        for (Node node : nodeArray) {
            FileObject fileObject = CommandUtils.getFileObject(node);
            if (fileObject == null) continue;
            arrayList.add(fileObject);
        }
        return arrayList;
    }

    public static FileObject getFileObject(Node node) {
        assert (node != null);
        FileObject fileObject = (FileObject)node.getLookup().lookup(FileObject.class);
        if (fileObject != null && fileObject.isValid()) {
            return fileObject;
        }
        DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
        if (dataObject == null) {
            return null;
        }
        fileObject = dataObject.getPrimaryFile();
        if (fileObject != null && fileObject.isValid()) {
            return fileObject;
        }
        return null;
    }

    public static boolean isUnderSources(PhpProject phpProject, FileObject fileObject) {
        assert (phpProject != null);
        assert (fileObject != null);
        FileObject fileObject2 = ProjectPropertiesSupport.getSourcesDirectory(phpProject);
        return fileObject2.equals(fileObject) || FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject);
    }

    public static boolean isUnderTests(PhpProject phpProject, FileObject fileObject, boolean bl) {
        assert (phpProject != null);
        assert (fileObject != null);
        FileObject fileObject2 = ProjectPropertiesSupport.getTestDirectory(phpProject, bl);
        return fileObject2 != null && (fileObject2.equals(fileObject) || FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject));
    }

    public static boolean isUnderSelenium(PhpProject phpProject, FileObject fileObject, boolean bl) {
        assert (phpProject != null);
        assert (fileObject != null);
        FileObject fileObject2 = ProjectPropertiesSupport.getSeleniumDirectory(phpProject, bl);
        return fileObject2 != null && (fileObject2.equals(fileObject) || FileUtil.isParentOf((FileObject)fileObject2, (FileObject)fileObject));
    }

    public static boolean isUnderAnySourceGroup(PhpProject phpProject, FileObject fileObject, boolean bl) {
        return CommandUtils.isUnderSources(phpProject, fileObject) || CommandUtils.isUnderTests(phpProject, fileObject, bl) || CommandUtils.isUnderSelenium(phpProject, fileObject, bl);
    }

    public static FileObject[] filesForContext(Lookup lookup) {
        assert (lookup != null);
        Collection collection = lookup.lookupAll(FileObject.class);
        return collection.toArray(new FileObject[collection.size()]);
    }

    public static FileObject[] filesForContext(Lookup lookup, FileObject fileObject) {
        return CommandUtils.filterValidFiles(CommandUtils.filesForContext(lookup), fileObject);
    }

    public static FileObject[] filesForSelectedNodes() {
        Node[] nodeArray = CommandUtils.getSelectedNodes();
        if (nodeArray == null) {
            return new FileObject[0];
        }
        List<FileObject> list = CommandUtils.getFileObjects(nodeArray);
        return list.toArray(new FileObject[list.size()]);
    }

    public static FileObject[] filesForSelectedNodes(FileObject fileObject) {
        return CommandUtils.filterValidFiles(Arrays.asList(CommandUtils.filesForSelectedNodes()), fileObject);
    }

    public static FileObject fileForContextOrSelectedNodes(Lookup lookup, FileObject fileObject) {
        assert (fileObject != null);
        assert (fileObject.isFolder()) : "Folder must be given: " + fileObject;
        FileObject[] fileObjectArray = CommandUtils.filesForContext(lookup, fileObject);
        if (fileObjectArray == null || fileObjectArray.length == 0) {
            fileObjectArray = CommandUtils.filesForSelectedNodes(fileObject);
        }
        return fileObjectArray != null && fileObjectArray.length > 0 ? fileObjectArray[0] : null;
    }

    public static FileObject[] filesForContextOrSelectedNodes(Lookup lookup) {
        FileObject[] fileObjectArray = CommandUtils.filesForContext(lookup);
        if (fileObjectArray.length == 0) {
            fileObjectArray = CommandUtils.filesForSelectedNodes();
        }
        return fileObjectArray;
    }

    public static FileObject fileForContextOrSelectedNodes(Lookup lookup) {
        FileObject[] fileObjectArray = CommandUtils.filesForContextOrSelectedNodes(lookup);
        return fileObjectArray.length > 0 ? fileObjectArray[0] : null;
    }

    public static URL urlForProject(PhpProject phpProject) throws MalformedURLException {
        FileObject fileObject = ProjectPropertiesSupport.getWebRootDirectory(phpProject);
        FileObject fileObject2 = CommandUtils.fileForProject(phpProject, fileObject);
        return CommandUtils.urlForFile(phpProject, fileObject, fileObject2);
    }

    public static URL urlForDebugProject(PhpProject phpProject) throws MalformedURLException {
        DebugInfo debugInfo = CommandUtils.getDebugInfo(phpProject);
        URL uRL = CommandUtils.urlForProject(phpProject);
        if (debugInfo.debugServer) {
            uRL = CommandUtils.appendQuery(uRL, CommandUtils.getDebugArguments());
        }
        return uRL;
    }

    public static URL createDebugUrl(URL uRL) throws MalformedURLException {
        return CommandUtils.appendQuery(uRL, CommandUtils.getDebugArguments());
    }

    public static URL urlForContext(PhpProject phpProject, Lookup lookup) throws MalformedURLException {
        FileObject fileObject = ProjectPropertiesSupport.getWebRootDirectory(phpProject);
        FileObject fileObject2 = CommandUtils.fileForContextOrSelectedNodes(lookup, fileObject);
        return CommandUtils.urlForFile(phpProject, fileObject, fileObject2);
    }

    public static URL urlForDebugContext(PhpProject phpProject, Lookup lookup) throws MalformedURLException {
        DebugInfo debugInfo = CommandUtils.getDebugInfo(phpProject);
        URL uRL = CommandUtils.urlForContext(phpProject, lookup);
        if (debugInfo.debugServer) {
            uRL = CommandUtils.appendQuery(uRL, CommandUtils.getDebugArguments());
        }
        return uRL;
    }

    public static FileObject fileForProject(PhpProject phpProject, FileObject fileObject) {
        assert (fileObject != null);
        assert (fileObject.isFolder()) : "Folder must be given: " + fileObject;
        String string = ProjectPropertiesSupport.getIndexFile(phpProject);
        if (string != null) {
            return fileObject.getFileObject(string);
        }
        return fileObject;
    }

    public static DebugInfo getDebugInfo(PhpProject phpProject) {
        boolean bl = WebClientToolsProjectUtils.getServerDebugProperty((Project)phpProject);
        boolean bl2 = WebClientToolsProjectUtils.getClientDebugProperty((Project)phpProject);
        if (!WebClientToolsSessionStarterService.isAvailable()) {
            bl = true;
            bl2 = false;
        }
        assert (bl || bl2);
        return new DebugInfo(bl2, bl);
    }

    public static URL getBaseURL(PhpProject phpProject) throws MalformedURLException {
        String string = ProjectPropertiesSupport.getUrl(phpProject);
        if (string == null) {
            throw new MalformedURLException();
        }
        return new URL(string);
    }

    public static Command getCommand(PhpProject phpProject, String string) {
        PhpActionProvider phpActionProvider = (PhpActionProvider)phpProject.getLookup().lookup(PhpActionProvider.class);
        assert (phpActionProvider != null);
        return phpActionProvider.getCommand(string);
    }

    private static Node[] getSelectedNodes() {
        return TopComponent.getRegistry().getCurrentNodes();
    }

    private static URL urlForFile(PhpProject phpProject, FileObject fileObject, FileObject fileObject2) throws MalformedURLException {
        String string = null;
        if (fileObject2 == null) {
            string = "";
        } else {
            string = FileUtil.getRelativePath((FileObject)fileObject, (FileObject)fileObject2);
            assert (string != null) : String.format("WebRoot %s must be parent of file %s", fileObject, fileObject2);
        }
        URL uRL = new URL(CommandUtils.getBaseURL(phpProject), string);
        String string2 = ProjectPropertiesSupport.getArguments(phpProject);
        return string2 != null ? CommandUtils.appendQuery(uRL, string2) : uRL;
    }

    private static URL appendQuery(URL uRL, String string) throws MalformedURLException {
        assert (StringUtils.hasText((String)string));
        assert (!string.startsWith("&"));
        assert (!string.startsWith("?"));
        String string2 = uRL.toExternalForm();
        string2 = StringUtils.hasText((String)uRL.getQuery()) ? string2 + "&" + string : string2 + "?" + string;
        return new URL(string2);
    }

    private static String getDebugArguments() {
        return "XDEBUG_SESSION_START=" + PhpOptions.getInstance().getDebuggerSessionId();
    }

    private static FileObject[] filterValidFiles(FileObject[] fileObjectArray, FileObject fileObject) {
        return CommandUtils.filterValidFiles(Arrays.asList(fileObjectArray), fileObject);
    }

    private static FileObject[] filterValidFiles(Collection<? extends FileObject> collection, FileObject fileObject) {
        LinkedHashSet<FileObject> linkedHashSet = new LinkedHashSet<FileObject>();
        for (FileObject fileObject2 : collection) {
            if (!FileUtil.isParentOf((FileObject)fileObject, (FileObject)fileObject2) || FileUtil.toFile((FileObject)fileObject2) == null) {
                return null;
            }
            linkedHashSet.add(fileObject2);
        }
        return !linkedHashSet.isEmpty() ? linkedHashSet.toArray(new FileObject[linkedHashSet.size()]) : null;
    }

    public static final class DebugInfo {
        public final boolean debugClient;
        public final boolean debugServer;

        public DebugInfo(boolean bl, boolean bl2) {
            this.debugClient = bl;
            this.debugServer = bl2;
        }
    }
}

