/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.connections.sftp;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Logger;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Level;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.project.connections.RemoteException;
import org.netbeans.modules.php.project.connections.common.PasswordPanel;
import org.netbeans.modules.php.project.connections.sftp.MessagePanel;
import org.netbeans.modules.php.project.connections.sftp.SftpConfiguration;
import org.netbeans.modules.php.project.connections.spi.RemoteClient;
import org.netbeans.modules.php.project.connections.spi.RemoteFile;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SftpClient
implements RemoteClient {
    private static final java.util.logging.Logger LOGGER = java.util.logging.Logger.getLogger(SftpClient.class.getName());
    private static final Map<Integer, String> PASSWORDS = new HashMap<Integer, String>();
    private static final Map<Integer, String> PASSPHRASES = new HashMap<Integer, String>();
    private static final Map<Integer, Set<String>> MESSAGES = new HashMap<Integer, Set<String>>();
    private static final SftpLogger DEV_NULL_LOGGER = new DevNullLogger();
    private final SftpConfiguration configuration;
    private final SftpLogger sftpLogger;
    private Session sftpSession;
    private ChannelSftp sftpClient;

    public SftpClient(SftpConfiguration sftpConfiguration, InputOutput inputOutput) {
        assert (sftpConfiguration != null);
        this.configuration = sftpConfiguration;
        if (inputOutput != null) {
            this.sftpLogger = new SftpLogger(inputOutput);
            LOGGER.log(Level.FINE, "Protocol command listener added");
        } else {
            this.sftpLogger = DEV_NULL_LOGGER;
            LOGGER.log(Level.FINE, "No protocol command listener will be used");
        }
    }

    private void init() throws RemoteException {
        if (this.sftpClient != null && this.sftpClient.isConnected()) {
            LOGGER.log(Level.FINE, "SFTP client already created and connected");
            return;
        }
        LOGGER.log(Level.FINE, "SFTP client creating");
        String string = this.configuration.getHost();
        int n = this.configuration.getPort();
        int n2 = this.configuration.getTimeout() * 1000;
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Connecting to " + string + " [timeout: " + n2 + " ms]");
        }
        String string2 = this.configuration.getUserName();
        String string3 = this.configuration.getPassword();
        String string4 = this.configuration.getKnownHostsFile();
        String string5 = this.configuration.getIdentityFile();
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Login as " + string2);
        }
        JSch jSch = null;
        Channel channel = null;
        jSch = new JSch();
        try {
            JSch.setLogger((Logger)this.sftpLogger);
            this.sftpSession = jSch.getSession(string2, string, n);
            if (StringUtils.hasText((String)string4)) {
                jSch.setKnownHosts(string4);
            }
            if (StringUtils.hasText((String)string5)) {
                jSch.addIdentity(string5);
            }
            if (StringUtils.hasText((String)string3)) {
                this.sftpSession.setPassword(string3);
            }
            this.sftpSession.setUserInfo((UserInfo)new SftpUserInfo(this.configuration));
            this.sftpSession.setTimeout(n2);
            this.sftpSession.connect(n2);
            channel = this.sftpSession.openChannel("sftp");
            channel.connect();
            this.sftpClient = (ChannelSftp)channel;
        }
        catch (JSchException jSchException) {
            PASSWORDS.remove(this.configuration.hashCode());
            PASSPHRASES.remove(this.configuration.hashCode());
            MESSAGES.remove(this.configuration.hashCode());
            this.disconnect();
            LOGGER.log(Level.FINE, "Exception while connecting", jSchException);
            throw new RemoteException(NbBundle.getMessage(SftpClient.class, (String)"MSG_CannotConnect", (Object)this.configuration.getHost()), jSchException);
        }
    }

    @Override
    public void connect() throws RemoteException {
        this.init();
        assert (this.sftpClient.isConnected());
        try {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Remote server version is " + this.sftpClient.getServerVersion());
            }
        }
        catch (SftpException sftpException) {
            LOGGER.log(Level.FINE, "Exception while getting server version", sftpException);
        }
    }

    @Override
    public void disconnect() throws RemoteException {
        if (this.sftpSession == null) {
            LOGGER.log(Level.FINE, "Remote client not created yet => nothing to do");
            return;
        }
        LOGGER.log(Level.FINE, "Remote client trying to disconnect");
        if (this.sftpSession.isConnected()) {
            LOGGER.log(Level.FINE, "Remote client connected -> disconnecting");
            JSch.setLogger((Logger)DEV_NULL_LOGGER);
            this.sftpSession.disconnect();
            LOGGER.log(Level.FINE, "Remote client disconnected");
        }
        this.sftpClient = null;
        this.sftpSession = null;
        this.sftpLogger.info("QUIT");
        this.sftpLogger.info(NbBundle.getMessage(SftpClient.class, (String)"LOG_Goodbye"));
    }

    @Override
    public String getReplyString() {
        return null;
    }

    @Override
    public String getNegativeReplyString() {
        return null;
    }

    @Override
    public boolean isConnected() {
        if (this.sftpClient == null) {
            return false;
        }
        return this.sftpClient.isConnected();
    }

    @Override
    public String printWorkingDirectory() throws RemoteException {
        try {
            this.sftpLogger.info("PWD");
            String string = this.sftpClient.pwd();
            this.sftpLogger.info(string);
            return string;
        }
        catch (SftpException sftpException) {
            LOGGER.log(Level.FINE, "Error while pwd", sftpException);
            this.sftpLogger.error(sftpException.getLocalizedMessage());
            throw new RemoteException(NbBundle.getMessage(SftpClient.class, (String)"MSG_CannotPwd", (Object)this.configuration.getHost()), sftpException);
        }
    }

    @Override
    public boolean storeFile(String string, InputStream inputStream) throws RemoteException {
        try {
            this.sftpLogger.info("STOR " + string);
            this.sftpClient.put(inputStream, string);
            this.sftpLogger.info(NbBundle.getMessage(SftpClient.class, (String)"LOG_FileReceiveOk"));
            return true;
        }
        catch (SftpException sftpException) {
            LOGGER.log(Level.FINE, "Error while storing file " + string, sftpException);
            this.sftpLogger.error(sftpException.getLocalizedMessage());
            throw new RemoteException(NbBundle.getMessage(SftpClient.class, (String)"MSG_CannotStoreFile", (Object)string), sftpException);
        }
    }

    @Override
    public boolean deleteFile(String string) throws RemoteException {
        return this.delete(string, false);
    }

    @Override
    public boolean deleteDirectory(String string) throws RemoteException {
        return this.delete(string, true);
    }

    private boolean delete(String string, boolean bl) throws RemoteException {
        try {
            this.sftpLogger.info("DELE " + string);
            if (bl) {
                this.sftpClient.rmdir(string);
            } else {
                this.sftpClient.rm(string);
            }
            this.sftpLogger.info(NbBundle.getMessage(SftpClient.class, (String)"LOG_FileDeleteOk"));
            return true;
        }
        catch (SftpException sftpException) {
            LOGGER.log(Level.FINE, "Error while deleting file " + string, sftpException);
            this.sftpLogger.error(sftpException.getLocalizedMessage());
            return false;
        }
    }

    @Override
    public boolean rename(String string, String string2) throws RemoteException {
        try {
            this.sftpLogger.info("RNFR " + string);
            this.sftpLogger.info("RNTO " + string2);
            this.sftpClient.rename(string, string2);
            this.sftpLogger.info(NbBundle.getMessage(SftpClient.class, (String)"LOG_RenameSuccessful"));
            return true;
        }
        catch (SftpException sftpException) {
            LOGGER.log(Level.FINE, String.format("Error while renaming file %s -> %s", string, string2), sftpException);
            this.sftpLogger.error(sftpException.getLocalizedMessage());
            return false;
        }
    }

    @Override
    public List<RemoteFile> listFiles() throws RemoteException {
        ArrayList<RemoteFile> arrayList = null;
        String string = null;
        try {
            string = this.sftpClient.pwd();
            this.sftpLogger.info("LIST");
            this.sftpLogger.info(NbBundle.getMessage(SftpClient.class, (String)"LOG_DirListing"));
            Vector vector = this.sftpClient.ls(string);
            arrayList = new ArrayList<RemoteFile>(vector.size());
            for (ChannelSftp.LsEntry lsEntry : vector) {
                arrayList.add(new RemoteFileImpl(lsEntry));
            }
            this.sftpLogger.info(NbBundle.getMessage(SftpClient.class, (String)"LOG_DirectorySendOk"));
        }
        catch (SftpException sftpException) {
            LOGGER.log(Level.FINE, "Error while listing files for " + string, sftpException);
            this.sftpLogger.error(sftpException.getLocalizedMessage());
            throw new RemoteException(NbBundle.getMessage(SftpClient.class, (String)"MSG_CannotListFiles", (Object)string), sftpException);
        }
        return arrayList;
    }

    @Override
    public boolean retrieveFile(String string, OutputStream outputStream) throws RemoteException {
        try {
            this.sftpLogger.info("RETR " + string);
            this.sftpClient.get(string, outputStream);
            this.sftpLogger.info(NbBundle.getMessage(SftpClient.class, (String)"LOG_FileSendOk"));
            return true;
        }
        catch (SftpException sftpException) {
            LOGGER.log(Level.FINE, "Error while retrieving file " + string, sftpException);
            this.sftpLogger.error(sftpException.getLocalizedMessage());
            throw new RemoteException(NbBundle.getMessage(SftpClient.class, (String)"MSG_CannotStoreFile", (Object)string), sftpException);
        }
    }

    @Override
    public boolean changeWorkingDirectory(String string) throws RemoteException {
        try {
            this.sftpLogger.info("CWD " + string);
            this.sftpClient.cd(string);
            this.sftpLogger.info(NbBundle.getMessage(SftpClient.class, (String)"LOG_CdOk"));
            return true;
        }
        catch (SftpException sftpException) {
            LOGGER.log(Level.FINE, "Error while changing directory " + string, sftpException);
            this.sftpLogger.error(NbBundle.getMessage(SftpClient.class, (String)"LOG_CdKo"));
            return false;
        }
    }

    @Override
    public boolean makeDirectory(String string) throws RemoteException {
        try {
            this.sftpLogger.info("MKD " + string);
            this.sftpClient.mkdir(string);
            this.sftpLogger.info(NbBundle.getMessage(SftpClient.class, (String)"LOG_MkDirOk", (Object)string));
            return true;
        }
        catch (SftpException sftpException) {
            LOGGER.log(Level.FINE, "Error while creating directory " + string, sftpException);
            this.sftpLogger.error(sftpException.getLocalizedMessage());
            return false;
        }
    }

    @Override
    public int getPermissions(String string) throws RemoteException {
        int n = -1;
        try {
            this.sftpLogger.info("LIST " + string);
            this.sftpLogger.info(NbBundle.getMessage(SftpClient.class, (String)"LOG_DirListing"));
            ChannelSftp.LsEntry lsEntry = this.getFile(string);
            if (lsEntry != null) {
                n = lsEntry.getAttrs().getPermissions();
            }
            this.sftpLogger.info(NbBundle.getMessage(SftpClient.class, (String)"LOG_DirectorySendOk"));
        }
        catch (SftpException sftpException) {
            LOGGER.log(Level.FINE, "Error while getting permissions for " + string, sftpException);
        }
        return n;
    }

    @Override
    public boolean setPermissions(int n, String string) throws RemoteException {
        try {
            this.sftpLogger.info(String.format("chmod %d %s", n, string));
            this.sftpClient.chmod(n, string);
            this.sftpLogger.info(NbBundle.getMessage(SftpClient.class, (String)"LOG_ChmodOk"));
            return true;
        }
        catch (SftpException sftpException) {
            LOGGER.log(Level.FINE, "Error while setting permissions for " + string, sftpException);
            this.sftpLogger.error(sftpException.getLocalizedMessage());
            return false;
        }
    }

    @Override
    public boolean exists(String string, String string2) throws RemoteException {
        String string3 = string + "/" + string2;
        try {
            this.sftpClient.ls(string3);
            return true;
        }
        catch (SftpException sftpException) {
            LOGGER.log(Level.FINE, "Error while checking existence of " + string3, sftpException);
            return false;
        }
    }

    private ChannelSftp.LsEntry getFile(String string) throws SftpException {
        assert (string != null && string.trim().length() > 0);
        Vector vector = this.sftpClient.ls(string);
        LOGGER.fine(String.format("Exactly 1 file should be found for %s; found %d", string, vector.size()));
        if (vector.size() > 0) {
            return (ChannelSftp.LsEntry)vector.get(0);
        }
        return null;
    }

    static String getPasswordForUser(SftpConfiguration sftpConfiguration) {
        PasswordPanel passwordPanel;
        String string = PASSWORDS.get(sftpConfiguration.hashCode());
        if (string == null && (passwordPanel = PasswordPanel.forUser(sftpConfiguration.getDisplayName(), sftpConfiguration.getUserName())).open()) {
            string = passwordPanel.getPassword();
            PASSWORDS.put(sftpConfiguration.hashCode(), string);
        }
        return string;
    }

    static String getPasswordForCertificate(SftpConfiguration sftpConfiguration) {
        PasswordPanel passwordPanel;
        String string = PASSPHRASES.get(sftpConfiguration.hashCode());
        if (string == null && (passwordPanel = PasswordPanel.forCertificate(sftpConfiguration.getDisplayName())).open()) {
            string = passwordPanel.getPassword();
            PASSPHRASES.put(sftpConfiguration.hashCode(), string);
        }
        return string;
    }

    static void showMessageForConfiguration(SftpConfiguration sftpConfiguration, String string) {
        if (!StringUtils.hasText((String)string) || SftpClient.getMessages(sftpConfiguration).contains(string)) {
            return;
        }
        MessagePanel messagePanel = new MessagePanel(string);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)messagePanel, sftpConfiguration.getDisplayName(), true, new Object[]{NotifyDescriptor.OK_OPTION}, NotifyDescriptor.OK_OPTION, 0, null, null);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor) == NotifyDescriptor.OK_OPTION && messagePanel.doNotShowThisMessageAgain()) {
            SftpClient.getMessages(sftpConfiguration).add(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<String> getMessages(SftpConfiguration sftpConfiguration) {
        Set<String> set;
        Map<Integer, Set<String>> map = MESSAGES;
        synchronized (map) {
            set = MESSAGES.get(sftpConfiguration.hashCode());
            if (set == null) {
                set = new HashSet<String>();
                MESSAGES.put(sftpConfiguration.hashCode(), set);
            }
        }
        return set;
    }

    private static final class SftpUserInfo
    implements UserInfo,
    UIKeyboardInteractive {
        private final SftpConfiguration configuration;
        private volatile String passwd;
        private volatile String passphrase;

        public SftpUserInfo(SftpConfiguration sftpConfiguration) {
            assert (sftpConfiguration != null);
            this.configuration = sftpConfiguration;
        }

        public boolean promptYesNo(String string) {
            NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)string, NbBundle.getMessage(SftpClient.class, (String)"LBL_Warning"), 0, 2, new Object[]{NotifyDescriptor.YES_OPTION, NotifyDescriptor.NO_OPTION}, NotifyDescriptor.YES_OPTION);
            return DialogDisplayer.getDefault().notify(notifyDescriptor) == NotifyDescriptor.YES_OPTION;
        }

        public String getPassphrase() {
            return this.passphrase;
        }

        public boolean promptPassphrase(String string) {
            this.passphrase = SftpClient.getPasswordForCertificate(this.configuration);
            return this.passphrase != null;
        }

        public String getPassword() {
            return this.passwd;
        }

        public boolean promptPassword(String string) {
            this.passwd = SftpClient.getPasswordForUser(this.configuration);
            return this.passwd != null;
        }

        public void showMessage(String string) {
            SftpClient.showMessageForConfiguration(this.configuration, string);
        }

        public String[] promptKeyboardInteractive(String string, String string2, String string3, String[] stringArray, boolean[] blArray) {
            if (stringArray.length == 1 && blArray.length == 1 && !blArray[0]) {
                this.passwd = this.configuration.getPassword();
                if (!StringUtils.hasText((String)this.passwd)) {
                    this.passwd = SftpClient.getPasswordForUser(this.configuration);
                }
                if (StringUtils.hasText((String)this.passwd)) {
                    return new String[]{this.passwd};
                }
            }
            return null;
        }
    }

    private static final class DevNullLogger
    extends SftpLogger {
        public DevNullLogger() {
            super(null);
        }

        public boolean isEnabled(int n) {
            return false;
        }

        public void log(int n, String string) {
        }
    }

    private static class SftpLogger
    implements Logger {
        private final InputOutput io;

        public SftpLogger(InputOutput inputOutput) {
            this.io = inputOutput;
        }

        public boolean isEnabled(int n) {
            return n >= 1;
        }

        public void log(int n, String string) {
            assert (this.io != null);
            OutputWriter outputWriter = null;
            outputWriter = n <= 1 ? this.io.getOut() : this.io.getErr();
            outputWriter.println(string.trim());
            outputWriter.flush();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Command listener: " + string.trim());
            }
        }

        public void info(String string) {
            this.log(1, string);
        }

        public void error(String string) {
            this.log(3, string);
        }
    }

    private static final class RemoteFileImpl
    implements RemoteFile {
        private final ChannelSftp.LsEntry entry;

        public RemoteFileImpl(ChannelSftp.LsEntry lsEntry) {
            assert (lsEntry != null);
            this.entry = lsEntry;
        }

        public String getName() {
            return this.entry.getFilename();
        }

        public boolean isDirectory() {
            return this.entry.getAttrs().isDir();
        }

        public boolean isFile() {
            return !this.isDirectory();
        }

        public long getSize() {
            return this.entry.getAttrs().getSize();
        }
    }
}

