/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.api.jaxws.client;

import java.io.IOException;
import java.net.URL;
import java.util.List;
import org.netbeans.modules.websvc.jaxws.client.JAXWSClientSupportAccessor;
import org.netbeans.modules.websvc.spi.client.WebServicesClientSupportProvider;
import org.netbeans.modules.websvc.spi.jaxws.client.JAXWSClientSupportImpl;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public final class JAXWSClientSupport {
    private JAXWSClientSupportImpl impl;
    private static final Lookup.Result implementations = Lookup.getDefault().lookupResult(WebServicesClientSupportProvider.class);

    private JAXWSClientSupport(JAXWSClientSupportImpl jAXWSClientSupportImpl) {
        if (jAXWSClientSupportImpl == null) {
            throw new IllegalArgumentException();
        }
        this.impl = jAXWSClientSupportImpl;
    }

    public static JAXWSClientSupport getJaxWsClientSupport(FileObject fileObject) {
        if (fileObject == null) {
            throw new NullPointerException("Passed null to JAXWSClientSupport.getJAXWSClientSupport(FileObject)");
        }
        for (WebServicesClientSupportProvider webServicesClientSupportProvider : implementations.allInstances()) {
            JAXWSClientSupport jAXWSClientSupport = webServicesClientSupportProvider.findJAXWSClientSupport(fileObject);
            if (jAXWSClientSupport == null) continue;
            return jAXWSClientSupport;
        }
        return null;
    }

    public String addServiceClient(String string, String string2, String string3, boolean bl) {
        return this.impl.addServiceClient(string, string2, string3, bl);
    }

    public void removeServiceClient(String string) {
        this.impl.removeServiceClient(string);
    }

    public FileObject getWsdlFolder(boolean bl) throws IOException {
        return this.impl.getWsdlFolder(bl);
    }

    public FileObject getLocalWsdlFolderForClient(String string, boolean bl) {
        return this.impl.getLocalWsdlFolderForClient(string, bl);
    }

    public FileObject getBindingsFolderForClient(String string, boolean bl) {
        return this.impl.getBindingsFolderForClient(string, bl);
    }

    public URL getCatalog() {
        return this.impl.getCatalog();
    }

    public List getServiceClients() {
        return this.impl.getServiceClients();
    }

    public String getServiceRefName(Node node) {
        return this.impl.getServiceRefName(node);
    }

    static {
        JAXWSClientSupportAccessor.DEFAULT = new JAXWSClientSupportAccessor(){

            public JAXWSClientSupport createJAXWSClientSupport(JAXWSClientSupportImpl jAXWSClientSupportImpl) {
                return new JAXWSClientSupport(jAXWSClientSupportImpl);
            }

            public JAXWSClientSupportImpl getJAXWSClientSupportImpl(JAXWSClientSupport jAXWSClientSupport) {
                return jAXWSClientSupport == null ? null : jAXWSClientSupport.impl;
            }
        };
    }
}

