/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.kenai.ui;

import java.io.IOException;
import java.net.URL;
import java.util.logging.Logger;
import javax.swing.Icon;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.kenai.ui.SourceHandleImpl;
import org.netbeans.modules.kenai.ui.spi.NbProjectHandle;
import org.netbeans.modules.project.ui.api.UnloadedProjectInformation;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;

public class NbProjectHandleImpl
extends NbProjectHandle {
    private Icon icon;
    private String displayName;
    URL url;
    private SourceHandleImpl parent;

    NbProjectHandleImpl(Project project, SourceHandleImpl sourceHandleImpl) throws IOException {
        this.displayName = ProjectUtils.getInformation((Project)project).getDisplayName();
        this.icon = ProjectUtils.getInformation((Project)project).getIcon();
        this.url = project.getProjectDirectory().getURL();
        project.getProjectDirectory().addFileChangeListener((FileChangeListener)new FileChangeAdapter(){

            public void fileDeleted(FileEvent fileEvent) {
                try {
                    if (fileEvent.getFile().getURL().equals(NbProjectHandleImpl.this.url)) {
                        NbProjectHandleImpl.this.remove();
                    }
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    // empty catch block
                }
            }
        });
        this.parent = sourceHandleImpl;
        assert (this.parent != null);
        assert (this.displayName != null);
        assert (this.icon != null);
        assert (this.url != null);
    }

    NbProjectHandleImpl(UnloadedProjectInformation unloadedProjectInformation, SourceHandleImpl sourceHandleImpl) {
        this.displayName = unloadedProjectInformation.getDisplayName();
        this.icon = unloadedProjectInformation.getIcon();
        this.url = unloadedProjectInformation.getURL();
        this.parent = sourceHandleImpl;
        assert (this.parent != null);
        assert (this.displayName != null);
        assert (this.icon != null);
        assert (this.url != null);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public Project getProject() {
        try {
            FileObject fileObject = URLMapper.findFileObject((URL)this.url);
            if (fileObject == null) {
                return null;
            }
            Project project = ProjectManager.getDefault().findProject(fileObject);
            if (project == null) {
                Logger.getLogger(NbProjectHandleImpl.class.getName()).severe("Cannot find project for " + fileObject.getPath());
            }
            return project;
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Exceptions.printStackTrace((Throwable)illegalArgumentException);
        }
        return null;
    }

    public void remove() {
        this.parent.remove(this);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        NbProjectHandleImpl nbProjectHandleImpl = (NbProjectHandleImpl)object;
        return this.url == nbProjectHandleImpl.url || this.url != null && this.url.equals(nbProjectHandleImpl.url);
    }

    public int hashCode() {
        int n = 3;
        n = 67 * n + (this.url != null ? this.url.hashCode() : 0);
        return n;
    }
}

