/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.history;

import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.util.HashSet;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.ui.history.RepositoryRevision;
import org.netbeans.modules.subversion.ui.history.RevisionNodeChildren;
import org.netbeans.modules.subversion.ui.history.SearchHistoryPanel;
import org.netbeans.modules.subversion.ui.history.SummaryView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

class RevisionNode
extends AbstractNode {
    static final String COLUMN_NAME_NAME = "name";
    static final String COLUMN_NAME_DATE = "date";
    static final String COLUMN_NAME_USERNAME = "username";
    static final String COLUMN_NAME_MESSAGE = "message";
    private RepositoryRevision.Event event;
    private RepositoryRevision container;
    private String path;

    public RevisionNode(RepositoryRevision repositoryRevision, SearchHistoryPanel searchHistoryPanel) {
        super((Children)new RevisionNodeChildren(repositoryRevision, searchHistoryPanel), Lookups.fixed((Object[])new Object[]{searchHistoryPanel, repositoryRevision}));
        this.container = repositoryRevision;
        this.event = null;
        this.path = null;
        this.setName(repositoryRevision.getLog().getRevision().getNumber() + NbBundle.getMessage(RevisionNode.class, (String)"LBL_NumberOfChangedPaths", (Object)repositoryRevision.getLog().getChangedPaths().length));
        this.initProperties();
    }

    public RevisionNode(RepositoryRevision.Event event, SearchHistoryPanel searchHistoryPanel) {
        super(Children.LEAF, Lookups.fixed((Object[])new Object[]{searchHistoryPanel, event}));
        this.path = event.getChangedPath().getPath();
        this.event = event;
        this.setName(event.getName());
        this.initProperties();
    }

    RepositoryRevision.Event getRevision() {
        return this.event;
    }

    RepositoryRevision getContainer() {
        return this.container;
    }

    RepositoryRevision.Event getEvent() {
        return this.event;
    }

    public String getShortDescription() {
        return this.path;
    }

    public Action[] getActions(boolean bl) {
        if (bl) {
            return null;
        }
        if (this.event == null) {
            return new Action[]{SystemAction.get(RevertModificationsAction.class)};
        }
        return new Action[]{new RollbackAction(), SystemAction.get(RevertModificationsAction.class)};
    }

    private void initProperties() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = Sheet.createPropertiesSet();
        set.put((Node.Property)new DateProperty());
        set.put((Node.Property)new UsernameProperty());
        set.put((Node.Property)new MessageProperty());
        sheet.put(set);
        this.setSheet(sheet);
    }

    private static class RevisionPropertyEditor
    extends PropertyEditorSupport {
        private static final JLabel renderer = new JLabel();

        public RevisionPropertyEditor(String string) {
            this.setValue(string);
        }

        public void paintValue(Graphics graphics, Rectangle rectangle) {
            renderer.setForeground(graphics.getColor());
            renderer.setText((String)this.getValue());
            renderer.setBounds(rectangle);
            renderer.paint(graphics);
        }

        public boolean isPaintable() {
            return true;
        }

        static {
            renderer.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        }
    }

    private static class RevertModificationsAction
    extends NodeAction {
        private RevertModificationsAction() {
        }

        protected void performAction(Node[] nodeArray) {
            HashSet<RepositoryRevision.Event> hashSet = new HashSet<RepositoryRevision.Event>();
            HashSet<RepositoryRevision> hashSet2 = new HashSet<RepositoryRevision>();
            for (Node node : nodeArray) {
                RevisionNode revisionNode = (RevisionNode)node;
                if (revisionNode.event != null) {
                    hashSet.add(revisionNode.event);
                    continue;
                }
                hashSet2.add(revisionNode.container);
            }
            SearchHistoryPanel searchHistoryPanel = (SearchHistoryPanel)nodeArray[0].getLookup().lookup(SearchHistoryPanel.class);
            SummaryView.revert(searchHistoryPanel, hashSet2.toArray(new RepositoryRevision[hashSet2.size()]), hashSet.toArray(new RepositoryRevision.Event[hashSet.size()]));
        }

        protected boolean enable(Node[] nodeArray) {
            return true;
        }

        public String getName() {
            return NbBundle.getMessage(RevisionNode.class, (String)"CTL_Action_RollbackChange");
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(RevertModificationsAction.class);
        }
    }

    private class RollbackAction
    extends AbstractAction {
        public RollbackAction() {
            this.putValue("Name", NbBundle.getMessage(RevisionNode.class, (String)"CTL_Action_RollbackTo", (Object)RevisionNode.this.event.getLogInfoHeader().getLog().getRevision().getNumber()));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SummaryView.rollback(RevisionNode.this.event);
        }
    }

    private class MessageProperty
    extends CommitNodeProperty {
        public MessageProperty() {
            super(RevisionNode.COLUMN_NAME_MESSAGE, String.class, RevisionNode.COLUMN_NAME_MESSAGE, RevisionNode.COLUMN_NAME_MESSAGE);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            if (RevisionNode.this.event == null) {
                return RevisionNode.this.container.getLog().getMessage();
            }
            return "";
        }
    }

    private class DateProperty
    extends CommitNodeProperty {
        public DateProperty() {
            super(RevisionNode.COLUMN_NAME_DATE, String.class, RevisionNode.COLUMN_NAME_DATE, RevisionNode.COLUMN_NAME_DATE);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            if (RevisionNode.this.event == null) {
                return DateFormat.getDateTimeInstance().format(RevisionNode.this.container.getLog().getDate());
            }
            return "";
        }
    }

    private class UsernameProperty
    extends CommitNodeProperty {
        public UsernameProperty() {
            super(RevisionNode.COLUMN_NAME_USERNAME, String.class, RevisionNode.COLUMN_NAME_USERNAME, RevisionNode.COLUMN_NAME_USERNAME);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            if (RevisionNode.this.event == null) {
                return RevisionNode.this.container.getLog().getAuthor();
            }
            return "";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class CommitNodeProperty<T>
    extends PropertySupport.ReadOnly<T> {
        protected CommitNodeProperty(String string, Class<T> clazz, String string2, String string3) {
            super(string, clazz, string2, string3);
        }

        public String toString() {
            try {
                return this.getValue().toString();
            }
            catch (Exception exception) {
                Subversion.LOG.log(Level.INFO, null, exception);
                return exception.getLocalizedMessage();
            }
        }

        public PropertyEditor getPropertyEditor() {
            try {
                return new RevisionPropertyEditor((String)this.getValue());
            }
            catch (Exception exception) {
                return super.getPropertyEditor();
            }
        }
    }
}

