/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion;

import java.awt.EventQueue;
import java.io.File;
import java.util.HashSet;
import org.netbeans.modules.subversion.Subversion;
import org.netbeans.modules.subversion.client.SvnClientExceptionHandler;
import org.tigris.subversion.svnclientadapter.SVNClientException;

public final class WorkingCopyAttributesCache {
    private static WorkingCopyAttributesCache instance;
    private HashSet<String> unsupportedWorkingCopies = new HashSet(5);

    public static WorkingCopyAttributesCache getInstance() {
        if (instance == null) {
            instance = new WorkingCopyAttributesCache();
            instance.init();
        }
        return instance;
    }

    private WorkingCopyAttributesCache() {
    }

    private void init() {
    }

    public void logUnsupportedWC(final SVNClientException sVNClientException, File file) throws SVNClientException {
        String string = file.getAbsolutePath();
        if (!this.isInUnsupportedWorkingCopies(string)) {
            File file2 = Subversion.getInstance().getTopmostManagedAncestor(file);
            this.unsupportedWorkingCopies.add(file2.getAbsolutePath());
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    SvnClientExceptionHandler.notifyException((Exception)((Object)sVNClientException), true, true);
                }
            });
        }
        throw sVNClientException;
    }

    public boolean isInUnsupportedWorkingCopies(String string) {
        for (String string2 : this.unsupportedWorkingCopies) {
            if (!string.startsWith(string2)) continue;
            return true;
        }
        return false;
    }
}

