/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.runtime.load;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jruby.nb.Ruby;
import org.jruby.nb.ast.executable.Script;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.jruby.nb.runtime.load.Library;
import org.jruby.nb.runtime.load.LoadServiceResource;
import org.jruby.nb.util.JRubyClassLoader;
import org.objectweb.asm.ClassReader;

public class JavaCompiledScript
implements Library {
    private final LoadServiceResource resource;

    public JavaCompiledScript(LoadServiceResource loadServiceResource) {
        this.resource = loadServiceResource;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void load(Ruby ruby, boolean bl) {
        InputStream inputStream = null;
        try {
            try {
                inputStream = new BufferedInputStream(this.resource.getURL().openStream());
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] byArray = new byte[8196];
                int n = 0;
                while ((n = inputStream.read(byArray)) != -1) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
                byArray = byteArrayOutputStream.toByteArray();
                JRubyClassLoader jRubyClassLoader = ruby.getJRubyClassLoader();
                ClassReader classReader = new ClassReader(byArray);
                String string = classReader.getClassName().replace('/', '.');
                Class<?> clazz = null;
                try {
                    clazz = jRubyClassLoader.loadClass(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    clazz = jRubyClassLoader.defineClass(string, byArray);
                }
                if (Script.class.isAssignableFrom(clazz)) {
                    ((Script)clazz.newInstance()).load(ruby.getCurrentContext(), ruby.getTopSelf(), IRubyObject.NULL_ARRAY, Block.NULL_BLOCK);
                }
            }
            catch (IOException iOException) {
                throw ruby.newIOErrorFromException(iOException);
            }
            catch (InstantiationException instantiationException) {
                throw ruby.newLoadError("Error loading compiled script: " + instantiationException);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw ruby.newLoadError("Error loading compiled script: " + illegalAccessException);
            }
            Object var13_15 = null;
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            try {
                inputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                throw ruby.newIOErrorFromException(iOException);
            }
        }
        try {}
        catch (IOException iOException) {
            throw ruby.newIOErrorFromException(iOException);
        }
        inputStream.close();
    }
}

