/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ant.freeform;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.ant.freeform.FreeformProject;
import org.netbeans.modules.ant.freeform.spi.support.Util;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyProvider;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.ErrorManager;
import org.openide.util.Parameters;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class FreeformEvaluator
implements PropertyEvaluator,
AntProjectListener,
PropertyChangeListener {
    private final FreeformProject project;
    private PropertyEvaluator delegate;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private final Set<PropertyEvaluator> intermediateEvaluators = new HashSet<PropertyEvaluator>();
    private final Object privateLock = new Object();

    public FreeformEvaluator(FreeformProject freeformProject) throws IOException {
        this.project = freeformProject;
        this.init();
        freeformProject.helper().addAntProjectListener((AntProjectListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() throws IOException {
        PropertyEvaluator propertyEvaluator = this.initEval();
        Object object = this.privateLock;
        synchronized (object) {
            if (this.delegate != null) {
                this.delegate.removePropertyChangeListener((PropertyChangeListener)this);
            }
            propertyEvaluator.addPropertyChangeListener((PropertyChangeListener)this);
            this.delegate = propertyEvaluator;
        }
        if (org.netbeans.modules.ant.freeform.Util.err.isLoggable(1)) {
            org.netbeans.modules.ant.freeform.Util.err.log("properties for " + this.project.getProjectDirectory() + ": " + this.delegate.getProperties());
        }
    }

    private PropertyEvaluator initEval() throws IOException {
        Iterator<PropertyEvaluator> iterator = this.intermediateEvaluators.iterator();
        while (iterator.hasNext()) {
            iterator.next().removePropertyChangeListener((PropertyChangeListener)this);
            iterator.remove();
        }
        PropertyProvider propertyProvider = this.project.helper().getStockPropertyPreprovider();
        ArrayList<PropertyProvider> arrayList = new ArrayList<PropertyProvider>();
        Element element = this.project.getPrimaryConfigurationData();
        Element element2 = Util.findElement(element, "properties", "http://www.netbeans.org/ns/freeform-project/2");
        if (element2 != null) {
            for (Element element3 : Util.findSubElements(element2)) {
                String string;
                if (element3.getLocalName().equals("property")) {
                    string = Util.findText(element3);
                    if (string == null) {
                        string = "";
                    }
                    arrayList.add(PropertyUtils.fixedPropertyProvider(Collections.singletonMap(element3.getAttribute("name"), string)));
                    continue;
                }
                assert (element3.getLocalName().equals("property-file")) : element3;
                string = Util.findText(element3);
                if (string.contains("${")) {
                    PropertyEvaluator propertyEvaluator = PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)propertyProvider, (PropertyProvider[])arrayList.toArray(new PropertyProvider[arrayList.size()]));
                    string = propertyEvaluator.evaluate(string);
                    propertyEvaluator.addPropertyChangeListener((PropertyChangeListener)this);
                    this.intermediateEvaluators.add(propertyEvaluator);
                }
                arrayList.add(PropertyUtils.propertiesFilePropertyProvider((File)this.project.helper().resolveFile(string)));
            }
        }
        return PropertyUtils.sequentialPropertyEvaluator((PropertyProvider)propertyProvider, (PropertyProvider[])arrayList.toArray(new PropertyProvider[arrayList.size()]));
    }

    public String getProperty(String string) {
        return this.delegate.getProperty(string);
    }

    public String evaluate(String string) {
        return this.delegate.evaluate(string);
    }

    public Map<String, String> getProperties() {
        return this.delegate.getProperties();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        Parameters.notNull((CharSequence)"listener", (Object)propertyChangeListener);
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        Parameters.notNull((CharSequence)"listener", (Object)propertyChangeListener);
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    public void configurationXmlChanged(AntProjectEvent antProjectEvent) {
        this.fireAnyChange();
    }

    private void fireAnyChange() {
        try {
            this.init();
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(65536, (Throwable)iOException);
        }
        catch (RuntimeException runtimeException) {
            ErrorManager.getDefault().notify(65536, (Throwable)runtimeException);
        }
        this.pcs.firePropertyChange(null, null, null);
    }

    public void propertiesChanged(AntProjectEvent antProjectEvent) {
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object = propertyChangeEvent.getSource();
        assert (object instanceof PropertyEvaluator) : object;
        if (this.intermediateEvaluators.contains(object)) {
            this.fireAnyChange();
        } else {
            assert (object == this.delegate) : "Got change from " + object + " rather than current delegate " + this.delegate;
            this.pcs.firePropertyChange(propertyChangeEvent.getPropertyName(), null, null);
        }
    }
}

