/*
 * Decompiled with CFR 0.152.
 */
package org.openide.awt;

import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.openide.awt.Notification;
import org.openide.awt.StatusDisplayer;
import org.openide.util.Lookup;

public abstract class NotificationDisplayer {
    public static NotificationDisplayer getDefault() {
        NotificationDisplayer notificationDisplayer = (NotificationDisplayer)Lookup.getDefault().lookup(NotificationDisplayer.class);
        if (null == notificationDisplayer) {
            notificationDisplayer = new SimpleNotificationDisplayer();
        }
        return notificationDisplayer;
    }

    public Notification notify(String string, Icon icon, String string2, ActionListener actionListener) {
        return this.notify(string, icon, string2, actionListener, Priority.NORMAL);
    }

    public abstract Notification notify(String var1, Icon var2, String var3, ActionListener var4, Priority var5);

    public abstract Notification notify(String var1, Icon var2, JComponent var3, JComponent var4, Priority var5);

    private static class NotificationImpl
    extends Notification {
        private final StatusDisplayer.Message msg;

        public NotificationImpl(StatusDisplayer.Message message) {
            this.msg = message;
        }

        public void clear() {
            this.msg.clear(0);
        }
    }

    private static class SimpleNotificationDisplayer
    extends NotificationDisplayer {
        private SimpleNotificationDisplayer() {
        }

        public Notification notify(String string, Icon icon, String string2, ActionListener actionListener, Priority priority) {
            return this.notify(string + " - " + string2, priority);
        }

        public Notification notify(String string, Icon icon, JComponent jComponent, JComponent jComponent2, Priority priority) {
            return this.notify(string, priority);
        }

        private Notification notify(String string, Priority priority) {
            int n = 1;
            switch (priority) {
                case HIGH: {
                    n = 100;
                    break;
                }
                case NORMAL: {
                    n = 50;
                    break;
                }
                case LOW: 
                case SILENT: {
                    n = 1;
                }
            }
            StatusDisplayer.Message message = StatusDisplayer.getDefault().setStatusText(string, n);
            return new NotificationImpl(message);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Priority {
        HIGH,
        NORMAL,
        LOW,
        SILENT;

    }
}

