/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.actions;

import com.sun.jdi.VMDisconnectedException;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.openide.util.RequestProcessor;

abstract class JPDADebuggerAction
extends ActionsProviderSupport
implements PropertyChangeListener {
    private JPDADebugger debugger;
    private boolean canApplyLazyEnabled = false;

    JPDADebuggerAction(JPDADebugger jPDADebugger) {
        this.debugger = jPDADebugger;
        jPDADebugger.addPropertyChangeListener("state", (PropertyChangeListener)this);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        try {
            this.checkEnabled(this.debugger.getState());
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
    }

    protected abstract void checkEnabled(int var1);

    protected final void checkEnabledLazySingleAction(final int n, RequestProcessor requestProcessor) {
        this.canApplyLazyEnabled = true;
        requestProcessor.post(new Runnable(){

            public void run() {
                final boolean bl = JPDADebuggerAction.this.checkEnabledLazyImpl(n);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (JPDADebuggerAction.this.canApplyLazyEnabled) {
                            JPDADebuggerAction.this.setEnabledSingleAction(bl);
                            JPDADebuggerAction.this.canApplyLazyEnabled = true;
                        }
                    }
                });
            }
        });
    }

    protected boolean checkEnabledLazyImpl(int n) {
        return false;
    }

    protected final void setEnabledSingleAction(boolean bl) {
        this.canApplyLazyEnabled = false;
        this.setEnabled(this.getActions().iterator().next(), bl);
    }

    JPDADebugger getDebuggerImpl() {
        return this.debugger;
    }
}

