/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.refactoring;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Set;
import java.util.StringTokenizer;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.ui.OpenProjects;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RetoucheUtils {
    private static final String JAVA_MIME_TYPE = "text/x-java";

    public static String htmlize(String string) {
        String string2 = string.replace("<", "&lt;");
        string2 = string2.replace(">", "&gt;");
        return string2;
    }

    public static Collection<ExecutableElement> getOverridenMethods(ExecutableElement executableElement, CompilationInfo compilationInfo) {
        return RetoucheUtils.getOverridenMethods(executableElement, SourceUtils.getEnclosingTypeElement((Element)executableElement), compilationInfo);
    }

    private static Collection<ExecutableElement> getOverridenMethods(ExecutableElement executableElement, TypeElement typeElement, CompilationInfo compilationInfo) {
        ArrayList<ExecutableElement> arrayList = new ArrayList<ExecutableElement>();
        TypeMirror typeMirror = typeElement.getSuperclass();
        if (typeMirror.getKind() == TypeKind.DECLARED) {
            TypeElement typeElement2 = (TypeElement)((DeclaredType)typeMirror).asElement();
            ExecutableElement annotatedConstruct = RetoucheUtils.getMethod(executableElement, typeElement2, compilationInfo);
            arrayList.addAll(RetoucheUtils.getOverridenMethods(executableElement, typeElement2, compilationInfo));
            if (annotatedConstruct != null) {
                arrayList.add(annotatedConstruct);
            }
        }
        for (TypeMirror typeMirror2 : typeElement.getInterfaces()) {
            TypeElement typeElement2 = (TypeElement)((DeclaredType)typeMirror2).asElement();
            ExecutableElement executableElement2 = RetoucheUtils.getMethod(executableElement, typeElement2, compilationInfo);
            arrayList.addAll(RetoucheUtils.getOverridenMethods(executableElement, typeElement2, compilationInfo));
            if (executableElement2 == null) continue;
            arrayList.add(executableElement2);
        }
        return arrayList;
    }

    private static ExecutableElement getMethod(ExecutableElement executableElement, TypeElement typeElement, CompilationInfo compilationInfo) {
        for (ExecutableElement executableElement2 : ElementFilter.methodsIn(typeElement.getEnclosedElements())) {
            if (!compilationInfo.getElements().overrides(executableElement, executableElement2, typeElement)) continue;
            return executableElement2;
        }
        return null;
    }

    public static Collection<ExecutableElement> getOverridingMethods(ExecutableElement executableElement, CompilationInfo compilationInfo) {
        ArrayList<ExecutableElement> arrayList = new ArrayList<ExecutableElement>();
        TypeElement typeElement = (TypeElement)executableElement.getEnclosingElement();
        Set set = compilationInfo.getClasspathInfo().getClassIndex().getElements(ElementHandle.create((Element)typeElement), EnumSet.of(ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.of(ClassIndex.SearchScope.SOURCE));
        for (ElementHandle elementHandle : set) {
            TypeElement typeElement2 = (TypeElement)elementHandle.resolve(compilationInfo);
            for (ExecutableElement executableElement2 : ElementFilter.methodsIn(typeElement2.getEnclosedElements())) {
                if (!compilationInfo.getElements().overrides(executableElement2, executableElement, typeElement2)) continue;
                arrayList.add(executableElement2);
            }
        }
        return arrayList;
    }

    public static boolean isJavaFile(FileObject fileObject) {
        return JAVA_MIME_TYPE.equals(fileObject.getMIMEType());
    }

    public static boolean isFromLibrary(Element element, ClasspathInfo classpathInfo) {
        SourceUtils.getFile((Element)element, (ClasspathInfo)classpathInfo);
        return FileUtil.getArchiveFile((FileObject)SourceUtils.getFile((Element)element, (ClasspathInfo)classpathInfo)) != null;
    }

    public static boolean isValidPackageName(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        while (stringTokenizer.hasMoreTokens()) {
            if (Utilities.isJavaIdentifier((String)stringTokenizer.nextToken())) continue;
            return false;
        }
        return true;
    }

    public static boolean isFileInOpenProject(FileObject fileObject) {
        assert (fileObject != null);
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        return OpenProjects.getDefault().isProjectOpen(project);
    }

    public static boolean isOnSourceClasspath(FileObject fileObject) {
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return false;
        }
        Project[] projectArray = OpenProjects.getDefault().getOpenProjects();
        for (int i = 0; i < projectArray.length; ++i) {
            if (!project.equals(projectArray[i]) && !projectArray[i].equals(project)) continue;
            SourceGroup[] sourceGroupArray = ProjectUtils.getSources((Project)project).getSourceGroups("java");
            for (int j = 0; j < sourceGroupArray.length; ++j) {
                if (fileObject == sourceGroupArray[j].getRootFolder()) {
                    return true;
                }
                if (!FileUtil.isParentOf((FileObject)sourceGroupArray[j].getRootFolder(), (FileObject)fileObject)) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static boolean isClasspathRoot(FileObject fileObject) {
        return fileObject.equals(ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source").findOwnerRoot(fileObject));
    }

    public static boolean isRefactorable(FileObject fileObject) {
        return RetoucheUtils.isJavaFile(fileObject) && RetoucheUtils.isFileInOpenProject(fileObject) && RetoucheUtils.isOnSourceClasspath(fileObject);
    }

    public static String getPackageName(FileObject fileObject) {
        assert (fileObject.isFolder()) : "argument must be folder";
        return ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/source").getResourceName(fileObject, '.', false);
    }

    public static String getPackageName(URL uRL) {
        FileObject fileObject = URLMapper.findFileObject((URL)uRL);
        if (fileObject != null) {
            return RetoucheUtils.getPackageName(fileObject);
        }
        File file = new File(uRL.getPath());
        do {
            FileObject fileObject2;
            if ((fileObject2 = FileUtil.toFileObject((File)file)) == null) continue;
            return RetoucheUtils.getPackageName(fileObject2);
        } while ((file = file.getParentFile()) != null);
        throw new IllegalArgumentException("Cannot create package name for url " + uRL);
    }

    public static FileObject getOrCreateFolder(URL uRL) throws IOException {
        try {
            FileObject fileObject = URLMapper.findFileObject((URL)uRL);
            if (fileObject != null) {
                return fileObject;
            }
            File file = new File(uRL.toURI());
            fileObject = FileUtil.createFolder((File)file);
            return fileObject;
        }
        catch (URISyntaxException uRISyntaxException) {
            throw (IOException)new IOException().initCause(uRISyntaxException);
        }
    }
}

