/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.csl.hints.infrastructure;

import java.util.ArrayList;
import java.util.Collections;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintsProvider;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.csl.core.Language;
import org.netbeans.modules.csl.core.LanguageRegistry;
import org.netbeans.modules.csl.hints.infrastructure.GsfHintsManager;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.CursorMovedSchedulerEvent;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.ParserResultTask;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.HintsController;
import org.openide.filesystems.FileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuggestionsTask
extends ParserResultTask<ParserResult> {
    private static final Logger LOG = Logger.getLogger(SuggestionsTask.class.getName());
    private boolean cancelled = false;

    public void run(ParserResult parserResult, SchedulerEvent schedulerEvent) {
        this.resume();
        FileObject fileObject = parserResult.getSnapshot().getSource().getFileObject();
        if (fileObject == null || this.isCancelled()) {
            return;
        }
        if (!(schedulerEvent instanceof CursorMovedSchedulerEvent) || this.isCancelled()) {
            return;
        }
        CursorMovedSchedulerEvent cursorMovedSchedulerEvent = (CursorMovedSchedulerEvent)schedulerEvent;
        int[] nArray = new int[]{Math.min(cursorMovedSchedulerEvent.getMarkOffset(), cursorMovedSchedulerEvent.getCaretOffset()), Math.max(cursorMovedSchedulerEvent.getMarkOffset(), cursorMovedSchedulerEvent.getCaretOffset())};
        if (nArray != null && nArray.length == 2 && nArray[0] != -1 && nArray[1] != -1 && nArray[0] != nArray[1]) {
            HintsController.setErrors((FileObject)fileObject, (String)SuggestionsTask.class.getName(), Collections.emptyList());
            return;
        }
        final int n = cursorMovedSchedulerEvent.getCaretOffset();
        if (n == -1 || this.isCancelled()) {
            return;
        }
        try {
            ParserManager.parse(Collections.singleton(parserResult.getSnapshot().getSource()), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    Parser.Result result = resultIterator.getParserResult(n);
                    if (!(result instanceof ParserResult)) {
                        return;
                    }
                    Language language = LanguageRegistry.getInstance().getLanguageByMimeType(result.getSnapshot().getMimeType());
                    if (language == null || SuggestionsTask.this.isCancelled()) {
                        return;
                    }
                    HintsProvider hintsProvider = language.getHintsProvider();
                    if (hintsProvider == null || SuggestionsTask.this.isCancelled()) {
                        return;
                    }
                    GsfHintsManager gsfHintsManager = language.getHintsManager();
                    if (gsfHintsManager == null || SuggestionsTask.this.isCancelled()) {
                        return;
                    }
                    RuleContext ruleContext = gsfHintsManager.createRuleContext((ParserResult)result, language, n, -1, -1);
                    if (ruleContext == null || SuggestionsTask.this.isCancelled()) {
                        return;
                    }
                    ArrayList<ErrorDescription> arrayList = new ArrayList<ErrorDescription>();
                    ArrayList<Hint> arrayList2 = new ArrayList<Hint>();
                    hintsProvider.computeSuggestions(gsfHintsManager, ruleContext, arrayList2, n);
                    for (int i = 0; i < arrayList2.size(); ++i) {
                        Hint hint = (Hint)arrayList2.get(i);
                        if (SuggestionsTask.this.isCancelled()) {
                            return;
                        }
                        ErrorDescription errorDescription = gsfHintsManager.createDescription(hint, ruleContext, false, i == arrayList2.size() - 1);
                        arrayList.add(errorDescription);
                    }
                    if (SuggestionsTask.this.isCancelled()) {
                        return;
                    }
                    HintsController.setErrors((FileObject)result.getSnapshot().getSource().getFileObject(), (String)SuggestionsTask.class.getName(), arrayList);
                }
            });
        }
        catch (ParseException parseException) {
            LOG.log(Level.WARNING, null, parseException);
        }
    }

    public int getPriority() {
        return Integer.MAX_VALUE;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return Scheduler.CURSOR_SENSITIVE_TASK_SCHEDULER;
    }

    public synchronized void cancel() {
        this.cancelled = true;
    }

    private synchronized void resume() {
        this.cancelled = false;
    }

    private synchronized boolean isCancelled() {
        return this.cancelled;
    }
}

