/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.model.adapter;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;
import org.netbeans.modules.vmd.game.model.Editable;
import org.netbeans.modules.vmd.game.model.Sequence;
import org.netbeans.modules.vmd.game.model.SequenceContainer;
import org.netbeans.modules.vmd.game.model.SequenceContainerListener;
import org.netbeans.modules.vmd.game.model.SequenceListener;
import org.netbeans.modules.vmd.game.model.adapter.SceneLayerTableAdapter;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceContainerTableAdapter
implements TableModel,
SequenceContainerListener,
SequenceListener,
PropertyChangeListener {
    private static final int COLS = 4;
    private static final int COL_DEFAULT = 0;
    private static final int COL_NAME = 1;
    private static final int COL_FRAMES = 2;
    private static final int COL_DELAY = 3;
    private SequenceContainer sequenceContainer;
    private ArrayList listeners = new ArrayList();

    public SequenceContainerTableAdapter(SequenceContainer sequenceContainer) {
        this.sequenceContainer = sequenceContainer;
        this.sequenceContainer.addSequenceContainerListener(this);
        this.sequenceContainer.addPropertyChangeListener(this);
        for (Sequence sequence : this.sequenceContainer.getSequences()) {
            sequence.addSequenceListener(this);
            sequence.addPropertyChangeListener(this);
        }
    }

    @Override
    public int getRowCount() {
        return this.sequenceContainer.getSequenceCount();
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return NbBundle.getMessage(SequenceContainerTableAdapter.class, (String)"SequenceContainerTableAdapter.columnDefault.txt");
            }
            case 1: {
                return NbBundle.getMessage(SequenceContainerTableAdapter.class, (String)"SequenceContainerTableAdapter.columnName.txt");
            }
            case 2: {
                return NbBundle.getMessage(SequenceContainerTableAdapter.class, (String)"SequenceContainerTableAdapter.columnFrames.txt");
            }
            case 3: {
                return NbBundle.getMessage(SequenceContainerTableAdapter.class, (String)"SequenceContainerTableAdapter.columnDelay.txt");
            }
        }
        return "???";
    }

    @Override
    public Class<?> getColumnClass(int n) {
        switch (n) {
            case 0: {
                return Boolean.class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return Short.class;
            }
            case 3: {
                return Integer.class;
            }
        }
        return Object.class;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        switch (n2) {
            case 0: {
                return true;
            }
            case 1: {
                return true;
            }
            case 2: {
                return false;
            }
            case 3: {
                return true;
            }
        }
        return false;
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Sequence sequence = this.sequenceContainer.getSequenceAt(n);
        if (sequence == null) {
            return null;
        }
        switch (n2) {
            case 0: {
                return this.sequenceContainer.getDefaultSequence() == sequence;
            }
            case 1: {
                return sequence.getName();
            }
            case 2: {
                return sequence.getFrameCount();
            }
            case 3: {
                return sequence.getFrameMs();
            }
        }
        return null;
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        Sequence sequence = this.sequenceContainer.getSequenceAt(n);
        switch (n2) {
            case 0: {
                this.sequenceContainer.setDefaultSequence(sequence);
                break;
            }
            case 1: {
                String string = (String)object;
                if (!this.sequenceContainer.getGameDesign().isComponentNameAvailable(string)) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(SceneLayerTableAdapter.class, (String)"SequenceContainerTableAdapter.noRenameDialog.txt", (Object)string), 0));
                    break;
                }
                sequence.setName(string);
                break;
            }
            case 3: {
                sequence.setFrameMs((Integer)object);
            }
        }
    }

    @Override
    public void addTableModelListener(TableModelListener tableModelListener) {
        this.listeners.add(tableModelListener);
    }

    @Override
    public void removeTableModelListener(TableModelListener tableModelListener) {
        this.listeners.remove(tableModelListener);
    }

    @Override
    public void sequenceAdded(SequenceContainer sequenceContainer, Sequence sequence, int n) {
        TableModelEvent tableModelEvent = new TableModelEvent(this, n, n, -1, 1);
        sequence.addPropertyChangeListener(this);
        sequence.addSequenceListener(this);
        this.fireTableChanged(tableModelEvent);
    }

    @Override
    public void sequenceRemoved(SequenceContainer sequenceContainer, Sequence sequence, int n) {
        TableModelEvent tableModelEvent = new TableModelEvent(this, n, n, -1, -1);
        sequence.removePropertyChangeListener(this);
        sequence.removeSequenceListener(this);
        this.fireTableChanged(tableModelEvent);
    }

    @Override
    public void sequenceMoved(SequenceContainer sequenceContainer, Sequence sequence, int n, int n2) {
        this.sequenceRemoved(sequenceContainer, sequence, n);
        this.sequenceAdded(sequenceContainer, sequence, n2);
    }

    private void fireTableChanged(TableModelEvent tableModelEvent) {
        for (TableModelListener tableModelListener : this.listeners) {
            tableModelListener.tableChanged(tableModelEvent);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object;
        Editable editable;
        if (propertyChangeEvent.getSource() instanceof Sequence) {
            editable = (Sequence)propertyChangeEvent.getSource();
            int n = this.sequenceContainer.indexOf((Sequence)editable);
            object = new TableModelEvent(this, n, n, -1, 0);
            this.fireTableChanged((TableModelEvent)object);
        }
        if (propertyChangeEvent.getSource() instanceof SequenceContainer) {
            editable = (SequenceContainer)propertyChangeEvent.getSource();
            if (propertyChangeEvent.getPropertyName().equals("sequencecontainer.prop.defaultsequence")) {
                Sequence sequence = (Sequence)propertyChangeEvent.getOldValue();
                object = (Sequence)propertyChangeEvent.getNewValue();
                int n = this.sequenceContainer.indexOf(sequence);
                int n2 = this.sequenceContainer.indexOf((Sequence)object);
                TableModelEvent tableModelEvent = new TableModelEvent(this, n, n, -1, 0);
                this.fireTableChanged(tableModelEvent);
                tableModelEvent = new TableModelEvent(this, n2, n2, -1, 0);
                this.fireTableChanged(tableModelEvent);
            }
        }
    }

    @Override
    public void frameAdded(Sequence sequence, int n) {
        int n2 = this.sequenceContainer.indexOf(sequence);
        TableModelEvent tableModelEvent = new TableModelEvent(this, n2, n2, -1, 1);
        this.fireTableChanged(tableModelEvent);
    }

    @Override
    public void frameRemoved(Sequence sequence, int n) {
        int n2 = this.sequenceContainer.indexOf(sequence);
        TableModelEvent tableModelEvent = new TableModelEvent(this, n2, n2, -1, 1);
        this.fireTableChanged(tableModelEvent);
    }

    @Override
    public void frameModified(Sequence sequence, int n) {
    }

    @Override
    public void framesChanged(Sequence sequence) {
        TableModelEvent tableModelEvent = new TableModelEvent(this);
        this.fireTableChanged(tableModelEvent);
    }
}

