/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.main;

import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.file.CacheFSInfo;
import com.sun.tools.javac.file.JavacFileManager;
import com.sun.tools.javac.jvm.Target;
import com.sun.tools.javac.main.CommandLine;
import com.sun.tools.javac.main.JavaCompiler;
import com.sun.tools.javac.main.JavacOption;
import com.sun.tools.javac.main.RecognizedOptions;
import com.sun.tools.javac.processing.AnnotationProcessingError;
import com.sun.tools.javac.util.ClientCodeException;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.FatalError;
import com.sun.tools.javac.util.JavacMessages;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.PropagatedException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.MissingResourceException;
import javax.annotation.processing.Processor;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Main {
    String ownName;
    PrintWriter out;
    boolean fatalErrors;
    static final int EXIT_OK = 0;
    static final int EXIT_ERROR = 1;
    static final int EXIT_CMDERR = 2;
    static final int EXIT_SYSERR = 3;
    static final int EXIT_ABNORMAL = 4;
    private JavacOption.Option[] recognizedOptions = RecognizedOptions.getJavaCompilerOptions(new RecognizedOptions.OptionHelper(){

        public void setOut(PrintWriter out) {
            Main.this.out = out;
        }

        public void error(String key, Object ... args) {
            Main.this.error(key, args);
        }

        public void printVersion() {
            Log.printLines(Main.this.out, Main.getLocalizedString("version", Main.this.ownName, JavaCompiler.version()));
        }

        public void printFullVersion() {
            Log.printLines(Main.this.out, Main.getLocalizedString("fullVersion", Main.this.ownName, JavaCompiler.fullVersion()));
        }

        public void printHelp() {
            Main.this.help();
        }

        public void printXhelp() {
            Main.this.xhelp();
        }

        public void addFile(File f) {
            if (!Main.this.filenames.contains(f)) {
                Main.this.filenames.append(f);
            }
        }

        public void addClassName(String s) {
            Main.this.classnames.append(s);
        }
    });
    private Options options = null;
    public ListBuffer<File> filenames = null;
    public ListBuffer<String> classnames = null;
    private JavaFileManager fileManager;
    private static final String javacBundleName = "com.sun.tools.javac.resources.javac";
    private static JavacMessages messages;

    public Main(String name) {
        this(name, new PrintWriter(System.err, true));
    }

    public Main(String name, PrintWriter out) {
        this.ownName = name;
        this.out = out;
    }

    void help() {
        Log.printLines(this.out, Main.getLocalizedString("msg.usage.header", this.ownName));
        for (int i = 0; i < this.recognizedOptions.length; ++i) {
            this.recognizedOptions[i].help(this.out);
        }
        this.out.println();
    }

    void xhelp() {
        for (int i = 0; i < this.recognizedOptions.length; ++i) {
            this.recognizedOptions[i].xhelp(this.out);
        }
        this.out.println();
        Log.printLines(this.out, Main.getLocalizedString("msg.usage.nonstandard.footer", new Object[0]));
    }

    void error(String key, Object ... args) {
        if (this.fatalErrors) {
            String msg = Main.getLocalizedString(key, args);
            throw new PropagatedException(new IllegalStateException(msg));
        }
        this.warning(key, args);
        Log.printLines(this.out, Main.getLocalizedString("msg.usage", this.ownName));
    }

    void warning(String key, Object ... args) {
        Log.printLines(this.out, this.ownName + ": " + Main.getLocalizedString(key, args));
    }

    public JavacOption.Option getOption(String flag) {
        for (JavacOption.Option option : this.recognizedOptions) {
            if (!option.matches(flag)) continue;
            return option;
        }
        return null;
    }

    public void setOptions(Options options) {
        if (options == null) {
            throw new NullPointerException();
        }
        this.options = options;
    }

    public void setFatalErrors(boolean fatalErrors) {
        this.fatalErrors = fatalErrors;
    }

    public List<File> processArgs(String[] flags) {
        Target target;
        int ac = 0;
        while (ac < flags.length) {
            String flag = flags[ac];
            ++ac;
            JavacOption.Option option = null;
            if (flag.length() > 0) {
                int firstOptionToCheck;
                for (int j = firstOptionToCheck = flag.charAt(0) == '-' ? 0 : this.recognizedOptions.length - 1; j < this.recognizedOptions.length; ++j) {
                    if (!this.recognizedOptions[j].matches(flag)) continue;
                    option = this.recognizedOptions[j];
                    break;
                }
            }
            if (option == null) {
                this.error("err.invalid.flag", flag);
                return null;
            }
            if (option.hasArg()) {
                if (ac == flags.length) {
                    this.error("err.req.arg", flag);
                    return null;
                }
                String operand = flags[ac];
                ++ac;
                if (!option.process(this.options, flag, operand)) continue;
                return null;
            }
            if (!option.process(this.options, flag)) continue;
            return null;
        }
        if (!this.checkDirectory("-d")) {
            return null;
        }
        if (!this.checkDirectory("-s")) {
            return null;
        }
        String sourceString = this.options.get("-source");
        Source source = sourceString != null ? Source.lookup(sourceString) : Source.DEFAULT;
        String targetString = this.options.get("-target");
        Target target2 = target = targetString != null ? Target.lookup(targetString) : Target.DEFAULT;
        if (Character.isDigit(target.name.charAt(0))) {
            if (target.compareTo(source.requiredTarget()) < 0) {
                if (targetString != null) {
                    if (sourceString == null) {
                        this.warning("warn.target.default.source.conflict", targetString, source.requiredTarget().name);
                    } else {
                        this.warning("warn.source.target.conflict", sourceString, source.requiredTarget().name);
                    }
                    return null;
                }
                this.options.put("-target", source.requiredTarget().name);
            } else if (targetString == null && !source.allowGenerics()) {
                this.options.put("-target", Target.JDK1_4.name);
            }
        }
        return this.filenames.toList();
    }

    private boolean checkDirectory(String optName) {
        String value = this.options.get(optName);
        if (value == null) {
            return true;
        }
        File file = new File(value);
        if (!file.exists()) {
            this.error("err.dir.not.found", value);
            return false;
        }
        if (!file.isDirectory()) {
            this.error("err.file.not.directory", value);
            return false;
        }
        return true;
    }

    public int compile(String[] args) {
        Context context = new Context();
        JavacFileManager.preRegister(context);
        int result = this.compile(args, context);
        if (this.fileManager instanceof JavacFileManager) {
            ((JavacFileManager)this.fileManager).close();
        }
        return result;
    }

    public int compile(String[] args, Context context) {
        return this.compile(args, context, List.<JavaFileObject>nil(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int compile(String[] args, Context context, List<JavaFileObject> fileObjects, Iterable<? extends Processor> processors) {
        if (this.options == null) {
            this.options = Options.instance(context);
        }
        this.filenames = new ListBuffer();
        this.classnames = new ListBuffer();
        JavaCompiler comp = null;
        try {
            block45: {
                int n;
                block46: {
                    try {
                        boolean batchMode;
                        boolean forceStdOut;
                        List<File> files;
                        block43: {
                            block44: {
                                block42: {
                                    int n2;
                                    if (args.length == 0 && fileObjects.isEmpty()) {
                                        this.help();
                                        int n3 = 2;
                                        Object var15_16 = null;
                                        if (comp != null) {
                                            comp.close();
                                        }
                                        this.filenames = null;
                                        this.options = null;
                                        return n3;
                                    }
                                    try {
                                        files = this.processArgs(CommandLine.parse(args));
                                        if (files != null) break block42;
                                        n2 = 2;
                                    }
                                    catch (FileNotFoundException e) {
                                        Log.printLines(this.out, this.ownName + ": " + Main.getLocalizedString("err.file.not.found", e.getMessage()));
                                        int n4 = 3;
                                        Object var15_20 = null;
                                        if (comp != null) {
                                            comp.close();
                                        }
                                        this.filenames = null;
                                        this.options = null;
                                        return n4;
                                    }
                                    Object var15_17 = null;
                                    if (comp != null) {
                                        comp.close();
                                    }
                                    this.filenames = null;
                                    this.options = null;
                                    return n2;
                                }
                                if (!files.isEmpty() || !fileObjects.isEmpty() || !this.classnames.isEmpty()) break block43;
                                if (this.options.get("-help") == null && this.options.get("-X") == null && this.options.get("-version") == null && this.options.get("-fullversion") == null) break block44;
                                int n5 = 0;
                                Object var15_18 = null;
                                if (comp != null) {
                                    comp.close();
                                }
                                this.filenames = null;
                                this.options = null;
                                return n5;
                            }
                            this.error("err.no.source.files", new Object[0]);
                            int n6 = 2;
                            Object var15_19 = null;
                            if (comp != null) {
                                comp.close();
                            }
                            this.filenames = null;
                            this.options = null;
                            return n6;
                        }
                        boolean bl = forceStdOut = this.options.get("stdout") != null;
                        if (forceStdOut) {
                            this.out.flush();
                            this.out = new PrintWriter(System.out, true);
                        }
                        context.put(Log.outKey, this.out);
                        boolean bl2 = batchMode = this.options.get("nonBatchMode") == null && System.getProperty("nonBatchMode") == null;
                        if (batchMode) {
                            CacheFSInfo.preRegister(context);
                        }
                        this.fileManager = context.get(JavaFileManager.class);
                        comp = JavaCompiler.instance(context);
                        if (comp == null) {
                            int n7 = 3;
                            Object var15_21 = null;
                            if (comp != null) {
                                comp.close();
                            }
                            this.filenames = null;
                            this.options = null;
                            return n7;
                        }
                        Log log = Log.instance(context);
                        if (!files.isEmpty()) {
                            comp = JavaCompiler.instance(context);
                            List<JavaFileObject> otherFiles = List.nil();
                            JavacFileManager dfm = (JavacFileManager)this.fileManager;
                            for (JavaFileObject javaFileObject : dfm.getJavaFileObjectsFromFiles(files)) {
                                otherFiles = otherFiles.prepend(javaFileObject);
                            }
                            for (JavaFileObject javaFileObject : otherFiles) {
                                fileObjects = fileObjects.prepend(javaFileObject);
                            }
                        }
                        comp.compile(fileObjects, this.classnames.toList(), processors);
                        if (log.expectDiagKeys != null) {
                            if (log.expectDiagKeys.size() == 0) {
                                Log.printLines(log.noticeWriter, "all expected diagnostics found");
                                int n8 = 0;
                                Object var15_22 = null;
                                if (comp != null) {
                                    comp.close();
                                }
                                this.filenames = null;
                                this.options = null;
                                return n8;
                            }
                            Log.printLines(log.noticeWriter, "expected diagnostic keys not found: " + log.expectDiagKeys);
                            int n9 = 1;
                            Object var15_23 = null;
                            if (comp != null) {
                                comp.close();
                            }
                            this.filenames = null;
                            this.options = null;
                            return n9;
                        }
                        if (comp.errorCount() == 0) break block45;
                        n = 1;
                        Object var15_24 = null;
                        if (comp == null) break block46;
                    }
                    catch (IOException ex) {
                        this.ioMessage(ex);
                        int n10 = 3;
                        Object var15_26 = null;
                        if (comp != null) {
                            comp.close();
                        }
                        this.filenames = null;
                        this.options = null;
                        return n10;
                    }
                    catch (OutOfMemoryError ex) {
                        this.resourceMessage(ex);
                        int n11 = 3;
                        Object var15_27 = null;
                        if (comp != null) {
                            comp.close();
                        }
                        this.filenames = null;
                        this.options = null;
                        return n11;
                    }
                    catch (StackOverflowError ex) {
                        this.resourceMessage(ex);
                        int n12 = 3;
                        Object var15_28 = null;
                        if (comp != null) {
                            comp.close();
                        }
                        this.filenames = null;
                        this.options = null;
                        return n12;
                    }
                    catch (FatalError ex) {
                        this.feMessage(ex);
                        int n13 = 3;
                        Object var15_29 = null;
                        if (comp != null) {
                            comp.close();
                        }
                        this.filenames = null;
                        this.options = null;
                        return n13;
                    }
                    catch (AnnotationProcessingError ex) {
                        this.apMessage(ex);
                        int n14 = 3;
                        Object var15_30 = null;
                        if (comp != null) {
                            comp.close();
                        }
                        this.filenames = null;
                        this.options = null;
                        return n14;
                    }
                    catch (ClientCodeException ex) {
                        throw new RuntimeException(ex.getCause());
                    }
                    catch (PropagatedException ex) {
                        throw ex.getCause();
                    }
                    catch (Throwable ex) {
                        if (comp == null || comp.errorCount() == 0 || this.options == null || this.options.get("dev") != null) {
                            this.bugMessage(ex);
                        }
                        int n15 = 4;
                        Object var15_31 = null;
                        if (comp != null) {
                            comp.close();
                        }
                        this.filenames = null;
                        this.options = null;
                        return n15;
                    }
                    comp.close();
                }
                this.filenames = null;
                this.options = null;
                return n;
            }
            Object var15_25 = null;
            if (comp != null) {
                comp.close();
            }
            this.filenames = null;
            this.options = null;
            return 0;
        }
        catch (Throwable throwable) {
            Object var15_32 = null;
            if (comp != null) {
                comp.close();
            }
            this.filenames = null;
            this.options = null;
            throw throwable;
        }
    }

    void bugMessage(Throwable ex) {
        Log.printLines(this.out, Main.getLocalizedString("msg.bug", JavaCompiler.version()));
        ex.printStackTrace(this.out);
    }

    void feMessage(Throwable ex) {
        Log.printLines(this.out, ex.getMessage());
    }

    void ioMessage(Throwable ex) {
        Log.printLines(this.out, Main.getLocalizedString("msg.io", new Object[0]));
        ex.printStackTrace(this.out);
    }

    void resourceMessage(Throwable ex) {
        Log.printLines(this.out, Main.getLocalizedString("msg.resource", new Object[0]));
        ex.printStackTrace(this.out);
    }

    void apMessage(AnnotationProcessingError ex) {
        Log.printLines(this.out, Main.getLocalizedString("msg.proc.annotation.uncaught.exception", new Object[0]));
        ex.getCause().printStackTrace();
    }

    public static String getLocalizedString(String key, Object ... args) {
        try {
            if (messages == null) {
                messages = new JavacMessages(javacBundleName);
            }
            return messages.getLocalizedString("javac." + key, args);
        }
        catch (MissingResourceException e) {
            throw new Error("Fatal Error: Resource for javac is missing", e);
        }
    }

    public static void useRawMessages(boolean enable) {
        messages = enable ? new JavacMessages(javacBundleName){

            public String getLocalizedString(String key, Object ... args) {
                return key;
            }
        } : new JavacMessages(javacBundleName);
    }
}

