/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.actions;

import java.awt.Component;
import java.awt.Container;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Stack;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.text.JTextComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.shared.dependency.tree.DependencyNode;
import org.apache.maven.shared.dependency.tree.traversal.DependencyNodeVisitor;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.project.libraries.LibraryManager;
import org.netbeans.api.validation.adapters.DialogDescriptorAdapter;
import org.netbeans.api.validation.adapters.NotificationLineSupportAdapter;
import org.netbeans.modules.maven.dependencies.CheckNode;
import org.netbeans.modules.maven.dependencies.CheckNodeListener;
import org.netbeans.modules.maven.dependencies.CheckRenderer;
import org.netbeans.validation.api.Problems;
import org.netbeans.validation.api.Validator;
import org.netbeans.validation.api.builtin.Validators;
import org.netbeans.validation.api.ui.ValidationGroup;
import org.netbeans.validation.api.ui.ValidationUI;
import org.openide.DialogDescriptor;
import org.openide.NotificationLineSupport;
import org.openide.awt.Mnemonics;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateLibraryPanel
extends JPanel {
    private DependencyNode rootnode;
    private NotificationLineSupport line;
    private DialogDescriptor dd;
    private ValidationGroup vg;
    private JCheckBox cbCopy;
    private JCheckBox cbJavadocSource;
    private JComboBox comManager;
    private JScrollPane jScrollPane1;
    private JLabel lblIncludes;
    private JLabel lblManager;
    private JLabel lblName;
    private JTree trDeps;
    private JTextField txtName;

    CreateLibraryPanel(DependencyNode dependencyNode) {
        this.initComponents();
        DefaultComboBoxModel<LibraryManager> defaultComboBoxModel = new DefaultComboBoxModel<LibraryManager>();
        this.txtName.putClientProperty("_name", NbBundle.getMessage(CreateLibraryPanel.class, (String)"NAME_Library"));
        for (LibraryManager libraryManager : LibraryManager.getOpenManagers()) {
            defaultComboBoxModel.addElement(libraryManager);
        }
        this.comManager.setModel(defaultComboBoxModel);
        this.comManager.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (CreateLibraryPanel.this.vg != null) {
                    CreateLibraryPanel.this.vg.validateAll();
                }
            }
        });
        this.comManager.setRenderer(new DefaultListCellRenderer(){

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                LibraryManager libraryManager = (LibraryManager)object;
                return super.getListCellRendererComponent((JList<?>)jList, libraryManager.getDisplayName(), n, bl, bl2);
            }
        });
        this.trDeps.setCellRenderer(new CheckRenderer(false));
        CheckNodeListener checkNodeListener = new CheckNodeListener(false);
        this.trDeps.addMouseListener(checkNodeListener);
        this.trDeps.addKeyListener(checkNodeListener);
        this.trDeps.setToggleClickCount(0);
        this.trDeps.setRootVisible(false);
        this.trDeps.setModel(new DefaultTreeModel(new DefaultMutableTreeNode()));
        this.rootnode = dependencyNode;
        this.trDeps.setModel(new DefaultTreeModel(this.createDependenciesList()));
        this.setLibraryName();
    }

    void createValidations(DialogDescriptor dialogDescriptor) {
        this.line = dialogDescriptor.createNotificationLineSupport();
        this.dd = dialogDescriptor;
        this.vg = ValidationGroup.create((ValidationUI[])new ValidationUI[]{new NotificationLineSupportAdapter(this.line), new DialogDescriptorAdapter(dialogDescriptor)});
        this.vg.add((JTextComponent)this.txtName, new Validator[]{Validators.merge((boolean)true, (Validator[])new Validator[]{Validators.REQUIRE_NON_EMPTY_STRING, new LibraryNameExists()})});
    }

    private TreeNode createDependenciesList() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode(null, true);
        Visitor visitor = new Visitor(defaultMutableTreeNode);
        this.rootnode.accept((DependencyNodeVisitor)visitor);
        return defaultMutableTreeNode;
    }

    private void setLibraryName() {
        LibraryManager libraryManager = (LibraryManager)this.comManager.getSelectedItem();
        String string = this.getLibraryName();
        int n = 0;
        while (string.trim().length() == 0 || libraryManager.getLibrary(string.trim()) != null) {
            string = this.rootnode.getArtifact().getArtifactId();
            if (n > 0) {
                string = string + n;
            }
            ++n;
        }
        if (!string.equals(this.getLibraryName())) {
            this.txtName.setText(string);
        }
    }

    private void initComponents() {
        this.lblManager = new JLabel();
        this.comManager = new JComboBox();
        this.lblName = new JLabel();
        this.txtName = new JTextField();
        this.cbCopy = new JCheckBox();
        this.lblIncludes = new JLabel();
        this.cbJavadocSource = new JCheckBox();
        this.jScrollPane1 = new JScrollPane();
        this.trDeps = new JTree();
        this.lblManager.setLabelFor(this.comManager);
        Mnemonics.setLocalizedText((JLabel)this.lblManager, (String)NbBundle.getMessage(CreateLibraryPanel.class, (String)"CreateLibraryPanel.lblManager.text"));
        this.comManager.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.lblName.setLabelFor(this.txtName);
        Mnemonics.setLocalizedText((JLabel)this.lblName, (String)NbBundle.getMessage(CreateLibraryPanel.class, (String)"CreateLibraryPanel.lblName.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.cbCopy, (String)NbBundle.getMessage(CreateLibraryPanel.class, (String)"CreateLibraryPanel.cbCopy.text"));
        Mnemonics.setLocalizedText((JLabel)this.lblIncludes, (String)NbBundle.getMessage(CreateLibraryPanel.class, (String)"CreateLibraryPanel.lblIncludes.text"));
        this.cbJavadocSource.setSelected(true);
        Mnemonics.setLocalizedText((AbstractButton)this.cbJavadocSource, (String)NbBundle.getMessage(CreateLibraryPanel.class, (String)"CreateLibraryPanel.cbJavadocSource.text"));
        this.jScrollPane1.setViewportView(this.trDeps);
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add(2, (GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(2).add(1, (Component)this.cbCopy, -1, 397, Short.MAX_VALUE).add(1, (Component)this.jScrollPane1, -1, 397, Short.MAX_VALUE).add(1, (Component)this.cbJavadocSource).add(1, (GroupLayout.Group)groupLayout.createSequentialGroup().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.lblManager).add((Component)this.lblName)).addPreferredGap(0).add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.txtName, -1, 267, Short.MAX_VALUE).add((Component)this.comManager, 0, 267, Short.MAX_VALUE))).add(1, (Component)this.lblIncludes, -2, 177, -2)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblManager).add((Component)this.comManager, -2, -1, -2)).add(18, 18, 18).add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblName).add((Component)this.txtName, -2, -1, -2)).addPreferredGap(1).add((Component)this.cbCopy).add(25, 25, 25).add((Component)this.lblIncludes).addPreferredGap(0).add((Component)this.jScrollPane1, -1, 154, Short.MAX_VALUE).addPreferredGap(1).add((Component)this.cbJavadocSource).add(16, 16, 16)));
    }

    LibraryManager getLibraryManager() {
        return (LibraryManager)this.comManager.getSelectedItem();
    }

    String getLibraryName() {
        String string = this.txtName.getText().trim();
        return string;
    }

    boolean isAllSourceAndJavadoc() {
        return this.cbJavadocSource.isSelected();
    }

    String getCopyDirectory() {
        if (!this.cbCopy.isSelected()) {
            return null;
        }
        String string = this.getLibraryName();
        return string;
    }

    List<Artifact> getIncludeArtifacts() {
        Object object = this.trDeps.getModel().getRoot();
        int n = this.trDeps.getModel().getChildCount(object);
        ArrayList<Artifact> arrayList = new ArrayList<Artifact>();
        for (int i = 0; i < n; ++i) {
            CheckNode checkNode = (CheckNode)this.trDeps.getModel().getChild(object, i);
            if (!checkNode.isSelected()) continue;
            Artifact artifact = (Artifact)checkNode.getUserObject();
            arrayList.add(artifact);
        }
        return arrayList;
    }

    private static int getScopeOrder(String string) {
        if (string == null) {
            return 10;
        }
        if (string.equals(Artifact.SCOPE_COMPILE)) {
            return 5;
        }
        if (string.equals(Artifact.SCOPE_RUNTIME)) {
            return 4;
        }
        if (string.equals(Artifact.SCOPE_TEST)) {
            return 3;
        }
        return 0;
    }

    private class Visitor
    implements DependencyNodeVisitor {
        private DefaultMutableTreeNode rootNode;
        private DependencyNode root;
        private Stack<DependencyNode> path;
        private Icon icn = ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)"org/netbeans/modules/maven/TransitiveDependencyIcon.png", (boolean)true));
        private Icon icn2 = ImageUtilities.image2Icon((Image)ImageUtilities.loadImage((String)"org/netbeans/modules/maven/DependencyIcon.png", (boolean)true));

        Visitor(DefaultMutableTreeNode defaultMutableTreeNode) {
            this.rootNode = defaultMutableTreeNode;
        }

        public boolean visit(DependencyNode dependencyNode) {
            if (this.root == null) {
                this.root = dependencyNode;
                this.path = new Stack();
                Artifact artifact = dependencyNode.getArtifact();
                String string = artifact.getGroupId() + ":" + artifact.getArtifactId();
                CheckNode checkNode = new CheckNode(artifact, string, this.icn2);
                checkNode.setSelected(true);
                this.rootNode.add(checkNode);
                return true;
            }
            if (dependencyNode.getState() == 0) {
                Artifact artifact = dependencyNode.getArtifact();
                String string = artifact.getGroupId() + ":" + artifact.getArtifactId() + " [" + artifact.getScope() + "]";
                CheckNode checkNode = new CheckNode(artifact, string, this.path.size() > 0 ? this.icn : this.icn2);
                checkNode.setSelected(CreateLibraryPanel.getScopeOrder(artifact.getScope()) > 3);
                this.rootNode.add(checkNode);
            }
            this.path.push(dependencyNode);
            return true;
        }

        public boolean endVisit(DependencyNode dependencyNode) {
            if (this.root == dependencyNode) {
                this.root = null;
                this.path = null;
                return true;
            }
            this.path.pop();
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LibraryNameExists
    implements Validator<String> {
        private LibraryNameExists() {
        }

        public boolean validate(Problems problems, String string, String string2) {
            String string3;
            LibraryManager libraryManager = (LibraryManager)CreateLibraryPanel.this.comManager.getSelectedItem();
            if (libraryManager.getLibrary(string3 = string2.trim()) != null) {
                problems.add(NbBundle.getMessage(CreateLibraryPanel.class, (String)"ERR_NameExists"));
                return false;
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Comp
    implements Comparator<Artifact> {
        private Comp() {
        }

        @Override
        public int compare(Artifact artifact, Artifact artifact2) {
            int n;
            int n2;
            String string = artifact.getScope();
            String string2 = artifact2.getScope();
            int n3 = CreateLibraryPanel.getScopeOrder(string);
            if (n3 > (n2 = CreateLibraryPanel.getScopeOrder(string2))) {
                return -1;
            }
            if (n2 > n3) {
                return 1;
            }
            int n4 = artifact.getDependencyTrail().size();
            if (n4 > (n = artifact2.getDependencyTrail().size())) {
                return -1;
            }
            if (n > n4) {
                return 1;
            }
            return artifact.getId().compareTo(artifact2.getId());
        }
    }
}

