/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.node;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import org.netbeans.api.db.explorer.node.NodeProvider;
import org.netbeans.api.db.explorer.node.NodeProviderFactory;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.node.ForeignKeyNode;
import org.netbeans.modules.db.explorer.node.NodeDataLookup;
import org.netbeans.modules.db.explorer.node.NodeRegistry;
import org.netbeans.modules.db.metadata.model.api.Action;
import org.netbeans.modules.db.metadata.model.api.ForeignKey;
import org.netbeans.modules.db.metadata.model.api.Metadata;
import org.netbeans.modules.db.metadata.model.api.MetadataElement;
import org.netbeans.modules.db.metadata.model.api.MetadataElementHandle;
import org.netbeans.modules.db.metadata.model.api.MetadataModel;
import org.netbeans.modules.db.metadata.model.api.MetadataModelException;
import org.netbeans.modules.db.metadata.model.api.Table;
import org.openide.nodes.Node;
import org.openide.util.Lookup;

public class ForeignKeyNodeProvider
extends NodeProvider {
    private final DatabaseConnection connection = (DatabaseConnection)this.getLookup().lookup(DatabaseConnection.class);
    private final MetadataElementHandle<Table> tableHandle = (MetadataElementHandle)this.getLookup().lookup(MetadataElementHandle.class);

    public static NodeProviderFactory getFactory() {
        return FactoryHolder.FACTORY;
    }

    private ForeignKeyNodeProvider(Lookup lookup) {
        super(lookup, new ForeignKeyComparator());
    }

    protected synchronized void initialize() {
        final ArrayList<Node> arrayList = new ArrayList<Node>();
        boolean bl = !this.connection.getConnector().isDisconnected();
        MetadataModel metadataModel = this.connection.getMetadataModel();
        if (bl && metadataModel != null) {
            try {
                metadataModel.runReadAction((Action)new Action<Metadata>(){

                    public void run(Metadata metadata) {
                        Table table = (Table)ForeignKeyNodeProvider.this.tableHandle.resolve(metadata);
                        if (table != null) {
                            Collection collection = table.getForeignKeys();
                            for (ForeignKey foreignKey : collection) {
                                MetadataElementHandle metadataElementHandle = MetadataElementHandle.create((MetadataElement)foreignKey);
                                Collection collection2 = ForeignKeyNodeProvider.this.getNodes(metadataElementHandle);
                                if (collection2.size() > 0) {
                                    arrayList.addAll(collection2);
                                    continue;
                                }
                                NodeDataLookup nodeDataLookup = new NodeDataLookup();
                                nodeDataLookup.add(ForeignKeyNodeProvider.this.connection);
                                nodeDataLookup.add(metadataElementHandle);
                                arrayList.add(ForeignKeyNode.create(nodeDataLookup, ForeignKeyNodeProvider.this));
                            }
                        }
                    }
                });
            }
            catch (MetadataModelException metadataModelException) {
                NodeRegistry.handleMetadataModelException(this.getClass(), this.connection, metadataModelException, true);
            }
        }
        this.setNodes(arrayList);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ForeignKeyComparator
    implements Comparator<Node> {
        ForeignKeyComparator() {
        }

        @Override
        public int compare(Node node, Node node2) {
            return node.getDisplayName().compareToIgnoreCase(node2.getDisplayName());
        }
    }

    private static class FactoryHolder {
        static final NodeProviderFactory FACTORY = new NodeProviderFactory(){

            public ForeignKeyNodeProvider createInstance(Lookup lookup) {
                ForeignKeyNodeProvider foreignKeyNodeProvider = new ForeignKeyNodeProvider(lookup);
                return foreignKeyNodeProvider;
            }
        };

        private FactoryHolder() {
        }
    }
}

