/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.lib.ddl.DatabaseProductNotFoundException;
import org.netbeans.lib.ddl.adaptors.DefaultAdaptor;
import org.netbeans.lib.ddl.impl.CreateTable;
import org.netbeans.lib.ddl.impl.DriverSpecification;
import org.netbeans.lib.ddl.impl.Specification;
import org.netbeans.lib.ddl.impl.SpecificationFactory;
import org.netbeans.lib.ddl.impl.TableColumn;
import org.netbeans.modules.db.explorer.DatabaseConnection;
import org.netbeans.modules.db.explorer.DerbyConectionEventListener;
import org.netbeans.modules.db.explorer.node.RootNode;
import org.netbeans.modules.db.metadata.model.api.Catalog;
import org.netbeans.modules.db.metadata.model.api.Column;
import org.netbeans.modules.db.metadata.model.api.Index;
import org.netbeans.modules.db.metadata.model.api.IndexColumn;
import org.netbeans.modules.db.metadata.model.api.MetadataElement;
import org.netbeans.modules.db.metadata.model.api.MetadataElementHandle;
import org.netbeans.modules.db.metadata.model.api.Schema;
import org.netbeans.modules.db.metadata.model.api.Table;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DatabaseConnector {
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private DatabaseConnection databaseConnection;
    private Connection connection = null;
    private Specification spec;
    private ConcurrentHashMap<String, DriverSpecification> driverSpecCache = new ConcurrentHashMap();
    private ConcurrentHashMap<String, Object> properties = new ConcurrentHashMap();

    public DatabaseConnector(DatabaseConnection databaseConnection) {
        this.databaseConnection = databaseConnection;
    }

    public DatabaseConnection getDatabaseConnection() {
        return this.databaseConnection;
    }

    public Specification getDatabaseSpecification() {
        return this.spec;
    }

    public DriverSpecification getDriverSpecification(String string) throws DatabaseException {
        DriverSpecification driverSpecification = this.driverSpecCache.get(string);
        if (driverSpecification == null) {
            try {
                SpecificationFactory specificationFactory = RootNode.instance().getSpecificationFactory();
                driverSpecification = specificationFactory.createDriverSpecification(this.spec.getMetaData().getDriverName().trim());
                if (this.spec.getMetaData().getDriverName().trim().equals("jConnect (TM) for JDBC (TM)")) {
                    driverSpecification.setMetaData(this.connection.getMetaData());
                } else {
                    driverSpecification.setMetaData(this.spec.getMetaData());
                }
                driverSpecification.setCatalog(string);
                driverSpecification.setSchema(this.databaseConnection.getSchema());
                this.driverSpecCache.put(string, driverSpecification);
            }
            catch (SQLException sQLException) {
                throw new DatabaseException(sQLException.getMessage(), sQLException);
            }
        }
        return driverSpecification;
    }

    public void finishConnect(String string, DatabaseConnection databaseConnection, Connection connection) throws DatabaseException {
        try {
            SpecificationFactory specificationFactory = RootNode.instance().getSpecificationFactory();
            int n = 0;
            if (string != null) {
                this.spec = (Specification)specificationFactory.createSpecification(databaseConnection, string, connection);
                n = 1;
            } else {
                this.spec = (Specification)specificationFactory.createSpecification(databaseConnection, connection);
            }
            DatabaseMetaData databaseMetaData = this.spec.getMetaData();
            ((DefaultAdaptor)databaseMetaData).setreadOnly(n);
            String string2 = "org.netbeans.lib.ddl.adaptors.DefaultAdaptor";
            if (!this.spec.getMetaDataAdaptorClassName().equals(string2)) {
                this.spec.setMetaDataAdaptorClassName(string2);
            }
            this.setConnection(connection);
        }
        catch (DatabaseProductNotFoundException databaseProductNotFoundException) {
            Logger.getLogger(DatabaseConnector.class.getName()).log(Level.FINE, databaseProductNotFoundException.getLocalizedMessage(), databaseProductNotFoundException);
            this.finishConnect("GenericDatabaseSystem", null, connection);
        }
        catch (Exception exception) {
            throw new DatabaseException(exception.getMessage());
        }
    }

    public boolean isDisconnected() {
        return this.connection == null;
    }

    public void performDisconnect() throws DatabaseException {
        if (this.connection != null) {
            String string = null;
            Connection connection = this.connection;
            try {
                this.setConnection(null);
                connection.close();
            }
            catch (Exception exception) {
                this.setConnection(null);
                string = NbBundle.getMessage(DatabaseConnector.class, (String)"EXC_ConnectionError", (Object)exception.getMessage());
            }
            DerbyConectionEventListener.getDefault().afterDisconnect(this.getDatabaseConnection(), connection);
            if (string != null) {
                throw new DatabaseException(string);
            }
        }
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) throws DatabaseException {
        Connection connection2 = this.connection;
        if (connection != null) {
            if (connection2 != null && connection2.equals(connection)) {
                return;
            }
            this.connection = connection;
        } else {
            this.connection = null;
        }
        this.notifyChange();
    }

    public static boolean containsColumn(Collection<Column> collection, Column column) {
        boolean bl = false;
        MetadataElementHandle metadataElementHandle = MetadataElementHandle.create((MetadataElement)column);
        for (Column column2 : collection) {
            MetadataElementHandle metadataElementHandle2 = MetadataElementHandle.create((MetadataElement)column2);
            if (!metadataElementHandle.equals((Object)metadataElementHandle2)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public static boolean containsIndexColumn(Collection<Index> collection, Column column) {
        boolean bl = false;
        MetadataElementHandle metadataElementHandle = MetadataElementHandle.create((MetadataElement)column);
        block0: for (Index index : collection) {
            Collection collection2 = index.getColumns();
            for (IndexColumn indexColumn : collection2) {
                MetadataElementHandle metadataElementHandle2 = MetadataElementHandle.create((MetadataElement)indexColumn);
                if (!metadataElementHandle.equals((Object)metadataElementHandle2)) continue;
                bl = true;
                continue block0;
            }
        }
        return bl;
    }

    public TableColumn getColumnSpecification(Table table, Column column) throws DatabaseException {
        TableColumn tableColumn;
        block5: {
            tableColumn = null;
            try {
                CreateTable createTable = this.spec.createCommandCreateTable("DUMMY");
                tableColumn = DatabaseConnector.containsColumn(table.getPrimaryKey().getColumns(), column) ? createTable.createPrimaryKeyColumn(column.getName()) : (DatabaseConnector.containsIndexColumn(table.getIndexes(), column) ? createTable.createUniqueColumn(column.getName()) : createTable.createColumn(column.getName()));
                Schema schema = table.getParent();
                Catalog catalog = schema.getParent();
                String string = catalog.getName();
                if (string == null) {
                    string = schema.getName();
                }
                DriverSpecification driverSpecification = this.getDriverSpecification(string);
                driverSpecification.getColumns(table.getName(), column.getName());
                ResultSet resultSet = driverSpecification.getResultSet();
                if (resultSet == null) break block5;
                resultSet.next();
                HashMap hashMap = driverSpecification.getRow();
                try {
                    tableColumn.setColumnType(Integer.parseInt((String)hashMap.get(new Integer(5))));
                    tableColumn.setColumnSize(Integer.parseInt((String)hashMap.get(new Integer(7))));
                }
                catch (NumberFormatException numberFormatException) {
                    tableColumn.setColumnType(0);
                    tableColumn.setColumnSize(0);
                }
                tableColumn.setNullAllowed(((String)hashMap.get(new Integer(18))).toUpperCase().equals("YES"));
                tableColumn.setDefaultValue((String)hashMap.get(new Integer(13)));
                hashMap.clear();
                resultSet.close();
            }
            catch (Exception exception) {
                throw new DatabaseException(exception);
            }
        }
        return tableColumn;
    }

    public boolean supportsCommand(String string) {
        boolean bl = true;
        if (this.spec.getCommandProperties(string).containsKey("Supported")) {
            bl = this.spec.getCommandProperties(string).get("Supported").toString().equals("true");
        }
        return bl;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.changeSupport.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    public void notifyChange() {
        this.changeSupport.fireChange();
    }
}

