/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.core.jaxws.nodes;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.project.Project;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RefactoringSession;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.websvc.api.jaxws.client.JAXWSClientSupport;
import org.netbeans.modules.websvc.api.jaxws.client.JAXWSClientView;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.netbeans.modules.websvc.jaxws.api.JAXWSView;
import org.netbeans.spi.project.ui.support.NodeFactory;
import org.netbeans.spi.project.ui.support.NodeList;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.Lookups;

public class WebServicesNodeFactory
implements NodeFactory {
    public NodeList createNodes(Project project) {
        assert (project != null);
        return new WsNodeList(project);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class WsNodeList
    implements NodeList<String> {
        private static final String KEY_SERVICES = "web_services";
        private static final String KEY_SERVICE_REFS = "serviceRefs";
        private Project project;
        private List<ChangeListener> listeners = new ArrayList<ChangeListener>();
        private final JaxWsChangeListener jaxWsListener;

        public WsNodeList(Project project) {
            this.project = project;
            this.jaxWsListener = new JaxWsChangeListener();
        }

        public List<String> keys() {
            ArrayList<String> arrayList = new ArrayList<String>();
            JaxWsModel jaxWsModel = (JaxWsModel)this.project.getLookup().lookup(JaxWsModel.class);
            FileObject fileObject = this.project.getProjectDirectory();
            JAXWSSupport jAXWSSupport = JAXWSSupport.getJAXWSSupport((FileObject)fileObject);
            JAXWSClientSupport jAXWSClientSupport = JAXWSClientSupport.getJaxWsClientSupport((FileObject)fileObject);
            if (jaxWsModel != null) {
                if (jAXWSSupport != null && jaxWsModel.getServices().length > 0) {
                    arrayList.add(KEY_SERVICES);
                }
                if (jAXWSClientSupport != null && jaxWsModel.getClients().length > 0) {
                    arrayList.add(KEY_SERVICE_REFS);
                }
            }
            return arrayList;
        }

        public synchronized void addChangeListener(ChangeListener changeListener) {
            this.listeners.add(changeListener);
        }

        public synchronized void removeChangeListener(ChangeListener changeListener) {
            this.listeners.remove(changeListener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void fireChange() {
            ArrayList<ChangeListener> arrayList = new ArrayList<ChangeListener>();
            WsNodeList wsNodeList = this;
            synchronized (wsNodeList) {
                arrayList.addAll(this.listeners);
            }
            for (ChangeListener changeListener : arrayList) {
                changeListener.stateChanged(new ChangeEvent(this));
            }
        }

        public Node node(String string) {
            if (KEY_SERVICES.equals(string)) {
                JAXWSView jAXWSView = JAXWSView.getJAXWSView();
                return jAXWSView.createJAXWSView(this.project);
            }
            if (KEY_SERVICE_REFS.equals(string)) {
                JAXWSClientView jAXWSClientView = JAXWSClientView.getJAXWSClientView();
                return jAXWSClientView.createJAXWSClientView(this.project);
            }
            return null;
        }

        public void addNotify() {
            JaxWsModel jaxWsModel = (JaxWsModel)this.project.getLookup().lookup(JaxWsModel.class);
            if (jaxWsModel != null) {
                jaxWsModel.addPropertyChangeListener((PropertyChangeListener)this.jaxWsListener);
            }
        }

        public void removeNotify() {
            JaxWsModel jaxWsModel = (JaxWsModel)this.project.getLookup().lookup(JaxWsModel.class);
            if (jaxWsModel != null) {
                jaxWsModel.removePropertyChangeListener((PropertyChangeListener)this.jaxWsListener);
            }
        }

        private void refactorPackage(FileObject fileObject, String string, final String string2) throws IOException {
            FileObject fileObject2 = fileObject.getFileObject(string.replace('.', '/'));
            if (fileObject2 == null || !fileObject2.isValid()) {
                fileObject2 = fileObject.createFolder(string.replace('.', '/'));
            }
            if (fileObject2 != null) {
                final FileObject fileObject3 = fileObject2;
                NonRecursiveFolder nonRecursiveFolder = new NonRecursiveFolder(){

                    public FileObject getFolder() {
                        return fileObject3;
                    }
                };
                final RefactoringSession refactoringSession = RefactoringSession.create((String)"Rename JAX-WS package");
                final RenameRefactoring renameRefactoring = new RenameRefactoring(Lookups.fixed((Object[])new Object[]{nonRecursiveFolder}));
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        Problem problem = renameRefactoring.preCheck();
                        if (problem != null && problem.isFatal()) {
                            Logger.getLogger(this.getClass().getName()).log(Level.FINE, problem.getMessage());
                            return;
                        }
                        renameRefactoring.setNewName(string2);
                        problem = renameRefactoring.prepare(refactoringSession);
                        if (problem != null && problem.isFatal()) {
                            Logger.getLogger(this.getClass().getName()).log(Level.FINE, problem.getMessage());
                            return;
                        }
                        problem = refactoringSession.doRefactoring(true);
                    }
                });
            }
        }

        private FileObject createArtifactsFolder(FileObject fileObject) throws IOException {
            return FileUtil.createFolder((FileObject)fileObject, (String)"build/generated-sources/jax-ws");
        }

        private final class JaxWsChangeListener
        implements PropertyChangeListener {
            private JaxWsChangeListener() {
            }

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        WsNodeList.this.fireChange();
                    }
                });
                String string = propertyChangeEvent.getPropertyName();
                if (string.endsWith("PackageName")) {
                    String string2 = (String)propertyChangeEvent.getOldValue();
                    String string3 = (String)propertyChangeEvent.getNewValue();
                    if (string2 != null && string3 != null) {
                        try {
                            if (string.startsWith("/JaxWs/Clients") || string.startsWith("/JaxWs/Services")) {
                                FileObject fileObject = WsNodeList.this.project.getProjectDirectory().getFileObject("build/generated-sources/jax-ws");
                                if (fileObject == null || !fileObject.isValid()) {
                                    fileObject = WsNodeList.this.createArtifactsFolder(WsNodeList.this.project.getProjectDirectory());
                                }
                                if (fileObject != null) {
                                    WsNodeList.this.refactorPackage(fileObject, string2, string3);
                                }
                            }
                        }
                        catch (IOException iOException) {
                            Logger.getLogger(this.getClass().getName()).log(Level.FINE, "cannot create artifacts folder", iOException);
                        }
                    }
                }
            }
        }
    }
}

