/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.microedition.lcdui.pda;

import java.io.IOException;
import java.util.Enumeration;
import javax.microedition.io.Connector;
import javax.microedition.io.file.FileConnection;
import javax.microedition.io.file.FileSystemRegistry;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.AlertType;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.List;

public class FileBrowser
extends List
implements CommandListener {
    public static final Command SELECT_FILE_COMMAND = new Command("Select", 4, 1);
    private String currDirName = "/";
    private String currFile;
    private Image dirIcon;
    private Image fileIcon;
    private Image[] iconList;
    private CommandListener commandListener;
    private static final String UP_DIRECTORY = "..";
    private static final String MEGA_ROOT = "/";
    private static final String SEP_STR = "/";
    private static final char SEP = '/';
    private Display display;
    private String selectedURL;
    private String filter = null;
    private String title;

    public FileBrowser(Display display) {
        super("", 3);
        this.display = display;
        super.setCommandListener((CommandListener)this);
        this.setSelectCommand(SELECT_FILE_COMMAND);
        try {
            this.dirIcon = Image.createImage((String)"/org/netbeans/microedition/resources/dir.png");
        }
        catch (IOException e) {
            this.dirIcon = null;
        }
        try {
            this.fileIcon = Image.createImage((String)"/org/netbeans/microedition/resources/file.png");
        }
        catch (IOException e) {
            this.fileIcon = null;
        }
        this.iconList = new Image[]{this.fileIcon, this.dirIcon};
        this.showDir();
    }

    private void showDir() {
        new Thread(new Runnable(){

            public void run() {
                try {
                    FileBrowser.this.showCurrDir();
                }
                catch (SecurityException e) {
                    Alert alert = new Alert("Error", "You are not authorized to access the restricted API", null, AlertType.ERROR);
                    alert.setTimeout(2000);
                    FileBrowser.this.display.setCurrent(alert, (Displayable)FileBrowser.this);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }

    public void commandAction(Command c, Displayable d) {
        if (c.equals(SELECT_FILE_COMMAND)) {
            List curr = (List)d;
            this.currFile = curr.getString(curr.getSelectedIndex());
            new Thread(new Runnable(){

                public void run() {
                    if (FileBrowser.this.currFile.endsWith("/") || FileBrowser.this.currFile.equals(FileBrowser.UP_DIRECTORY)) {
                        FileBrowser.this.openDir(FileBrowser.this.currFile);
                    } else {
                        FileBrowser.this.doDismiss();
                    }
                }
            }).start();
        } else {
            this.commandListener.commandAction(c, d);
        }
    }

    public void setTitle(String title) {
        this.title = title;
        super.setTitle(title);
    }

    private void showCurrDir() {
        if (this.title == null) {
            super.setTitle(this.currDirName);
        }
        Enumeration e = null;
        FileConnection currDir = null;
        this.deleteAll();
        if ("/".equals(this.currDirName)) {
            this.append(UP_DIRECTORY, this.dirIcon);
            e = FileSystemRegistry.listRoots();
        } else {
            try {
                currDir = (FileConnection)Connector.open((String)("file:///" + this.currDirName));
                e = currDir.list();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            this.append(UP_DIRECTORY, this.dirIcon);
        }
        if (e == null) {
            try {
                currDir.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            return;
        }
        while (e.hasMoreElements()) {
            String fileName = (String)e.nextElement();
            if (fileName.charAt(fileName.length() - 1) == '/') {
                this.append(fileName, this.dirIcon);
                continue;
            }
            if (this.filter != null && fileName.indexOf(this.filter) <= -1) continue;
            this.append(fileName, this.fileIcon);
        }
        if (currDir != null) {
            try {
                currDir.close();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    private void openDir(String fileName) {
        if (this.currDirName.equals("/")) {
            if (fileName.equals(UP_DIRECTORY)) {
                return;
            }
            this.currDirName = fileName;
        } else {
            int i;
            this.currDirName = fileName.equals(UP_DIRECTORY) ? ((i = this.currDirName.lastIndexOf(47, this.currDirName.length() - 2)) != -1 ? this.currDirName.substring(0, i + 1) : "/") : this.currDirName + fileName;
        }
        this.showDir();
    }

    public FileConnection getSelectedFile() throws IOException {
        FileConnection fileConnection = (FileConnection)Connector.open((String)this.selectedURL);
        return fileConnection;
    }

    public String getSelectedFileURL() {
        return this.selectedURL;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    protected CommandListener getCommandListener() {
        return this.commandListener;
    }

    public void setCommandListener(CommandListener commandListener) {
        this.commandListener = commandListener;
    }

    private void doDismiss() {
        this.selectedURL = "file:///" + this.currDirName + this.currFile;
        CommandListener commandListener = this.getCommandListener();
        if (commandListener != null) {
            commandListener.commandAction(SELECT_FILE_COMMAND, (Displayable)this);
        }
    }
}

