/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.stat;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.TableCellRenderer;
import org.hibernate.stat.Statistics;
import org.hibernate.tool.stat.BeanTableModel;
import org.hibernate.tool.stat.StatisticsCellRenderer;
import org.hibernate.tool.stat.StatisticsTreeModel;

public class StatisticsBrowser {
    public void showStatistics(Statistics stats, boolean shouldBlock) {
        JDialog main = new JDialog((Frame)null, "Statistics browser");
        main.getContentPane().setLayout(new BorderLayout());
        final StatisticsTreeModel statisticsTreeModel = new StatisticsTreeModel(stats);
        JTree tree = new JTree(statisticsTreeModel);
        tree.setCellRenderer(new StatisticsCellRenderer());
        ToolTipManager.sharedInstance().registerComponent(tree);
        JScrollPane treePane = new JScrollPane(tree);
        final JTable table = new JTable(){

            public TableCellRenderer getDefaultRenderer(Class columnClass) {
                TableCellRenderer defaultRenderer = super.getDefaultRenderer(columnClass);
                if (defaultRenderer == null) {
                    return super.getDefaultRenderer(class$java$lang$Object == null ? (class$java$lang$Object = StatisticsBrowser.class$("java.lang.Object")) : class$java$lang$Object);
                }
                return defaultRenderer;
            }
        };
        JScrollPane tablePane = new JScrollPane(table);
        tablePane.getViewport().setBackground(table.getBackground());
        BeanTableModel beanTableModel = new BeanTableModel(Collections.EMPTY_LIST, Object.class);
        table.setModel(beanTableModel);
        JSplitPane pane = new JSplitPane(1, treePane, tablePane);
        pane.setContinuousLayout(true);
        main.getContentPane().add((Component)pane, "Center");
        tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                Object lastPathComponent = e.getPath().getLastPathComponent();
                ArrayList<Object> l = new ArrayList<Object>();
                if (statisticsTreeModel.isContainer(lastPathComponent)) {
                    int childCount = statisticsTreeModel.getChildCount(lastPathComponent);
                    Class cl = class$java$lang$Object == null ? (class$java$lang$Object = StatisticsBrowser.class$("java.lang.Object")) : class$java$lang$Object;
                    for (int i = 0; i < childCount; ++i) {
                        Object v = statisticsTreeModel.getChild(lastPathComponent, i);
                        if (v != null) {
                            cl = v.getClass();
                        }
                        l.add(v);
                    }
                    table.setModel(new BeanTableModel(l, cl));
                } else {
                    l.add(lastPathComponent);
                    table.setModel(new BeanTableModel(l, lastPathComponent.getClass()));
                }
            }
        });
        main.getContentPane().setSize(new Dimension(640, 480));
        main.pack();
        main.setModal(shouldBlock);
        main.setVisible(true);
    }
}

