/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.junit.diff;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.junit.diff.Diff;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LineDiff
implements Diff {
    public static int CONTEXT = 3;
    boolean ignoreCase;
    boolean ignoreEmptyLines;
    int contextLines;

    public LineDiff() {
        this(false, false);
    }

    public LineDiff(boolean bl) {
        this(bl, false);
    }

    public LineDiff(boolean bl, boolean bl2) {
        this.ignoreCase = bl;
        this.ignoreEmptyLines = bl2;
        String string = System.getProperty("nbjunit.linediff.context");
        int n = -1;
        if (string != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
        }
        if (n < 0) {
            n = CONTEXT;
        }
        this.contextLines = n;
    }

    public boolean getIgnoreCase() {
        return this.ignoreCase;
    }

    protected boolean compareLines(String string, String string2) {
        return this.getIgnoreCase() ? string.equalsIgnoreCase(string2) : string.equals(string2);
    }

    public int getNContextLines() {
        return this.contextLines;
    }

    @Override
    public boolean diff(String string, String string2, String string3) throws IOException {
        File file = new File(string);
        File file2 = new File(string2);
        File file3 = null != string3 ? new File(string3) : null;
        return this.diff(file, file2, file3);
    }

    @Override
    public boolean diff(File file, File file2, File file3) throws IOException {
        String string;
        LineNumberReader lineNumberReader = new LineNumberReader(new FileReader(file));
        LineNumberReader lineNumberReader2 = new LineNumberReader(new FileReader(file2));
        ArrayList<String> arrayList = new ArrayList<String>(64);
        while ((string = lineNumberReader2.readLine()) != null) {
            if (this.ignoreEmptyLines && string.trim().length() == 0) continue;
            arrayList.add(string);
        }
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        arrayList.clear();
        lineNumberReader2.close();
        arrayList = new ArrayList(64);
        while ((string = lineNumberReader.readLine()) != null) {
            if (this.ignoreEmptyLines && string.trim().length() == 0) continue;
            arrayList.add(string);
        }
        String[] stringArray2 = arrayList.toArray(new String[arrayList.size()]);
        arrayList.clear();
        lineNumberReader.close();
        List<Result> list = this.findDifferences(stringArray, stringArray2);
        if (list.size() == 0) {
            return false;
        }
        if (file3 == null) {
            return list.size() > 0;
        }
        this.merge(list);
        this.printResults(stringArray, stringArray2, list, file3);
        return list.size() > 0;
    }

    private List<Result> findDifferences(String[] stringArray, String[] stringArray2) {
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        ArrayList<Result> arrayList = new ArrayList<Result>(64);
        boolean bl2 = true;
        while (n2 < stringArray.length || n < stringArray2.length) {
            int n3;
            String string;
            if (bl2) {
                if (n2 >= stringArray.length) {
                    if (n >= stringArray2.length) break;
                    arrayList.add(new Result(n, stringArray2.length, n2, true));
                    break;
                }
                string = stringArray[n2];
                n3 = this.find(string, stringArray2, n);
                if (n3 >= 0) {
                    if (n3 > n) {
                        if (!bl && n3 - n >= 2) {
                            bl = true;
                            bl2 = false;
                            continue;
                        }
                        arrayList.add(new Result(n, n3, n2, true));
                    }
                    n = n3 + 1;
                } else {
                    arrayList.add(new Result(n2, n2 + 1, false));
                    bl2 = false;
                }
                ++n2;
            } else {
                if (n >= stringArray2.length) {
                    if (n2 >= stringArray.length) break;
                    arrayList.add(new Result(n2, stringArray.length - 1, false));
                    break;
                }
                string = stringArray2[n];
                n3 = this.find(string, stringArray, n2);
                if (n3 >= 0) {
                    if (!bl && n3 - n2 >= 2) {
                        bl = true;
                        bl2 = true;
                        continue;
                    }
                    if (n3 > n2) {
                        arrayList.add(new Result(n2, n3, false));
                    }
                    n2 = n3 + 1;
                    bl2 = true;
                } else {
                    arrayList.add(new Result(n, n + 1, n2, true));
                    bl2 = true;
                }
                ++n;
            }
            bl = false;
        }
        return arrayList;
    }

    private void printResults(String[] stringArray, String[] stringArray2, List<Result> list, File file) throws IOException {
        int n = stringArray2.length > stringArray.length ? String.valueOf(stringArray2.length).length() : String.valueOf(stringArray.length).length();
        PrintStream printStream = new PrintStream(new FileOutputStream(file));
        boolean bl = false;
        for (int i = 0; i < list.size(); ++i) {
            int n2;
            int n3;
            Result result = list.get(i);
            if (!bl) {
                n3 = result.passIndex - this.contextLines;
                if (n3 < 0) {
                    n3 = 0;
                }
                for (n2 = n3; n2 < result.passIndex; ++n2) {
                    this.printContext(stringArray, printStream, n2, n);
                }
            } else {
                bl = false;
            }
            list.get(i).print(stringArray, stringArray2, printStream, n);
            n3 = result.newLine ? result.passIndex : result.end;
            n2 = n3 + this.contextLines;
            if (i < list.size() - 1 && list.get((int)(i + 1)).passIndex < n2) {
                n2 = list.get((int)(i + 1)).passIndex;
                bl = true;
            } else if (n2 > stringArray.length) {
                n2 = stringArray.length;
            }
            for (int j = n3; j < n2; ++j) {
                this.printContext(stringArray, printStream, j, n);
            }
        }
        printStream.close();
    }

    private int find(String string, String[] stringArray, int n) {
        for (int i = n; i < stringArray.length; ++i) {
            if (!this.compareLines(string, stringArray[i])) continue;
            return i;
        }
        return -1;
    }

    private void merge(List<Result> list) {
        for (int i = 0; i < list.size() - 1; ++i) {
            if (!list.get((int)i).newLine || !list.get((int)(i + 1)).newLine || list.get((int)i).end != list.get((int)(i + 1)).start) continue;
            list.get((int)i).end = list.get((int)(i + 1)).end;
            list.remove(i + 1);
            --i;
        }
    }

    private void printContext(String[] stringArray, PrintStream printStream, int n, int n2) {
        String string = String.valueOf(n + 1);
        int n3 = n2 + 1 - string.length();
        for (int i = 0; i < n3; ++i) {
            printStream.print(' ');
        }
        printStream.print(string);
        printStream.print("   ");
        printStream.println(stringArray[n]);
    }

    static class Result {
        boolean newLine = false;
        int start;
        int end;
        int passIndex;

        public Result(int n, int n2, int n3, boolean bl) {
            this.start = n;
            this.end = n2;
            this.passIndex = n3;
            this.newLine = bl;
        }

        public Result(int n, int n2, boolean bl) {
            this.passIndex = n;
            this.start = n;
            this.end = n2;
            this.newLine = bl;
        }

        public void print(String[] stringArray, String[] stringArray2, PrintStream printStream, int n) {
            for (int i = this.start; i < this.end; ++i) {
                if (this.newLine) {
                    for (int j = 0; j < n + 2; ++j) {
                        printStream.print(' ');
                    }
                    printStream.print("+ ");
                    printStream.println(stringArray2[i]);
                    continue;
                }
                String string = String.valueOf(i + 1);
                int n2 = n + 1 - string.length();
                for (int j = 0; j < n2; ++j) {
                    printStream.print(' ');
                }
                printStream.print(string);
                printStream.print(" - ");
                printStream.println(stringArray[i]);
            }
        }
    }
}

