/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jspparser;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsps.parserapi.JspParserAPI;
import org.netbeans.modules.xml.api.EncodingUtil;
import org.openide.filesystems.FileObject;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class FastOpenInfoParser {
    private static final Logger LOGGER = Logger.getLogger(FastOpenInfoParser.class.getName());
    private final WebModule wm;
    private static final String PAGE = "page";
    private static final String ENCODING = "pageEncoding";
    private static final String CONTENTYPE = "contentType";
    private static final String CHARSET = "charset=";
    private static final int P_INIT = 0;
    private static final int P_LT = 1;
    private static final int P_LT_PER = 2;
    private static final int P_LT_PER_ATS = 3;
    private static final int P_PD = 4;
    private static final int P_APER = 5;
    private static final int P_ENC = 7;
    private static final int P_ENC_EQ = 8;
    private static final int P_ENC_EQ_VAL = 9;
    private static final int P_CT = 11;
    private static final int P_CT_EQ = 12;
    private static final int P_CT_EQ_VAL = 13;
    private static final int P_CT_VAL_CHS = 14;
    static final String JSP_PROPERTY_GROUP = "jsp-property-group";
    static final String PAGE_ENCODING = "page-encoding";
    static final String IS_XML = "is-xml";

    static FastOpenInfoParser get(WebModule webModule) {
        return new FastOpenInfoParser(webModule);
    }

    private FastOpenInfoParser(WebModule webModule) {
        this.wm = webModule;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JspParserAPI.JspOpenInfo getJspOpenInfo(FileObject fileObject, boolean bl) {
        long l = 0L;
        if (LOGGER.isLoggable(Level.FINE)) {
            l = System.currentTimeMillis();
        }
        try {
            Object object;
            Object object2;
            Object object3;
            if (this.wm != null && this.wm.getDocumentBase() != null && bl) {
                JspParserAPI.JspOpenInfo jspOpenInfo = null;
                return jspOpenInfo;
            }
            if (this.wm != null && (object3 = this.wm.getDocumentBase()) != null && (object2 = (Object)this.wm.getDeploymentDescriptor()) != null) {
                object = FastOpenInfoParser.parse(new InputSource(object2.getInputStream()));
                if (((DDParseInfo)object).definesEncoding || ((DDParseInfo)object).marksXMLDocuments) {
                    JspParserAPI.JspOpenInfo jspOpenInfo = null;
                    return jspOpenInfo;
                }
            }
            object3 = null;
            object2 = new byte[32768];
            object = fileObject.getInputStream();
            int n = ((InputStream)object).read((byte[])object2);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object2, 0, n);
            ((InputStream)object).close();
            object3 = FastOpenInfoParser.isXMLSyntax(fileObject) ? EncodingUtil.detectEncoding((InputStream)byteArrayInputStream) : FastOpenInfoParser.parseEncodingFromFile(byteArrayInputStream);
            LOGGER.fine("[fast open parser] detected " + (String)object3 + " encoding.");
            JspParserAPI.JspOpenInfo jspOpenInfo = object3 == null ? null : new JspParserAPI.JspOpenInfo(FastOpenInfoParser.isXMLSyntax(fileObject), (String)object3);
            return jspOpenInfo;
        }
        catch (IOException iOException) {
        }
        catch (SAXException sAXException) {
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        finally {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("[fast open parser] taken " + (System.currentTimeMillis() - l) + "ms.");
            }
        }
        return null;
    }

    private static String parseEncodingFromFile(InputStream inputStream) throws IOException {
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        char[] cArray = new char[8192];
        int n = inputStreamReader.read(cArray);
        inputStreamReader.close();
        return FastOpenInfoParser.parseJspText(cArray, n);
    }

    private static boolean isXMLSyntax(FileObject fileObject) {
        String string = fileObject.getExt();
        return string != null && ("jspx".equalsIgnoreCase(string) || "tagx".equalsIgnoreCase(string));
    }

    private static String parseJspText(char[] cArray, int n) {
        String string = null;
        int n2 = 0;
        int n3 = 0;
        int n4 = -1;
        while (n3 < n) {
            char c = cArray[n3];
            switch (n2) {
                case 0: {
                    if (c == '<') {
                        n2 = 1;
                    }
                    ++n3;
                    break;
                }
                case 1: {
                    switch (c) {
                        case '%': {
                            n2 = 2;
                            break;
                        }
                        default: {
                            n2 = 0;
                        }
                    }
                    ++n3;
                    break;
                }
                case 2: {
                    switch (c) {
                        case '@': {
                            n2 = 3;
                            break;
                        }
                        default: {
                            n2 = 0;
                        }
                    }
                    ++n3;
                    break;
                }
                case 3: {
                    if (c == ' ' || c == '\t') {
                        ++n3;
                        break;
                    }
                    if (FastOpenInfoParser.prescanFor(cArray, n3, PAGE)) {
                        n2 = 4;
                        n3 += PAGE.length();
                        break;
                    }
                    n2 = 0;
                    ++n3;
                    break;
                }
                case 4: {
                    if (FastOpenInfoParser.prescanFor(cArray, n3, ENCODING)) {
                        n2 = 7;
                        n3 += ENCODING.length();
                        break;
                    }
                    if (FastOpenInfoParser.prescanFor(cArray, n3, CONTENTYPE)) {
                        n2 = 11;
                        n3 += CONTENTYPE.length();
                        break;
                    }
                    if (c == '%') {
                        n2 = 5;
                    }
                    ++n3;
                    break;
                }
                case 5: {
                    n2 = c == '>' ? 0 : 4;
                    ++n3;
                    break;
                }
                case 7: {
                    switch (c) {
                        case '\t': 
                        case ' ': {
                            break;
                        }
                        case '=': {
                            n2 = 8;
                            break;
                        }
                        case '%': {
                            n2 = 5;
                            break;
                        }
                        default: {
                            n2 = 4;
                        }
                    }
                    ++n3;
                    break;
                }
                case 8: {
                    switch (c) {
                        case '\t': 
                        case ' ': {
                            break;
                        }
                        case '\"': {
                            n2 = 9;
                            n4 = n3 + 1;
                            break;
                        }
                        case '%': {
                            n2 = 5;
                            break;
                        }
                        default: {
                            n2 = 4;
                        }
                    }
                    ++n3;
                    break;
                }
                case 9: {
                    switch (c) {
                        case '\"': {
                            return new String(cArray, n4, n3 - n4);
                        }
                    }
                    ++n3;
                    break;
                }
                case 11: {
                    switch (c) {
                        case '\t': 
                        case ' ': {
                            break;
                        }
                        case '=': {
                            n2 = 12;
                            break;
                        }
                        case '%': {
                            n2 = 5;
                            break;
                        }
                        default: {
                            n2 = 4;
                        }
                    }
                    ++n3;
                    break;
                }
                case 12: {
                    switch (c) {
                        case '\t': 
                        case ' ': {
                            break;
                        }
                        case '\"': {
                            n2 = 13;
                            break;
                        }
                        case '%': {
                            n2 = 5;
                            break;
                        }
                        default: {
                            n2 = 4;
                        }
                    }
                    ++n3;
                    break;
                }
                case 13: {
                    if (FastOpenInfoParser.prescanFor(cArray, n3, CHARSET)) {
                        n2 = 14;
                        n4 = n3 += CHARSET.length();
                        break;
                    }
                    if (c == '\"') {
                        n2 = 4;
                        break;
                    }
                    ++n3;
                    break;
                }
                case 14: {
                    switch (c) {
                        case '\"': {
                            string = new String(cArray, n4, n3 - n4);
                            n2 = 4;
                            break;
                        }
                    }
                    ++n3;
                }
            }
        }
        return string;
    }

    private static boolean prescanFor(char[] cArray, int n, String string) {
        if (cArray.length - n < string.length()) {
            return false;
        }
        for (int i = 0; i < string.length(); ++i) {
            if (cArray[n + i] == string.charAt(i)) continue;
            return false;
        }
        return true;
    }

    private static DDParseInfo parse(InputSource inputSource) throws IOException, SAXException, ParserConfigurationException {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setValidating(false);
        SAXParser sAXParser = sAXParserFactory.newSAXParser();
        DDParseInfo dDParseInfo = new DDParseInfo();
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Handler
        extends DefaultHandler {
            private boolean inJspPropertyGroup = false;
            final /* synthetic */ DDParseInfo val$ddParseInfo;

            Handler(DDParseInfo dDParseInfo) {
                this.val$ddParseInfo = dDParseInfo;
            }

            @Override
            public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
                String string4 = string3.toLowerCase();
                if (FastOpenInfoParser.JSP_PROPERTY_GROUP.equals(string4)) {
                    this.inJspPropertyGroup = true;
                }
                if (this.inJspPropertyGroup) {
                    if (FastOpenInfoParser.PAGE_ENCODING.equals(string4)) {
                        this.val$ddParseInfo.definesEncoding = true;
                    }
                    if (FastOpenInfoParser.IS_XML.equals(string4)) {
                        this.val$ddParseInfo.marksXMLDocuments = true;
                    }
                }
            }

            @Override
            public void endElement(String string, String string2, String string3) throws SAXException {
                String string4 = string3.toLowerCase();
                if (FastOpenInfoParser.JSP_PROPERTY_GROUP.equals(string4)) {
                    this.inJspPropertyGroup = false;
                }
            }

            @Override
            public InputSource resolveEntity(String string, String string2) {
                return new InputSource(new StringReader(""));
            }
        }
        sAXParser.parse(inputSource, (DefaultHandler)new Handler(dDParseInfo));
        return dDParseInfo;
    }

    private static final class DDParseInfo {
        public boolean definesEncoding;
        public boolean marksXMLDocuments;
    }
}

