/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.tld;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.modules.web.jsf.editor.tld.LibraryDescriptorException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.util.Exceptions;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LibraryDescriptor {
    private FileObject definitionFile;
    private InputStream content;
    protected String prefix;
    protected String uri;
    protected String displayName;
    protected Map<String, Tag> tags = new HashMap<String, Tag>();
    private static final String STOP_PARSING_MGS = "regularly_stopped";

    protected LibraryDescriptor() {
    }

    protected LibraryDescriptor(FileObject fileObject) throws LibraryDescriptorException {
        this.definitionFile = fileObject;
    }

    protected LibraryDescriptor(InputStream inputStream) throws LibraryDescriptorException {
        this.content = inputStream;
    }

    public FileObject getDefinitionFile() {
        return this.definitionFile;
    }

    public String getURI() {
        return this.uri;
    }

    public String getDefaultPrefix() {
        return this.prefix;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Map<String, Tag> getTags() {
        return this.tags;
    }

    protected void parseLibrary() throws LibraryDescriptorException {
        try {
            this.parseLibrary(this.getDefinitionFile().getInputStream());
        }
        catch (FileNotFoundException fileNotFoundException) {
            Exceptions.printStackTrace((Throwable)fileNotFoundException);
        }
    }

    protected abstract void parseLibrary(InputStream var1) throws LibraryDescriptorException;

    protected static String parseNamespace(InputStream inputStream, final String string, final String string2) {
        String[] stringArray;
        block4: {
            stringArray = new String[1];
            try {
                SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                sAXParserFactory.setValidating(false);
                SAXParser sAXParser = sAXParserFactory.newSAXParser();
                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                class Handler
                extends DefaultHandler {
                    private boolean inTaglib = false;
                    private boolean inURI = false;

                    Handler() {
                    }

                    @Override
                    public void startElement(String string5, String string22, String string3, Attributes attributes) throws SAXException {
                        String string4 = string3.toLowerCase();
                        if (string.equals(string4)) {
                            this.inTaglib = true;
                        }
                        if (this.inTaglib && string2.equals(string4)) {
                            this.inURI = true;
                        }
                    }

                    @Override
                    public void characters(char[] cArray, int n, int n2) throws SAXException {
                        if (this.inURI) {
                            stringArray[0] = new String(cArray, n, n2).trim();
                            throw new SAXException(LibraryDescriptor.STOP_PARSING_MGS);
                        }
                    }

                    @Override
                    public InputSource resolveEntity(String string3, String string22) {
                        return new InputSource(new StringReader(""));
                    }
                }
                sAXParser.parse(inputStream, (DefaultHandler)new Handler());
            }
            catch (IOException iOException) {
                Exceptions.printStackTrace((Throwable)iOException);
            }
            catch (ParserConfigurationException parserConfigurationException) {
                Exceptions.printStackTrace((Throwable)parserConfigurationException);
            }
            catch (SAXException sAXException) {
                if (STOP_PARSING_MGS.equals(sAXException.getMessage())) break block4;
                Exceptions.printStackTrace((Throwable)sAXException);
            }
        }
        return stringArray[0];
    }

    public String toString() {
        try {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.getDefinitionFile() != null ? this.getDefinitionFile().getFileSystem().getRoot().getURL().toString() + ";" + this.getDefinitionFile().getPath() : "");
            stringBuffer.append("; defaultPrefix = " + this.getDefaultPrefix() + "; uri = " + this.getURI() + "; tags={");
            for (Tag tag : this.getTags().values()) {
                stringBuffer.append(tag.toString());
            }
            stringBuffer.append("}]");
            return stringBuffer.toString();
        }
        catch (FileStateInvalidException fileStateInvalidException) {
            return null;
        }
    }

    protected static String getTextContent(Node node, String string) {
        Node node2 = LibraryDescriptor.getNodeByName(node, string);
        return node2 == null ? null : node2.getTextContent().trim();
    }

    protected static Node getNodeByName(Node node, String string) {
        Collection<Node> collection = LibraryDescriptor.getNodesByName(node, string);
        if (!collection.isEmpty()) {
            return collection.iterator().next();
        }
        return null;
    }

    protected static Collection<Node> getNodesByName(Node node, String string) {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || !node2.getNodeName().equals(string)) continue;
            arrayList.add(node2);
        }
        return arrayList;
    }

    public static class Attribute {
        private String name;
        private String description;
        private boolean required;

        public Attribute(String string, String string2, boolean bl) {
            this.name = string;
            this.description = string2;
            this.required = bl;
        }

        public String getDescription() {
            return this.description;
        }

        public String getName() {
            return this.name;
        }

        public boolean isRequired() {
            return this.required;
        }

        public String toString() {
            return "Attribute[name=" + this.getName() + ", required=" + this.isRequired() + "]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TagImpl
    implements Tag {
        private static final String ID_ATTR_NAME = "id";
        private String name;
        private String description;
        private Map<String, Attribute> attrs;

        public TagImpl(String string, String string2, Map<String, Attribute> map) {
            this.name = string;
            this.description = string2;
            this.attrs = map;
            if (this.getAttribute(ID_ATTR_NAME) == null) {
                map.put(ID_ATTR_NAME, new Attribute(ID_ATTR_NAME, "", false));
            }
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public boolean hasNonGenenericAttributes() {
            return this.getAttributes().size() > 1;
        }

        @Override
        public Collection<Attribute> getAttributes() {
            return this.attrs.values();
        }

        @Override
        public Attribute getAttribute(String string) {
            return this.attrs.get(string);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("Tag[name=" + this.getName() + ", attributes={");
            for (Attribute attribute : this.getAttributes()) {
                stringBuffer.append(attribute.toString() + ",");
            }
            stringBuffer.append("}]");
            return stringBuffer.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Tag {
        public String getName();

        public String getDescription();

        public boolean hasNonGenenericAttributes();

        public Collection<Attribute> getAttributes();

        public Attribute getAttribute(String var1);
    }
}

