/*
 * Decompiled with CFR 0.152.
 */
package com.kenai.jaffl.provider.jna;

import com.kenai.jaffl.LibraryOption;
import com.kenai.jaffl.byref.ByReference;
import com.kenai.jaffl.mapper.FromNativeConverter;
import com.kenai.jaffl.mapper.ToNativeConverter;
import com.kenai.jaffl.mapper.TypeMapper;
import com.kenai.jaffl.provider.Invoker;
import com.kenai.jaffl.provider.Library;
import com.kenai.jaffl.provider.jna.invokers.DefaultMarshallingInvoker;
import com.kenai.jaffl.provider.jna.invokers.FromNativeMarshallingInvoker;
import com.kenai.jaffl.provider.jna.invokers.SimpleInvoker;
import com.sun.jna.NativeLibrary;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class JNALibrary
extends Library {
    private static final Map<String, WeakReference<NativeLibrary>> nativeLibraries = new ConcurrentHashMap<String, WeakReference<NativeLibrary>>();
    private final String libraryName;
    private static final TypeMapper emptyTypeMapper = new TypeMapper(){

        public FromNativeConverter getFromNativeConverter(Class type2) {
            return null;
        }

        public ToNativeConverter getToNativeConverter(Class type2) {
            return null;
        }
    };

    JNALibrary(String libraryName) {
        this.libraryName = libraryName;
    }

    @Override
    public Invoker getInvoker(Method method2, Map<LibraryOption, ?> options2) {
        TypeMapper typeMapper = (TypeMapper)options2.get((Object)LibraryOption.TypeMapper);
        if (typeMapper == null) {
            typeMapper = emptyTypeMapper;
        }
        boolean needParameterConversion = false;
        boolean needResultConversion = false;
        for (Class<?> c : method2.getParameterTypes()) {
            if (typeMapper.getToNativeConverter(c) != null) {
                needParameterConversion = true;
                continue;
            }
            if (ByReference.class.isAssignableFrom(c)) {
                needParameterConversion = true;
                continue;
            }
            if (StringBuffer.class.isAssignableFrom(c)) {
                needParameterConversion = true;
                continue;
            }
            if (StringBuilder.class.isAssignableFrom(c)) {
                needParameterConversion = true;
                continue;
            }
            if (!CharSequence.class.isAssignableFrom(c)) continue;
            needParameterConversion = true;
        }
        if (typeMapper.getFromNativeConverter(method2.getReturnType()) != null) {
            needResultConversion = true;
        }
        NativeLibrary lib = JNALibrary.getNativeLibrary(this.libraryName);
        if (!needParameterConversion && !needResultConversion) {
            return new SimpleInvoker(lib, method2);
        }
        if (needParameterConversion && !needResultConversion) {
            return new DefaultMarshallingInvoker(lib, method2, typeMapper);
        }
        return new FromNativeMarshallingInvoker(lib, method2, typeMapper);
    }

    @Override
    public Object libraryLock() {
        return NativeLibrary.getInstance(this.libraryName);
    }

    private static final NativeLibrary getNativeLibrary(String libraryName) {
        NativeLibrary lib;
        WeakReference<NativeLibrary> ref = nativeLibraries.get(libraryName);
        NativeLibrary nativeLibrary = lib = ref != null ? (NativeLibrary)ref.get() : null;
        if (lib == null) {
            try {
                lib = NativeLibrary.getInstance(JNALibrary.locateLibrary(libraryName));
            }
            catch (UnsatisfiedLinkError ex) {
                lib = NativeLibrary.getInstance(libraryName);
            }
            nativeLibraries.put(libraryName, new WeakReference<NativeLibrary>(lib));
        }
        return lib;
    }
}

