/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.symfony.commands;

import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.php.api.util.FileUtils;
import org.netbeans.modules.php.symfony.commands.SymfonyCommandVO;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SymfonyCommandsXmlParser
extends DefaultHandler {
    private static final Logger LOGGER = Logger.getLogger(SymfonyCommandsXmlParser.class.getName());
    private final XMLReader xmlReader;
    private final List<SymfonyCommandVO> commands;
    private String currentCommand = null;
    private String currentDescription = null;
    private Content content = Content.NONE;

    public SymfonyCommandsXmlParser(List<SymfonyCommandVO> list) throws SAXException {
        assert (list != null);
        this.commands = list;
        this.xmlReader = FileUtils.createXmlReader();
        this.xmlReader.setContentHandler(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void parse(Reader reader, List<SymfonyCommandVO> list) {
        try {
            SymfonyCommandsXmlParser symfonyCommandsXmlParser = new SymfonyCommandsXmlParser(list);
            symfonyCommandsXmlParser.xmlReader.parse(new InputSource(reader));
        }
        catch (SAXException sAXException) {
            LOGGER.log(Level.INFO, null, sAXException);
        }
        catch (Throwable throwable) {
            LOGGER.log(Level.WARNING, null, throwable);
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                LOGGER.log(Level.WARNING, null, iOException);
            }
        }
    }

    @Override
    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if ("task".equals(string3)) {
            assert (this.currentCommand == null);
            assert (this.currentDescription == null);
            this.currentCommand = attributes.getValue("id");
        } else if ("description".equals(string3)) {
            assert (this.content == Content.NONE);
            assert (this.currentDescription == null);
            if (this.currentCommand != null) {
                this.content = Content.DESCRIPTION;
            }
        }
    }

    @Override
    public void endElement(String string, String string2, String string3) throws SAXException {
        if ("description".equals(string3) && this.content == Content.DESCRIPTION) {
            assert (this.currentCommand != null);
            assert (this.currentDescription != null);
            this.commands.add(new SymfonyCommandVO(this.currentCommand.trim(), this.currentDescription.trim()));
            this.currentCommand = null;
            this.currentDescription = null;
            this.content = Content.NONE;
        }
    }

    @Override
    public void characters(char[] cArray, int n, int n2) throws SAXException {
        switch (this.content) {
            case DESCRIPTION: {
                this.currentDescription = new String(cArray, n, n2);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Content {
        NONE,
        DESCRIPTION;

    }
}

