/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.annotationsupport;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JEditorPane;
import org.netbeans.modules.dlight.annotationsupport.LineAnnotationInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileAnnotationInfo {
    private JEditorPane editorPane;
    private String filePath;
    private String tooltip = null;
    private final List<LineAnnotationInfo> lineAnnotationsInfo = new ArrayList<LineAnnotationInfo>();
    private final List<LineAnnotationInfo> blockAnnotationsInfo = new ArrayList<LineAnnotationInfo>();
    private boolean annotated = false;
    private String[] columnNames;
    private int[] maxColumnWidth;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAnnotationLength() {
        List<LineAnnotationInfo> list = this.lineAnnotationsInfo;
        synchronized (list) {
            if (this.lineAnnotationsInfo.size() > 0) {
                return this.lineAnnotationsInfo.get(0).getAnnotation().length();
            }
        }
        list = this.blockAnnotationsInfo;
        synchronized (list) {
            if (this.blockAnnotationsInfo.size() > 0) {
                return this.blockAnnotationsInfo.get(0).getAnnotation().length();
            }
        }
        return 0;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setFilePath(String string) {
        this.filePath = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LineAnnotationInfo> getLineAnnotationInfo() {
        List<LineAnnotationInfo> list = this.lineAnnotationsInfo;
        synchronized (list) {
            return new ArrayList<LineAnnotationInfo>(this.lineAnnotationsInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addLineAnnotationInfo(LineAnnotationInfo lineAnnotationInfo) {
        List<LineAnnotationInfo> list = this.lineAnnotationsInfo;
        synchronized (list) {
            this.lineAnnotationsInfo.add(lineAnnotationInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LineAnnotationInfo getLineAnnotationInfoByLineOffset(int n) {
        List<LineAnnotationInfo> list = this.lineAnnotationsInfo;
        synchronized (list) {
            for (LineAnnotationInfo lineAnnotationInfo : this.lineAnnotationsInfo) {
                if (lineAnnotationInfo.getPosition() == null || lineAnnotationInfo.getPosition().getOffset() != n) continue;
                return lineAnnotationInfo;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LineAnnotationInfo getBlockAnnotationInfoByLineOffset(int n) {
        List<LineAnnotationInfo> list = this.blockAnnotationsInfo;
        synchronized (list) {
            for (LineAnnotationInfo lineAnnotationInfo : this.blockAnnotationsInfo) {
                if (lineAnnotationInfo.getPosition() == null || lineAnnotationInfo.getPosition().getOffset() != n) continue;
                return lineAnnotationInfo;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LineAnnotationInfo getLineAnnotationInfoByYCoordinate(int n) {
        List<LineAnnotationInfo> list = this.lineAnnotationsInfo;
        synchronized (list) {
            for (LineAnnotationInfo lineAnnotationInfo : this.lineAnnotationsInfo) {
                if (lineAnnotationInfo.getPosition() == null || lineAnnotationInfo.getY1() > n || n > lineAnnotationInfo.getY2()) continue;
                return lineAnnotationInfo;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LineAnnotationInfo getBlockAnnotationInfoByYCoordinate(int n) {
        List<LineAnnotationInfo> list = this.blockAnnotationsInfo;
        synchronized (list) {
            for (LineAnnotationInfo lineAnnotationInfo : this.blockAnnotationsInfo) {
                if (lineAnnotationInfo.getPosition() == null || lineAnnotationInfo.getY1() > n || n > lineAnnotationInfo.getY2()) continue;
                return lineAnnotationInfo;
            }
        }
        return null;
    }

    public boolean isAnnotated() {
        return this.annotated;
    }

    public void setAnnotated(boolean bl) {
        this.annotated = bl;
    }

    public synchronized String getTooltip() {
        if (this.tooltip == null) {
            StringBuilder stringBuilder = new StringBuilder();
            boolean bl = true;
            stringBuilder.append("<html><body>");
            for (String string : this.getColumnNames()) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append("<br>");
                }
                stringBuilder.append(string);
            }
            stringBuilder.append("</body></html>");
            this.tooltip = stringBuilder.toString();
        }
        return this.tooltip;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Line Annotations:\n");
        for (LineAnnotationInfo lineAnnotationInfo : this.getLineAnnotationInfo()) {
            stringBuilder.append('\t').append(lineAnnotationInfo.toString()).append('\n');
        }
        stringBuilder.append("Block Annotations:\n");
        for (LineAnnotationInfo lineAnnotationInfo : this.getBlockAnnotationInfo()) {
            stringBuilder.append('\t').append(lineAnnotationInfo.toString()).append('\n');
        }
        return stringBuilder.toString();
    }

    public JEditorPane getEditorPane() {
        return this.editorPane;
    }

    public void setEditorPane(JEditorPane jEditorPane) {
        this.editorPane = jEditorPane;
    }

    public int[] getMaxColumnWidth() {
        return this.maxColumnWidth;
    }

    public void setMaxColumnWidth(int[] nArray) {
        this.maxColumnWidth = nArray;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    public void setColumnNames(String[] stringArray) {
        this.columnNames = stringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<LineAnnotationInfo> getBlockAnnotationInfo() {
        List<LineAnnotationInfo> list = this.blockAnnotationsInfo;
        synchronized (list) {
            return new ArrayList<LineAnnotationInfo>(this.blockAnnotationsInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBlockAnnotationInfo(LineAnnotationInfo lineAnnotationInfo) {
        List<LineAnnotationInfo> list = this.blockAnnotationsInfo;
        synchronized (list) {
            this.blockAnnotationsInfo.add(lineAnnotationInfo);
        }
    }
}

