/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.model;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.spring.api.beans.model.FileSpringBeans;
import org.netbeans.modules.spring.api.beans.model.SpringBean;
import org.netbeans.modules.spring.api.beans.model.SpringBeans;
import org.netbeans.modules.spring.beans.model.ExclusiveAccess;
import org.netbeans.modules.spring.beans.model.SpringBeanSource;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigModelSpringBeans
implements SpringBeans {
    private final Map<File, SpringBeanSource> file2BeanSource;

    public ConfigModelSpringBeans(Map<File, SpringBeanSource> map) {
        this.file2BeanSource = map;
    }

    @Override
    public SpringBean findBean(String string) {
        assert (ExclusiveAccess.getInstance().isCurrentThreadAccess()) : "The SpringBeans instance has escaped the Action.run() method";
        return this.findBean(string, new HashSet<String>());
    }

    private SpringBean findBean(String string, Set<String> set) {
        Object object;
        if (set.contains(string)) {
            return null;
        }
        for (SpringBeanSource springBeanSource : this.file2BeanSource.values()) {
            object = springBeanSource.findBean(string);
            if (object == null) continue;
            return object;
        }
        set.add(string);
        for (SpringBeanSource springBeanSource : this.file2BeanSource.values()) {
            object = springBeanSource.findAliasName(string);
            if (object == null) continue;
            return this.findBean((String)object, set);
        }
        return null;
    }

    @Override
    public FileSpringBeans getFileBeans(FileObject fileObject) {
        assert (ExclusiveAccess.getInstance().isCurrentThreadAccess()) : "The SpringBeans instance has escaped the Action.run() method";
        File file = FileUtil.toFile((FileObject)fileObject);
        if (file != null) {
            return this.file2BeanSource.get(file);
        }
        return null;
    }

    @Override
    public List<SpringBean> getBeans() {
        assert (ExclusiveAccess.getInstance().isCurrentThreadAccess()) : "The SpringBeans instance has escaped the Action.run() method";
        ArrayList<SpringBean> arrayList = new ArrayList<SpringBean>(this.file2BeanSource.size() * 20);
        for (SpringBeanSource springBeanSource : this.file2BeanSource.values()) {
            arrayList.addAll(springBeanSource.getBeans());
        }
        return Collections.unmodifiableList(arrayList);
    }

    @Override
    public Set<String> getAliases() {
        assert (ExclusiveAccess.getInstance().isCurrentThreadAccess()) : "The SpringBeans instance has escaped the Action.run() method";
        HashSet<String> hashSet = new HashSet<String>(this.file2BeanSource.size() * 5);
        for (SpringBeanSource springBeanSource : this.file2BeanSource.values()) {
            hashSet.addAll(springBeanSource.getAliases());
        }
        return Collections.unmodifiableSet(hashSet);
    }
}

