/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.beans.hyperlink;

import java.io.IOException;
import org.netbeans.modules.spring.api.Action;
import org.netbeans.modules.spring.api.beans.model.SpringBean;
import org.netbeans.modules.spring.api.beans.model.SpringBeans;
import org.netbeans.modules.spring.api.beans.model.SpringConfigModel;
import org.netbeans.modules.spring.beans.hyperlink.HyperlinkEnv;
import org.netbeans.modules.spring.beans.hyperlink.HyperlinkProcessor;
import org.netbeans.modules.spring.beans.utils.StringUtils;
import org.netbeans.modules.spring.util.SpringBeansUIs;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class BeansRefHyperlinkProcessor
extends HyperlinkProcessor {
    private boolean globalSearch;

    public BeansRefHyperlinkProcessor(boolean bl) {
        this.globalSearch = bl;
    }

    public void process(HyperlinkEnv hyperlinkEnv) {
        final FileObject fileObject = hyperlinkEnv.getFileObject();
        if (fileObject == null) {
            return;
        }
        SpringConfigModel springConfigModel = SpringConfigModel.forFileObject(fileObject);
        if (springConfigModel == null) {
            return;
        }
        final String string = this.getBeanName(hyperlinkEnv);
        final SpringBeansUIs.GoToBeanAction[] goToBeanActionArray = new SpringBeansUIs.GoToBeanAction[]{null};
        try {
            springConfigModel.runReadAction(new Action<SpringBeans>(){

                @Override
                public void run(SpringBeans springBeans) {
                    SpringBean springBean = BeansRefHyperlinkProcessor.this.globalSearch ? springBeans.findBean(string) : springBeans.getFileBeans(fileObject).findBeanByID(string);
                    if (springBean == null) {
                        return;
                    }
                    goToBeanActionArray[0] = SpringBeansUIs.createGoToBeanAction(springBean);
                }
            });
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
        if (goToBeanActionArray[0] != null) {
            goToBeanActionArray[0].invoke();
        }
    }

    private String getBeanName(HyperlinkEnv hyperlinkEnv) {
        int[] nArray = this.getBeanOffsets(hyperlinkEnv);
        return hyperlinkEnv.getValueString().substring(nArray[0], nArray[1]);
    }

    private int[] getBeanOffsets(HyperlinkEnv hyperlinkEnv) {
        String string = hyperlinkEnv.getValueString();
        int n = hyperlinkEnv.getTokenStartOffset() + 1;
        int n2 = hyperlinkEnv.getOffset() - n;
        int n3 = Math.max(0, StringUtils.lastIndexOfAnyDelimiter(string, 0, n2, ",; ") + 1);
        int n4 = StringUtils.indexOfAnyDelimiter(string, n2, ",; ");
        if (n4 == -1) {
            n4 = string.length();
        }
        return new int[]{n3, n4};
    }

    public int[] getSpan(HyperlinkEnv hyperlinkEnv) {
        int[] nArray = this.getBeanOffsets(hyperlinkEnv);
        if (!StringUtils.hasText(hyperlinkEnv.getValueString())) {
            return new int[]{-1, -1};
        }
        int n = hyperlinkEnv.getTokenStartOffset() + 1;
        return new int[]{n + nArray[0], n + nArray[1]};
    }
}

