/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.ui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.cnd.api.remote.HostInfoProvider;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.remote.mapper.RemotePathMap;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditPathMapDialog
extends JPanel
implements ActionListener {
    private static final String ACTION_INLINE_EDITOR = "invokeInlineEditor";
    private static final String ACTION_ESCAPE_TABLE = "escapeTable";
    private static final String ACTION_TAB_IN_CELL = "tabInCell";
    private static final String ACTION_SHIFT_TAB_IN_CELL = "shiftTabInCell";
    private final JButton btnOK;
    private Dialog presenter;
    private ServerRecord currentHost;
    private DefaultComboBoxModel serverListModel;
    private final String pathToValidate;
    private final Map<ServerRecord, DefaultTableModel> cache = new HashMap<ServerRecord, DefaultTableModel>();
    private ProgressHandle phandle;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JLabel lblHostName;
    private JTable tblPathMappings;
    private JTextField tfHostName;
    private JTextArea txtError;
    private JTextArea txtExplanation;
    private Action editAction;

    public static boolean showMe(ServerRecord serverRecord, List<ServerRecord> list) {
        return EditPathMapDialog.showMe(serverRecord, null, list);
    }

    public static boolean showMe(ExecutionEnvironment executionEnvironment, String string) {
        return EditPathMapDialog.showMe(ServerList.get((ExecutionEnvironment)executionEnvironment), string);
    }

    private static boolean showMe(ServerRecord serverRecord, String string) {
        return EditPathMapDialog.showMe(serverRecord, string, ServerList.getRecords());
    }

    private static boolean showMe(ServerRecord serverRecord, String string, Collection<? extends ServerRecord> collection) {
        Dialog dialog;
        JButton jButton = new JButton(NbBundle.getMessage(EditPathMapDialog.class, (String)"BTN_OK"));
        EditPathMapDialog editPathMapDialog = new EditPathMapDialog(serverRecord, string, collection, jButton);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)editPathMapDialog, NbBundle.getMessage(EditPathMapDialog.class, (String)"EditPathMapDialogTitle"), true, new Object[]{jButton, DialogDescriptor.CANCEL_OPTION}, (Object)jButton, 0, null, (ActionListener)editPathMapDialog);
        dialogDescriptor.setClosingOptions(new Object[]{DialogDescriptor.CANCEL_OPTION});
        editPathMapDialog.presenter = dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
        dialog.setVisible(true);
        if (dialogDescriptor.getValue() == jButton) {
            editPathMapDialog.applyChanges();
            return true;
        }
        return false;
    }

    protected EditPathMapDialog(ServerRecord serverRecord, String string, Collection<? extends ServerRecord> collection, JButton jButton) {
        this.btnOK = jButton;
        this.pathToValidate = string;
        this.currentHost = serverRecord;
        this.serverListModel = new DefaultComboBoxModel();
        for (ServerRecord serverRecord2 : collection) {
            if (!serverRecord2.isRemote()) continue;
            this.serverListModel.addElement(serverRecord2);
        }
        this.initComponents();
        this.addTableActions();
        this.tfHostName.setBackground(this.getBackground());
        this.tfHostName.setText(this.currentHost.getDisplayName());
        this.initTable();
        String string2 = string != null ? NbBundle.getMessage(EditPathMapDialog.class, (String)"EPMD_ExplanationWithPath", (Object)string) : NbBundle.getMessage(EditPathMapDialog.class, (String)"EPMD_Explanation");
        this.txtExplanation.setText(string2);
        if ("Windows".equals(UIManager.getLookAndFeel().getID())) {
            this.jScrollPane1.setOpaque(false);
            this.jScrollPane3.setOpaque(false);
        }
        this.initTableModel(this.currentHost);
    }

    private void initTable() {
        this.tblPathMappings.getTableHeader().setPreferredSize(new Dimension(0, 20));
        this.tblPathMappings.getTableHeader().setFocusable(false);
        this.tblPathMappings.getTableHeader().setEnabled(false);
        this.tblPathMappings.getSelectionModel().setSelectionMode(1);
        this.tblPathMappings.getInputMap().put(KeyStroke.getKeyStroke(32, 0), ACTION_INLINE_EDITOR);
        this.tblPathMappings.getInputMap().put(KeyStroke.getKeyStroke(113, 0), ACTION_INLINE_EDITOR);
        this.tblPathMappings.getActionMap().put(ACTION_INLINE_EDITOR, this.getEditAction());
        this.tblPathMappings.setSurrendersFocusOnKeystroke(true);
        this.tblPathMappings.setCellSelectionEnabled(false);
        this.tblPathMappings.setRowSelectionAllowed(true);
        this.tblPathMappings.putClientProperty("JTable.autoStartsEdit", Boolean.FALSE);
        this.tblPathMappings.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.tblPathMappings.getInputMap().put(KeyStroke.getKeyStroke(27, 0), ACTION_ESCAPE_TABLE);
        this.tblPathMappings.getActionMap().put(ACTION_ESCAPE_TABLE, new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                EditPathMapDialog.this.btnOK.requestFocus();
            }
        });
    }

    private static RemotePathMap getRemotePathMap(ExecutionEnvironment executionEnvironment) {
        return RemotePathMap.getPathMap(executionEnvironment);
    }

    private void addTableActions() throws MissingResourceException {
        AbstractAction abstractAction = new AbstractAction(NbBundle.getMessage(this.getClass(), (String)"ACTION_Remove")){

            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = EditPathMapDialog.this.tblPathMappings.getSelectedRows();
                if (nArray.length > 0) {
                    DefaultTableModel defaultTableModel = (DefaultTableModel)EditPathMapDialog.this.tblPathMappings.getModel();
                    Arrays.sort(nArray);
                    for (int i = nArray.length - 1; i >= 0; --i) {
                        defaultTableModel.removeRow(nArray[i]);
                    }
                }
            }
        };
        AbstractAction abstractAction2 = new AbstractAction(NbBundle.getMessage(this.getClass(), (String)"ACTION_Insert")){

            public void actionPerformed(ActionEvent actionEvent) {
                int n = EditPathMapDialog.this.tblPathMappings.getSelectedRow();
                n = n < 0 ? 0 : n;
                DefaultTableModel defaultTableModel = (DefaultTableModel)EditPathMapDialog.this.tblPathMappings.getModel();
                defaultTableModel.insertRow(n, new Object[]{"", ""});
            }
        };
        final JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(new JMenuItem(abstractAction2));
        jPopupMenu.add(new JMenuItem(abstractAction));
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class MenuListener
        extends MouseAdapter {
            MenuListener() {
            }

            private void showMenu(MouseEvent mouseEvent) {
                int n;
                if (mouseEvent != null && (n = EditPathMapDialog.this.tblPathMappings.rowAtPoint(mouseEvent.getPoint())) >= 0 && EditPathMapDialog.this.tblPathMappings.getSelectionModel().isSelectionEmpty()) {
                    EditPathMapDialog.this.tblPathMappings.getSelectionModel().setSelectionInterval(n, n);
                }
                jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    this.showMenu(mouseEvent);
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    this.showMenu(mouseEvent);
                }
            }
        }
        MenuListener menuListener = new MenuListener();
        this.tblPathMappings.addMouseListener(menuListener);
    }

    private synchronized void initTableModel(final ServerRecord serverRecord) {
        DefaultTableModel defaultTableModel = this.cache.get(serverRecord);
        if (defaultTableModel == null) {
            this.handleProgress(true);
            defaultTableModel = new DefaultTableModel(0, 2);
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    final DefaultTableModel defaultTableModel = EditPathMapDialog.this.prepareTableModel(serverRecord.getExecutionEnvironment());
                    EditPathMapDialog.this.cache.put(serverRecord, defaultTableModel);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            if (EditPathMapDialog.this.tblPathMappings != null) {
                                EditPathMapDialog.this.handleProgress(false);
                                EditPathMapDialog.this.updatePathMappingsTable(defaultTableModel);
                                EditPathMapDialog.this.enableControls(true, "");
                            }
                        }
                    });
                }
            });
            this.enableControls(false, NbBundle.getMessage(EditPathMapDialog.class, (String)"EPMD_Loading"));
            this.cache.put(serverRecord, defaultTableModel);
        }
        this.updatePathMappingsTable(defaultTableModel);
    }

    private void enableControls(boolean bl, String string) {
        this.btnOK.setEnabled(bl);
        this.tblPathMappings.setEnabled(bl);
        this.txtError.setText(string);
    }

    private void updatePathMappingsTable(DefaultTableModel defaultTableModel) {
        this.tblPathMappings.setModel(defaultTableModel);
        this.tblPathMappings.getColumnModel().getColumn(0).setCellEditor(new PathCellEditor());
        this.setColumnNames();
    }

    private DefaultTableModel prepareTableModel(ExecutionEnvironment executionEnvironment) {
        Map<String, String> map = EditPathMapDialog.getRemotePathMap(executionEnvironment).getMap();
        DefaultTableModel defaultTableModel = new DefaultTableModel(0, 2);
        for (Map.Entry<String, String> entry : map.entrySet()) {
            defaultTableModel.addRow(new String[]{entry.getKey(), entry.getValue()});
        }
        if (defaultTableModel.getRowCount() < 4) {
            for (int i = 4; i > defaultTableModel.getRowCount(); --i) {
                defaultTableModel.addRow(new String[]{null, null});
            }
        } else {
            defaultTableModel.addRow(new String[]{null, null});
        }
        return defaultTableModel;
    }

    private void setColumnNames() {
        this.tblPathMappings.getColumnModel().getColumn(0).setHeaderValue(NbBundle.getMessage(EditPathMapDialog.class, (String)"LocalPathColumnName"));
        this.tblPathMappings.getColumnModel().getColumn(1).setHeaderValue(NbBundle.getMessage(EditPathMapDialog.class, (String)"RemotePathColumnName"));
    }

    void applyChanges() {
        for (ServerRecord serverRecord : this.cache.keySet()) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            DefaultTableModel defaultTableModel = this.cache.get(serverRecord);
            for (int i = 0; i < defaultTableModel.getRowCount(); ++i) {
                String string = (String)defaultTableModel.getValueAt(i, 0);
                String string2 = (String)defaultTableModel.getValueAt(i, 1);
                if (string == null || string2 == null) continue;
                string = string.trim();
                string2 = string2.trim();
                if (string.length() <= 0 || string2.length() <= 0) continue;
                hashMap.put(string, string2);
            }
            EditPathMapDialog.getRemotePathMap(serverRecord.getExecutionEnvironment()).updatePathMap(hashMap);
        }
    }

    private void initComponents() {
        this.lblHostName = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.tblPathMappings = new JTable();
        this.jScrollPane2 = new JScrollPane();
        this.txtExplanation = new JTextArea();
        this.jScrollPane3 = new JScrollPane();
        this.txtError = new JTextArea();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.tfHostName = new JTextField();
        this.lblHostName.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/remote/ui/Bundle").getString("EPMD_Hostname").charAt(0));
        this.lblHostName.setText(NbBundle.getMessage(EditPathMapDialog.class, (String)"EditPathMapDialog.lblHostName.text"));
        this.lblHostName.setFocusable(false);
        this.tblPathMappings.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.tblPathMappings.getTableHeader().setResizingAllowed(false);
        this.tblPathMappings.getTableHeader().setReorderingAllowed(false);
        this.jScrollPane1.setViewportView(this.tblPathMappings);
        this.tblPathMappings.getAccessibleContext().setAccessibleName(NbBundle.getMessage(EditPathMapDialog.class, (String)"EPMD_MappingsTable_AN"));
        this.tblPathMappings.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EditPathMapDialog.class, (String)"EPMD_MappingsTable_AD"));
        this.jScrollPane2.setBorder(null);
        this.jScrollPane2.setEnabled(false);
        this.jScrollPane2.setFocusable(false);
        this.txtExplanation.setBackground(this.getBackground());
        this.txtExplanation.setColumns(20);
        this.txtExplanation.setLineWrap(true);
        this.txtExplanation.setRows(4);
        this.txtExplanation.setText(NbBundle.getMessage(EditPathMapDialog.class, (String)"EditPathMapDialog.txtExplanation.text"));
        this.txtExplanation.setWrapStyleWord(true);
        this.txtExplanation.setAutoscrolls(false);
        this.txtExplanation.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.txtExplanation.setFocusable(false);
        this.jScrollPane2.setViewportView(this.txtExplanation);
        this.jScrollPane3.setBorder(null);
        this.jScrollPane3.setEnabled(false);
        this.jScrollPane3.setFocusable(false);
        this.txtError.setBackground(this.getBackground());
        this.txtError.setColumns(20);
        this.txtError.setForeground(new Color(255, 0, 0));
        this.txtError.setLineWrap(true);
        this.txtError.setRows(4);
        this.txtError.setWrapStyleWord(true);
        this.txtError.setFocusable(false);
        this.jScrollPane3.setViewportView(this.txtError);
        this.jPanel1.setLayout(new BorderLayout());
        this.jLabel1.setLabelFor(this.tblPathMappings);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(EditPathMapDialog.class, (String)"EPMD_MappingsTable_AN"));
        this.tfHostName.setEditable(false);
        this.tfHostName.setText(NbBundle.getMessage(EditPathMapDialog.class, (String)"EditPathMapDialog.tfHostName.text"));
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.jScrollPane1, -1, 440, Short.MAX_VALUE).add((Component)this.jScrollPane3, -1, 440, Short.MAX_VALUE).add((Component)this.jPanel1, -1, 440, Short.MAX_VALUE).add((Component)this.jScrollPane2, -1, 440, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.lblHostName).addPreferredGap(1).add((Component)this.tfHostName, -1, 393, Short.MAX_VALUE)).add((Component)this.jLabel1)).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lblHostName).add((Component)this.tfHostName, -2, -1, -2)).addPreferredGap(0).add((Component)this.jScrollPane2, -2, 61, -2).add(5, 5, 5).add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jScrollPane1, -2, 99, -2).addPreferredGap(0).add((Component)this.jPanel1, -2, 23, -2).addPreferredGap(0, 11, Short.MAX_VALUE).add((Component)this.jScrollPane3, -2, 118, -2).addContainerGap()));
        this.lblHostName.getAccessibleContext().setAccessibleName(NbBundle.getMessage(EditPathMapDialog.class, (String)"EPMD_Hostname"));
        this.lblHostName.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(EditPathMapDialog.class, (String)"EPMD_Host_AD"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.btnOK) {
            if (this.cache.get(this.currentHost).getRowCount() == 0) {
                this.presenter.setVisible(false);
                return;
            }
            this.handleProgress(true);
            this.enableControls(false, NbBundle.getMessage(EditPathMapDialog.class, (String)"EPMD_Validating"));
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    final String string = EditPathMapDialog.this.validateMaps();
                    Runnable runnable = string.length() == 0 ? new Runnable(){

                        public void run() {
                            try {
                                Thread.sleep(500L);
                            }
                            catch (InterruptedException interruptedException) {
                                Exceptions.printStackTrace((Throwable)interruptedException);
                            }
                            EditPathMapDialog.this.presenter.setVisible(false);
                        }
                    } : new Runnable(){

                        public void run() {
                            EditPathMapDialog.this.handleProgress(false);
                            EditPathMapDialog.this.enableControls(true, string);
                        }
                    };
                    SwingUtilities.invokeLater(runnable);
                }
            });
        }
    }

    private void handleProgress(boolean bl) {
        if (bl) {
            this.phandle = ProgressHandleFactory.createHandle((String)"");
            this.jPanel1.add((Component)ProgressHandleFactory.createProgressComponent((ProgressHandle)this.phandle), "North");
            this.jPanel1.setVisible(true);
            this.phandle.start();
        } else {
            this.phandle.finish();
            this.jPanel1.setVisible(false);
            this.jPanel1.removeAll();
        }
    }

    private String validateMaps() {
        DefaultTableModel defaultTableModel = this.cache.get(this.currentHost);
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        for (int i = 0; i < defaultTableModel.getRowCount(); ++i) {
            String string = (String)defaultTableModel.getValueAt(i, 0);
            String string2 = (String)defaultTableModel.getValueAt(i, 1);
            if (string != null && (string = string.trim()).length() > 0) {
                if (!HostInfoProvider.fileExists((ExecutionEnvironment)ExecutionEnvironmentFactory.getLocal(), (String)string)) {
                    stringBuilder.append(NbBundle.getMessage(EditPathMapDialog.class, (String)"EPMD_BadLocalPath", (Object)string));
                }
                if (this.pathToValidate != null && !bl && string2 != null && RemotePathMap.isSubPath(string, this.pathToValidate)) {
                    bl = true;
                }
            }
            if (string2 == null || (string2 = string2.trim()).length() <= 0 || HostInfoProvider.fileExists((ExecutionEnvironment)this.currentHost.getExecutionEnvironment(), (String)string2)) continue;
            stringBuilder.append(NbBundle.getMessage(EditPathMapDialog.class, (String)"EPMD_BadRemotePath", (Object)string2));
        }
        if (this.pathToValidate != null && !bl) {
            stringBuilder.append(NbBundle.getMessage(EditPathMapDialog.class, (String)"EPMD_PathNotResolved", (Object)this.pathToValidate));
        }
        return stringBuilder.toString();
    }

    private Action getEditAction() {
        if (this.editAction == null) {
            this.editAction = new EditAction();
        }
        return this.editAction;
    }

    private static void autoEdit(JTable jTable) {
        if (jTable.editCellAt(jTable.getSelectedRow(), jTable.getSelectedColumn(), null) && jTable.getEditorComponent() != null) {
            if (jTable.getSelectedColumn() == 0) {
                JPanel jPanel = (JPanel)jTable.getEditorComponent();
                JTextField jTextField = (JTextField)jPanel.getComponent(0);
                jTextField.setCaretPosition(jTextField.getText().length());
                jTextField.requestFocusInWindow();
                jTextField.selectAll();
            } else {
                JTextField jTextField = (JTextField)jTable.getEditorComponent();
                jTextField.setCaretPosition(jTextField.getText().length());
                jTextField.requestFocusInWindow();
                jTextField.selectAll();
            }
        }
    }

    private static class EditAction
    extends AbstractAction {
        private EditAction() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            EditPathMapDialog.autoEdit((JTable)actionEvent.getSource());
        }
    }

    private static class PathCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        private final JPanel panel;
        private final JTextField tfPath = new JTextField();
        private final JButton btnBrowse = new JButton(NbBundle.getMessage(EditPathMapDialog.class, (String)"BTN_Browse"));

        public PathCellEditor() {
            this.panel = new JPanel();
            this.panel.setLayout(new BorderLayout());
            this.tfPath.setBorder(BorderFactory.createEmptyBorder());
            this.btnBrowse.setPreferredSize(new Dimension(20, this.btnBrowse.getMinimumSize().height));
            this.panel.add((Component)this.tfPath, "Center");
            this.panel.add((Component)this.btnBrowse, "East");
            this.btnBrowse.addActionListener(this);
            this.tfPath.getInputMap().put(KeyStroke.getKeyStroke(9, 0), EditPathMapDialog.ACTION_TAB_IN_CELL);
            this.tfPath.getActionMap().put(EditPathMapDialog.ACTION_TAB_IN_CELL, new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PathCellEditor.this.tfPath.setSelectionStart(0);
                    PathCellEditor.this.tfPath.setSelectionEnd(0);
                    PathCellEditor.this.btnBrowse.requestFocus();
                    PathCellEditor.this.btnBrowse.setSelected(true);
                }
            });
            this.btnBrowse.getInputMap().put(KeyStroke.getKeyStroke(9, 1), EditPathMapDialog.ACTION_SHIFT_TAB_IN_CELL);
            this.btnBrowse.getActionMap().put(EditPathMapDialog.ACTION_SHIFT_TAB_IN_CELL, new AbstractAction(){

                public void actionPerformed(ActionEvent actionEvent) {
                    PathCellEditor.this.tfPath.setSelectionStart(0);
                    PathCellEditor.this.tfPath.setSelectionEnd(PathCellEditor.this.tfPath.getText().length());
                    PathCellEditor.this.btnBrowse.setSelected(false);
                    PathCellEditor.this.tfPath.requestFocus();
                }
            });
        }

        public void actionPerformed(ActionEvent actionEvent) {
            File file = new File(this.tfPath.getText());
            JFileChooser jFileChooser = new JFileChooser(file);
            jFileChooser.setFileSelectionMode(1);
            jFileChooser.setApproveButtonText(NbBundle.getMessage(EditPathMapDialog.class, (String)"BTN_Choose"));
            jFileChooser.setDialogTitle(NbBundle.getMessage(EditPathMapDialog.class, (String)"DIR_Choose_Title"));
            jFileChooser.setApproveButtonMnemonic(10);
            if (jFileChooser.showOpenDialog(this.panel) == 0) {
                this.tfPath.setText(jFileChooser.getSelectedFile().getAbsolutePath());
            }
        }

        public Object getCellEditorValue() {
            return this.tfPath.getText().trim();
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.tfPath.setText((String)object);
            return this.panel;
        }
    }
}

