/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.monitor.client;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.modules.schema2beans.BaseBean;
import org.netbeans.modules.web.monitor.client.CurrNode;
import org.netbeans.modules.web.monitor.client.NavigateNode;
import org.netbeans.modules.web.monitor.client.NestedNode;
import org.netbeans.modules.web.monitor.client.ProgressMonitor;
import org.netbeans.modules.web.monitor.client.SavedNode;
import org.netbeans.modules.web.monitor.client.TransactionNode;
import org.netbeans.modules.web.monitor.data.DataRecord;
import org.netbeans.modules.web.monitor.data.DispatchData;
import org.netbeans.modules.web.monitor.data.Dispatches;
import org.netbeans.modules.web.monitor.data.MonitorData;
import org.netbeans.modules.web.monitor.data.RequestData;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.filesystems.FileAlreadyLockedException;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

class Controller {
    static final String REPLAY = "netbeans.replay";
    static final String PORT = "netbeans.replay.port";
    static final String REPLAYSTATUS = "netbeans.replay.status";
    static final String REPLAYSESSION = "netbeans.replay.session";
    static final boolean debug = false;
    private static transient String server = "localhost";
    private static transient int port = 8080;
    private static FileObject monDir = null;
    private static FileObject currDir = null;
    private static FileObject saveDir = null;
    private static FileObject replayDir = null;
    static final String monDirStr = "HTTPMonitor";
    static final String currDirStr = "current";
    static final String saveDirStr = "save";
    static final String replayDirStr = "replay";
    private transient NavigateNode root = null;
    private Children.SortedArray currTrans = null;
    private Children.SortedArray savedTrans = null;
    private Hashtable currBeans = null;
    private Hashtable saveBeans = null;
    private transient Comparator comp = null;
    private boolean useBrowserCookie = true;
    private static Controller instance = null;
    private Date startDate = new Date(System.currentTimeMillis() - 30000L);

    private Controller() {
        this.currBeans = new Hashtable();
        this.saveBeans = new Hashtable();
        this.createNodeStructure();
    }

    static Controller getInstance() {
        if (instance == null) {
            instance = new Controller();
        }
        return instance;
    }

    private void createNodeStructure() {
        this.comp = new CompTime(true);
        this.currTrans = new Children.SortedArray();
        this.currTrans.setComparator(this.comp);
        this.savedTrans = new Children.SortedArray();
        this.savedTrans.setComparator(this.comp);
        CurrNode currNode = new CurrNode((Children)this.currTrans);
        SavedNode savedNode = new SavedNode((Children)this.savedTrans);
        Node[] nodeArray = new Node[]{currNode, savedNode};
        Children.Array array = new Children.Array();
        array.add(nodeArray);
        this.root = new NavigateNode((Children)array);
    }

    void addTransaction(String string) {
        TransactionNode[] transactionNodeArray = new TransactionNode[1];
        MonitorData monitorData = this.retrieveMonitorData(string, currDirStr);
        try {
            transactionNodeArray[0] = this.createTransactionNode(monitorData, true);
            this.currTrans.add((Node[])transactionNodeArray);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected NavigateNode getRoot() {
        return this.root;
    }

    protected static FileObject getMonDir() throws FileNotFoundException {
        if (monDir == null || !monDir.isFolder()) {
            Controller.createDirectories();
        }
        return monDir;
    }

    protected static FileObject getCurrDir() throws FileNotFoundException {
        if (currDir == null || !currDir.isFolder()) {
            Controller.createDirectories();
        }
        return currDir;
    }

    protected static FileObject getReplayDir() throws FileNotFoundException {
        if (replayDir == null || !replayDir.isFolder()) {
            Controller.createDirectories();
        }
        return replayDir;
    }

    protected static FileObject getSaveDir() throws FileNotFoundException {
        if (saveDir == null || !saveDir.isFolder()) {
            Controller.createDirectories();
        }
        return saveDir;
    }

    boolean haveDirectories() {
        if (currDir == null) {
            try {
                currDir = Controller.getCurrDir();
            }
            catch (Exception exception) {
                return false;
            }
        }
        if (saveDir == null) {
            try {
                saveDir = Controller.getSaveDir();
            }
            catch (Exception exception) {
                return false;
            }
        }
        return true;
    }

    private static void createDirectories() throws FileNotFoundException {
        FileObject fileObject = FileUtil.getConfigRoot();
        FileLock fileLock = null;
        if (monDir == null || !monDir.isFolder()) {
            try {
                monDir = fileObject.getFileObject(monDirStr);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (monDir == null || !monDir.isFolder()) {
                if (monDir != null) {
                    try {
                        fileLock = monDir.lock();
                        monDir.delete(fileLock);
                    }
                    catch (FileAlreadyLockedException fileAlreadyLockedException) {
                        throw new FileNotFoundException();
                    }
                    catch (IOException iOException) {
                        throw new FileNotFoundException();
                    }
                    finally {
                        if (fileLock != null) {
                            fileLock.releaseLock();
                        }
                    }
                }
                try {
                    monDir = fileObject.createFolder(monDirStr);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (monDir == null || !monDir.isFolder()) {
                throw new FileNotFoundException();
            }
        }
        if (currDir == null || !currDir.isFolder()) {
            try {
                currDir = monDir.getFileObject(currDirStr);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (currDir == null || !currDir.isFolder()) {
                fileLock = null;
                if (currDir != null) {
                    try {
                        fileLock = currDir.lock();
                        currDir.delete(fileLock);
                    }
                    catch (FileAlreadyLockedException fileAlreadyLockedException) {
                        throw new FileNotFoundException();
                    }
                    catch (IOException iOException) {
                        throw new FileNotFoundException();
                    }
                    finally {
                        if (fileLock != null) {
                            fileLock.releaseLock();
                        }
                    }
                }
                try {
                    currDir = monDir.createFolder(currDirStr);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (currDir == null || !currDir.isFolder()) {
                throw new FileNotFoundException();
            }
        }
        if (saveDir == null || !saveDir.isFolder()) {
            try {
                saveDir = monDir.getFileObject(saveDirStr);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (saveDir == null || !saveDir.isFolder()) {
                if (saveDir != null) {
                    fileLock = null;
                    try {
                        fileLock = saveDir.lock();
                        saveDir.delete(fileLock);
                    }
                    catch (FileAlreadyLockedException fileAlreadyLockedException) {
                        throw new FileNotFoundException();
                    }
                    catch (IOException iOException) {
                        throw new FileNotFoundException();
                    }
                    finally {
                        if (fileLock != null) {
                            fileLock.releaseLock();
                        }
                    }
                }
                try {
                    saveDir = monDir.createFolder(saveDirStr);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (saveDir == null || !saveDir.isFolder()) {
                throw new FileNotFoundException();
            }
        }
        if (replayDir == null || !replayDir.isFolder()) {
            try {
                replayDir = monDir.getFileObject(replayDirStr);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (replayDir == null || !replayDir.isFolder()) {
                if (replayDir != null) {
                    fileLock = null;
                    try {
                        fileLock = replayDir.lock();
                        replayDir.delete(fileLock);
                    }
                    catch (FileAlreadyLockedException fileAlreadyLockedException) {
                        throw new FileNotFoundException();
                    }
                    catch (IOException iOException) {
                        throw new FileNotFoundException();
                    }
                    finally {
                        if (fileLock != null) {
                            fileLock.releaseLock();
                        }
                    }
                }
                try {
                    replayDir = monDir.createFolder(replayDirStr);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (replayDir == null || !replayDir.isFolder()) {
                throw new FileNotFoundException();
            }
        }
    }

    void replayTransaction(Node node) {
        if (!this.checkServer(true)) {
            return;
        }
        TransactionNode transactionNode = null;
        try {
            transactionNode = (TransactionNode)node;
        }
        catch (ClassCastException classCastException) {
            return;
        }
        MonitorData monitorData = this.getMonitorData(transactionNode, false, false);
        if (monitorData == null) {
            String string = NbBundle.getMessage((Class)Controller.class, (String)"MSG_NoMonitorData");
            Logger.getLogger("global").log(Level.INFO, string);
            return;
        }
        if (!this.useBrowserCookie) {
            monitorData.getRequestData().setReplaceSessionCookie(true);
        }
        String string = transactionNode.isCurrent() ? currDirStr : saveDirStr;
        try {
            this.replayTransaction(monitorData, string);
        }
        catch (UnknownHostException unknownHostException) {
            Object[] objectArray = new Object[]{NbBundle.getBundle((Class)Controller.class).getString("MON_OK")};
            NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)NbBundle.getMessage((Class)Controller.class, (String)"MON_Exec_server_no_host", (Object)monitorData.getServerName()), NbBundle.getBundle((Class)Controller.class).getString("MON_Exec_server"), -1, 1, objectArray, objectArray[0]);
            DialogDisplayer.getDefault().notify(notifyDescriptor);
        }
        catch (IOException iOException) {
            Object[] objectArray = new Object[]{NbBundle.getBundle((Class)Controller.class).getString("MON_OK")};
            NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)NbBundle.getMessage((Class)Controller.class, (String)"MON_Exec_server_start", (Object)monitorData.getServerAndPort()), NbBundle.getBundle((Class)Controller.class).getString("MON_Exec_server"), -1, 1, objectArray, objectArray[0]);
            DialogDisplayer.getDefault().notify(notifyDescriptor);
        }
    }

    void replayTransaction(MonitorData monitorData) throws UnknownHostException, IOException {
        FileObject fileObject;
        FileLock fileLock = null;
        OutputStream outputStream = null;
        PrintWriter printWriter = null;
        String string = monitorData.getAttributeValue("id");
        try {
            fileObject = Controller.getReplayDir().createData(string, "xml");
        }
        catch (IOException iOException) {
            try {
                fileObject = Controller.getReplayDir().getFileObject(string, "xml");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new IOException("No replay dir");
            }
            if (!fileObject.isData()) {
                throw new IOException("Can't create file, giving up");
            }
            try {
                fileLock = fileObject.lock();
            }
            catch (FileAlreadyLockedException fileAlreadyLockedException) {
                throw new IOException("Old file exist, islocked");
            }
            try {
                fileObject.delete(fileLock);
            }
            catch (IOException iOException2) {
                throw new IOException("Couldn't delete old file");
            }
            finally {
                if (fileLock != null) {
                    fileLock.releaseLock();
                }
            }
            fileObject = Controller.getReplayDir().createData(string, "xml");
        }
        try {
            fileLock = fileObject.lock();
        }
        catch (FileAlreadyLockedException fileAlreadyLockedException) {
            throw new IOException();
        }
        try {
            outputStream = fileObject.getOutputStream(fileLock);
            printWriter = new PrintWriter(outputStream);
            monitorData.write(printWriter);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        finally {
            if (fileLock != null) {
                fileLock.releaseLock();
            }
            try {
                printWriter.close();
            }
            catch (Throwable throwable) {}
            try {
                outputStream.close();
            }
            catch (Throwable throwable) {}
        }
        try {
            this.replayTransaction(monitorData, replayDirStr);
        }
        catch (UnknownHostException unknownHostException) {
            throw unknownHostException;
        }
        catch (IOException iOException) {
            throw iOException;
        }
    }

    void replayTransaction(MonitorData monitorData, String string) throws UnknownHostException, IOException {
        URL uRL = null;
        try {
            String string2 = monitorData.getServerName();
            int n = monitorData.getServerPort();
            StringBuffer stringBuffer = new StringBuffer(128);
            stringBuffer.append(monitorData.getRequestData().getAttributeValue("uri"));
            stringBuffer.append("?");
            stringBuffer.append(REPLAY);
            stringBuffer.append("=");
            stringBuffer.append(monitorData.getAttributeValue("id"));
            stringBuffer.append("&");
            stringBuffer.append(REPLAYSTATUS);
            stringBuffer.append("=");
            stringBuffer.append(string);
            String string3 = null;
            try {
                URL uRL2 = Controller.getSampleHTTPServerURL();
                string3 = String.valueOf(uRL2.getPort());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (string3 != null) {
                stringBuffer.append("&");
                stringBuffer.append(PORT);
                stringBuffer.append("=");
                stringBuffer.append(string3);
            }
            if (monitorData.getRequestData().getReplaceSessionCookie()) {
                stringBuffer.append("&");
                stringBuffer.append(REPLAYSESSION);
                stringBuffer.append("=");
                stringBuffer.append(monitorData.getRequestData().getSessionID());
            }
            uRL = new URL("http", string2, n, stringBuffer.toString());
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            this.showReplay(uRL);
        }
        catch (UnknownHostException unknownHostException) {
            throw unknownHostException;
        }
        catch (IOException iOException) {
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void saveTransaction(Node[] nodeArray) {
        if (!this.haveDirectories()) {
            Controller.log("Couldn't get the directory");
            return;
        }
        Node[] nodeArray2 = new Node[nodeArray.length];
        boolean bl = false;
        for (int i = 0; i < nodeArray.length; ++i) {
            TransactionNode transactionNode = (TransactionNode)nodeArray[i];
            String string = transactionNode.getID();
            if (this.currBeans.containsKey(string)) {
                this.saveBeans.put(string, this.currBeans.remove(string));
            }
            FileLock fileLock = null;
            try {
                FileObject fileObject = currDir.getFileObject(string, "xml");
                fileLock = fileObject.lock();
                fileObject.copy(saveDir, string, "xml");
                fileObject.delete(fileLock);
                transactionNode.setCurrent(false);
                nodeArray2[i] = transactionNode;
                continue;
            }
            catch (FileAlreadyLockedException fileAlreadyLockedException) {
                bl = true;
                continue;
            }
            catch (IOException iOException) {
                bl = true;
                continue;
            }
            catch (Exception exception) {
                bl = true;
                continue;
            }
            finally {
                if (fileLock != null) {
                    fileLock.releaseLock();
                }
            }
        }
        if (!bl) {
            this.currTrans.remove(nodeArray);
        }
        this.savedTrans.add(nodeArray2);
    }

    void deleteTransaction(final Node[] nodeArray) {
        if (!this.haveDirectories()) {
            Controller.log("Couldn't get the directory");
            return;
        }
        if (nodeArray == null || nodeArray.length == 0) {
            return;
        }
        final ProgressMonitor progressMonitor = new ProgressMonitor();
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Thread.yield();
                Controller.this.currTrans.remove(nodeArray);
                Controller.this.savedTrans.remove(nodeArray);
                int n = 0;
                for (int i = 0; i < nodeArray.length; ++i) {
                    int n2;
                    String string;
                    TransactionNode transactionNode = (TransactionNode)nodeArray[i];
                    FileObject fileObject = null;
                    if (transactionNode.isCurrent()) {
                        string = transactionNode.getID();
                        fileObject = currDir.getFileObject(string, "xml");
                        Controller.this.currBeans.remove(string);
                    } else {
                        string = transactionNode.getID();
                        fileObject = saveDir.getFileObject(string, "xml");
                        Controller.this.saveBeans.remove(string);
                    }
                    if (fileObject != null) {
                        string = null;
                        try {
                            string = fileObject.lock();
                            fileObject.delete((FileLock)string);
                        }
                        catch (FileAlreadyLockedException fileAlreadyLockedException) {
                            Logger.getLogger("global").log(Level.INFO, null, fileAlreadyLockedException);
                        }
                        catch (IOException iOException) {
                            Logger.getLogger("global").log(Level.INFO, null, iOException);
                        }
                        finally {
                            if (string != null) {
                                string.releaseLock();
                            }
                        }
                    }
                    if ((n2 = 100 * (i + 1) / nodeArray.length) <= n) continue;
                    n = n2;
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            progressMonitor.setValue(n2);
                        }
                    });
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        progressMonitor.close();
                    }
                });
            }
        });
        progressMonitor.setVisible(true);
    }

    void deleteDirectory(String string) {
        FileObject fileObject;
        if (!this.haveDirectories()) {
            Controller.log("Couldn't get the directory");
            return;
        }
        if (string.equals(saveDirStr)) {
            fileObject = saveDir;
            this.savedTrans.remove(this.savedTrans.getNodes());
            this.saveBeans.clear();
        } else {
            fileObject = currDir;
            this.currTrans.remove(this.currTrans.getNodes());
            this.currBeans.clear();
        }
        if (fileObject.getChildren().length == 0) {
            return;
        }
        final ProgressMonitor progressMonitor = new ProgressMonitor();
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Thread.yield();
                int n = fileObject.getChildren().length;
                int n2 = -1;
                int n3 = 0;
                Enumeration enumeration = fileObject.getData(false);
                while (enumeration.hasMoreElements()) {
                    FileObject fileObject2 = (FileObject)enumeration.nextElement();
                    FileLock fileLock = null;
                    try {
                        fileLock = fileObject2.lock();
                        fileObject2.delete(fileLock);
                    }
                    catch (FileAlreadyLockedException fileAlreadyLockedException) {
                        Logger.getLogger("global").log(Level.INFO, null, fileAlreadyLockedException);
                    }
                    catch (IOException iOException) {
                        Logger.getLogger("global").log(Level.INFO, null, iOException);
                    }
                    finally {
                        if (fileLock != null) {
                            fileLock.releaseLock();
                        }
                    }
                    final int n4 = 100 * n3 / n;
                    if (n4 > n2) {
                        n2 = n4;
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                progressMonitor.setValue(n4);
                            }
                        });
                    }
                    ++n3;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        progressMonitor.close();
                    }
                });
            }
        });
        progressMonitor.setVisible(true);
    }

    void deleteTransactions() {
        this.deleteDirectory(saveDirStr);
        this.deleteDirectory(currDirStr);
        this.savedTrans.remove(this.savedTrans.getNodes());
        this.currTrans.remove(this.currTrans.getNodes());
    }

    void getTransactions() {
        int n;
        if (!this.haveDirectories()) {
            Controller.log("Couldn't get the directory");
            return;
        }
        Enumeration enumeration = null;
        Vector<TransactionNode> vector = new Vector<TransactionNode>();
        int n2 = 0;
        TransactionNode[] transactionNodeArray = null;
        FileObject fileObject = null;
        String string = null;
        MonitorData monitorData = null;
        this.currTrans.remove(this.currTrans.getNodes());
        enumeration = currDir.getData(false);
        final ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        while (enumeration.hasMoreElements()) {
            fileObject = (FileObject)enumeration.nextElement();
            if (fileObject.lastModified().after(this.startDate)) {
                string = fileObject.getName();
                monitorData = this.retrieveMonitorData(string, currDir);
                if (monitorData == null) continue;
                vector.add(this.createTransactionNode(monitorData, true));
                continue;
            }
            arrayList.add(fileObject);
        }
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                Iterator iterator = arrayList.iterator();
                while (iterator.hasNext()) {
                    try {
                        ((FileObject)iterator.next()).delete();
                    }
                    catch (IOException iOException) {
                        Logger.getLogger("global").log(Level.INFO, null, iOException);
                    }
                }
            }
        });
        n2 = vector.size();
        transactionNodeArray = new TransactionNode[n2];
        for (n = 0; n < n2; ++n) {
            transactionNodeArray[n] = (TransactionNode)((Object)vector.elementAt(n));
        }
        this.currTrans.add((Node[])transactionNodeArray);
        this.savedTrans.remove(this.savedTrans.getNodes());
        vector = new Vector();
        enumeration = saveDir.getData(false);
        while (enumeration.hasMoreElements()) {
            fileObject = (FileObject)enumeration.nextElement();
            string = fileObject.getName();
            monitorData = this.retrieveMonitorData(string, saveDir);
            if (monitorData == null) continue;
            vector.add(this.createTransactionNode(monitorData, false));
        }
        n2 = vector.size();
        transactionNodeArray = new TransactionNode[n2];
        for (n = 0; n < n2; ++n) {
            transactionNodeArray[n] = (TransactionNode)((Object)vector.elementAt(n));
        }
        this.savedTrans.add((Node[])transactionNodeArray);
    }

    private int parseStatusCode(String string) {
        if (string == null) {
            return -1;
        }
        int n = 200;
        try {
            int n2 = string.indexOf(58);
            if (n2 != -1) {
                string = string.substring(0, n2);
                n = Integer.valueOf(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    private TransactionNode createTransactionNode(MonitorData monitorData, boolean bl) {
        Dispatches dispatches = null;
        RequestData requestData = monitorData.getRequestData();
        try {
            dispatches = monitorData.getDispatches();
        }
        catch (Exception exception) {
            // empty catch block
        }
        TransactionNode transactionNode = null;
        if (dispatches == null || dispatches.sizeDispatchData() == 0) {
            transactionNode = new TransactionNode(monitorData.getAttributeValue("id"), monitorData.getAttributeValue("method"), monitorData.getAttributeValue("resource"), bl, this.parseStatusCode(requestData == null ? null : requestData.getAttributeValue("status")));
        } else {
            int n = dispatches.sizeDispatchData();
            Children.Array array = new Children.Array();
            NestedNode[] nestedNodeArray = new NestedNode[n];
            for (int i = 0; i < n; ++i) {
                nestedNodeArray[i] = this.createNestedNode(dispatches.getDispatchData(i), monitorData.getAttributeValue("method"), null, i);
            }
            array.add((Node[])nestedNodeArray);
            transactionNode = new TransactionNode(monitorData.getAttributeValue("id"), monitorData.getAttributeValue("method"), monitorData.getAttributeValue("resource"), (Children)array, bl, this.parseStatusCode(requestData == null ? null : requestData.getAttributeValue("status")));
        }
        return transactionNode;
    }

    private NestedNode createNestedNode(DispatchData dispatchData, String string, int[] nArray, int n) {
        int n2;
        Dispatches dispatches = dispatchData.getDispatches();
        NestedNode nestedNode = null;
        int[] nArray2 = null;
        if (nArray != null) {
            nArray2 = new int[nArray.length + 1];
            for (n2 = 0; n2 < nArray.length; ++n2) {
                nArray2[n2] = nArray[n2];
            }
            nArray2[n2] = n;
        } else {
            nArray2 = new int[]{n};
        }
        if (dispatches == null || dispatches.sizeDispatchData() == 0) {
            RequestData requestData = dispatchData.getRequestData();
            nestedNode = new NestedNode(dispatchData.getAttributeValue("resource"), string, nArray2, this.parseStatusCode(requestData == null ? null : requestData.getAttributeValue("status")));
        } else {
            n2 = dispatches.sizeDispatchData();
            Children.Array array = new Children.Array();
            NestedNode[] nestedNodeArray = new NestedNode[n2];
            for (int i = 0; i < n2; ++i) {
                nestedNodeArray[i] = this.createNestedNode(dispatches.getDispatchData(i), string, nArray2, i);
            }
            array.add((Node[])nestedNodeArray);
            nestedNode = new NestedNode(dispatchData.getAttributeValue("resource"), string, (Children)array, nArray2, this.parseStatusCode(dispatchData.getRequestData().getAttributeValue("status")));
        }
        return nestedNode;
    }

    static void setServer(String string, int n) {
        port = n;
        server = string;
    }

    void setComparator(Comparator comparator) {
        this.currTrans.setComparator(comparator);
        this.savedTrans.setComparator(comparator);
    }

    void setUseBrowserCookie(boolean bl) {
        this.useBrowserCookie = bl;
    }

    boolean getUseBrowserCookie() {
        return this.useBrowserCookie;
    }

    DataRecord getDataRecord(AbstractNode abstractNode) {
        return this.getDataRecord(abstractNode, true);
    }

    DataRecord getDataRecord(AbstractNode abstractNode, boolean bl) {
        if (abstractNode instanceof TransactionNode) {
            MonitorData monitorData = this.getMonitorData((TransactionNode)abstractNode, bl, true);
            if (monitorData == null) {
                String string = NbBundle.getMessage((Class)Controller.class, (String)"MSG_NoMonitorData");
                Logger.getLogger("global").log(Level.INFO, string);
                return null;
            }
            return monitorData;
        }
        if (abstractNode instanceof NestedNode) {
            NestedNode nestedNode = (NestedNode)abstractNode;
            int[] nArray = nestedNode.getIndex();
            AbstractNode abstractNode2 = (AbstractNode)nestedNode.getParentNode();
            if (abstractNode2 == null) {
                return null;
            }
            while (abstractNode2 != null && !(abstractNode2 instanceof TransactionNode)) {
                abstractNode2 = (AbstractNode)abstractNode2.getParentNode();
            }
            MonitorData monitorData = this.getMonitorData((TransactionNode)abstractNode2, true, true);
            if (monitorData == null) {
                String string = NbBundle.getMessage((Class)Controller.class, (String)"MSG_NoMonitorData");
                Logger.getLogger("global").log(Level.INFO, string);
                return null;
            }
            BaseBean baseBean = monitorData;
            int[] nArray2 = nestedNode.getIndex();
            for (int i = 0; i < nArray2.length; ++i) {
                Dispatches dispatches = baseBean.getDispatches();
                baseBean = dispatches.getDispatchData(nArray2[i]);
            }
            return baseBean;
        }
        return null;
    }

    MonitorData getMonitorData(TransactionNode transactionNode, boolean bl, boolean bl2) {
        String string = transactionNode.getID();
        Hashtable hashtable = null;
        FileObject fileObject = null;
        if (transactionNode.isCurrent()) {
            hashtable = this.currBeans;
            fileObject = currDir;
        } else {
            hashtable = this.saveBeans;
            fileObject = saveDir;
        }
        if (bl && hashtable.containsKey(string)) {
            return (MonitorData)hashtable.get(string);
        }
        MonitorData monitorData = this.retrieveMonitorData(string, fileObject);
        if (bl2 && monitorData != null) {
            hashtable.put(string, monitorData);
        }
        return monitorData;
    }

    MonitorData retrieveMonitorData(String string, String string2) {
        if (!this.haveDirectories()) {
            Controller.log("Couldn't get the directory");
            return null;
        }
        FileObject fileObject = null;
        if (string2.equalsIgnoreCase(currDirStr)) {
            fileObject = currDir;
        } else if (string2.equalsIgnoreCase(saveDirStr)) {
            fileObject = saveDir;
        } else if (string2.equalsIgnoreCase(replayDirStr)) {
            fileObject = replayDir;
        }
        return this.retrieveMonitorData(string, fileObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MonitorData retrieveMonitorData(String string, FileObject fileObject) {
        if (!this.haveDirectories()) {
            Controller.log("Couldn't get the directory");
            return null;
        }
        MonitorData monitorData = null;
        FileObject fileObject2 = null;
        FileLock fileLock = null;
        InputStreamReader inputStreamReader = null;
        try {
            fileObject2 = fileObject.getFileObject(string, "xml");
            fileLock = fileObject2.lock();
            inputStreamReader = new InputStreamReader(fileObject2.getInputStream());
            monitorData = MonitorData.createGraph(inputStreamReader);
            try {
                if (fileObject == replayDir) {
                    fileObject2.delete(fileLock);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        catch (FileAlreadyLockedException fileAlreadyLockedException) {
            Logger.getLogger("global").log(Level.INFO, null, fileAlreadyLockedException);
        }
        catch (IOException iOException) {
            Logger.getLogger("global").log(Level.INFO, null, iOException);
        }
        catch (Exception exception) {
            Logger.getLogger("global").log(Level.INFO, null, exception);
        }
        finally {
            try {
                inputStreamReader.close();
            }
            catch (Throwable throwable) {}
            if (fileLock != null) {
                fileLock.releaseLock();
            }
        }
        return monitorData;
    }

    private void showReplay(final URL uRL) throws UnknownHostException, IOException {
        ServerCheck serverCheck = new ServerCheck(uRL.getHost());
        Thread thread = new Thread(serverCheck);
        thread.start();
        try {
            thread.join(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        thread = null;
        if (!serverCheck.isServerGood()) {
            throw new UnknownHostException();
        }
        try {
            Socket socket = new Socket(uRL.getHost(), uRL.getPort());
            socket.close();
            socket = null;
        }
        catch (UnknownHostException unknownHostException) {
            throw unknownHostException;
        }
        catch (IOException iOException) {
            throw iOException;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                HtmlBrowser.URLDisplayer.getDefault().showURL(uRL);
            }
        });
    }

    private static void log(String string) {
        System.out.println("Controller::" + string);
    }

    private static URL getSampleHTTPServerURL() {
        FileObject fileObject = FileUtil.getConfigFile((String)"HTTPServer_DUMMY");
        if (fileObject == null) {
            return null;
        }
        URL uRL = URLMapper.findURL((FileObject)fileObject, (int)2);
        return uRL;
    }

    boolean checkServer(boolean bl) {
        try {
            URL uRL = Controller.getSampleHTTPServerURL();
            if (uRL.getProtocol().equals("http")) {
                return true;
            }
        }
        catch (Throwable throwable) {
            Object[] objectArray = new Object[]{NbBundle.getBundle((Class)Controller.class).getString("MON_OK")};
            String string = null;
            string = bl ? NbBundle.getBundle((Class)Controller.class).getString("MON_CantReplay") : NbBundle.getBundle((Class)Controller.class).getString("MON_NoServer");
            NotifyDescriptor notifyDescriptor = new NotifyDescriptor((Object)string, NbBundle.getBundle((Class)Controller.class).getString("MON_NoServerTitle"), -1, 1, objectArray, objectArray[0]);
            DialogDisplayer.getDefault().notify(notifyDescriptor);
        }
        return false;
    }

    void updateNodeNames() {
        TransactionNode transactionNode;
        int n;
        Node[] nodeArray = this.currTrans.getNodes();
        int n2 = nodeArray.length;
        for (n = 0; n < n2; ++n) {
            transactionNode = (TransactionNode)nodeArray[n];
            transactionNode.setNameString();
        }
        nodeArray = this.savedTrans.getNodes();
        n2 = nodeArray.length;
        for (n = 0; n < n2; ++n) {
            transactionNode = (TransactionNode)nodeArray[n];
            transactionNode.setNameString();
        }
    }

    class CompAlpha
    implements Comparator {
        CompAlpha() {
        }

        public int compare(Object object, Object object2) {
            TransactionNode transactionNode = (TransactionNode)((Object)object);
            TransactionNode transactionNode2 = (TransactionNode)((Object)object2);
            int n = transactionNode.getName().compareTo(transactionNode2.getName());
            if (n == 0) {
                return transactionNode.getID().compareTo(transactionNode2.getID());
            }
            return n;
        }
    }

    class CompTime
    implements Comparator {
        boolean descend = true;

        CompTime(boolean bl) {
            this.descend = bl;
        }

        public int compare(Object object, Object object2) {
            TransactionNode transactionNode = (TransactionNode)((Object)object);
            TransactionNode transactionNode2 = (TransactionNode)((Object)object2);
            int n = this.descend ? transactionNode.getID().compareTo(transactionNode2.getID()) : transactionNode2.getID().compareTo(transactionNode.getID());
            return n;
        }
    }

    class ServerCheck
    implements Runnable {
        boolean serverGood = false;
        String serverName = null;

        ServerCheck(String string) {
            this.serverName = string;
        }

        public void run() {
            try {
                InetAddress.getByName(this.serverName);
                this.serverGood = true;
            }
            catch (UnknownHostException unknownHostException) {
                this.serverGood = false;
            }
        }

        boolean isServerGood() {
            return this.serverGood;
        }
    }
}

