/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby;

import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.jrubyparser.ast.Colon2Node;
import org.jrubyparser.ast.IScopingNode;
import org.jrubyparser.ast.MethodDefNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.jrubyparser.ast.ReturnNode;
import org.netbeans.modules.ruby.AstPath;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.ContextKnowledge;
import org.netbeans.modules.ruby.RDocAnalyzer;
import org.netbeans.modules.ruby.RubyIndex;
import org.netbeans.modules.ruby.RubyMethodTypeInferencer;
import org.netbeans.modules.ruby.RubyPredefinedVariable;
import org.netbeans.modules.ruby.RubyType;
import org.netbeans.modules.ruby.RubyTypeAnalyzer;
import org.netbeans.modules.ruby.elements.IndexedMethod;
import org.netbeans.modules.ruby.options.TypeInferenceSettings;

public final class RubyTypeInferencer {
    private final ContextKnowledge knowledge;
    private RubyTypeAnalyzer analyzer;
    private final boolean fast;

    public static RubyTypeInferencer create(ContextKnowledge contextKnowledge) {
        return new RubyTypeInferencer(contextKnowledge, true);
    }

    public static RubyTypeInferencer create(ContextKnowledge contextKnowledge, boolean bl) {
        return new RubyTypeInferencer(contextKnowledge, bl);
    }

    private RubyTypeInferencer(ContextKnowledge contextKnowledge, boolean bl) {
        this.knowledge = contextKnowledge;
        this.fast = bl;
    }

    private void initializeAnalyzer() {
        if (this.analyzer == null) {
            assert (this.knowledge != null) : "need ContextKnowledge for RubyTypeAnalyzer";
            this.analyzer = new RubyTypeAnalyzer(this.knowledge);
        }
    }

    public RubyType inferType(String string) {
        Object object;
        this.initializeAnalyzer();
        this.analyzer.analyze();
        RubyType rubyType = this.knowledge.getType(string);
        if (rubyType == null || !rubyType.isKnown()) {
            rubyType = this.knowledge.getType(RubyTypeInferencer.getLocalVarPath(new AstPath(this.knowledge.getRoot(), this.knowledge.getTarget()), string));
        }
        if (rubyType == null) {
            rubyType = RubyType.createUnknown();
        }
        if (!rubyType.isKnown() && "t".equals(string) && this.knowledge.getRoot().getNodeType() == NodeType.DEFSNODE && ("up".equals(object = AstUtilities.getName(this.knowledge.getRoot())) || "down".equals(object))) {
            return RubyType.create("ActiveRecord::ConnectionAdapters::TableDefinition");
        }
        if (rubyType.isKnown()) {
            for (String string2 : rubyType.getRealTypes()) {
                if (!string2.startsWith("Array<")) continue;
                return RubyType.ARRAY;
            }
        }
        return rubyType;
    }

    static String getLocalVarPath(AstPath astPath, String string) {
        MethodDefNode methodDefNode = AstUtilities.findMethod(astPath);
        String string2 = "";
        if (methodDefNode != null) {
            string2 = AstUtilities.getName((Node)methodDefNode) + "/";
        }
        return string2 + string;
    }

    RubyType inferTypesOfRHS(Node node) {
        List list = node.childNodes();
        if (list.size() != 1) {
            return RubyType.createUnknown();
        }
        return this.inferType((Node)list.get(0));
    }

    RubyType inferType(Node node) {
        RubyType rubyType = this.knowledge.getType(node);
        if (rubyType != null) {
            return rubyType;
        }
        if (!this.knowledge.wasAnalyzed()) {
            new RubyTypeAnalyzer(this.knowledge).analyze();
        }
        switch (node.getNodeType()) {
            case LOCALVARNODE: {
                rubyType = this.knowledge.getType(RubyTypeInferencer.getLocalVarPath(new AstPath(this.knowledge.getRoot(), node), AstUtilities.getName(node)));
                break;
            }
            case GLOBALVARNODE: {
                RubyType rubyType2;
                String string = AstUtilities.getName(node);
                rubyType = this.knowledge.getType(string);
                if (rubyType.isKnown() || (rubyType2 = RubyPredefinedVariable.getType(string)) == null) break;
                rubyType = rubyType2;
                break;
            }
            case DVARNODE: 
            case INSTVARNODE: 
            case CLASSVARNODE: {
                rubyType = this.knowledge.getType(AstUtilities.getName(node));
                break;
            }
            case CONSTNODE: {
                String string = AstUtilities.getFqnName(this.knowledge.getRoot(), node);
                rubyType = this.knowledge.getType(string);
                break;
            }
            case COLON2NODE: {
                rubyType = this.knowledge.getType(AstUtilities.getFqn((Colon2Node)node));
                break;
            }
            case RETURNNODE: {
                ReturnNode returnNode = (ReturnNode)node;
                rubyType = this.inferType(returnNode.getValueNode());
                break;
            }
            case DEFNNODE: 
            case DEFSNODE: {
                MethodDefNode methodDefNode = (MethodDefNode)node;
                rubyType = this.inferMethodNode(methodDefNode);
                break;
            }
            case SELFNODE: {
                rubyType = this.inferSelf(node);
                break;
            }
            case SUPERNODE: 
            case ZSUPERNODE: {
                rubyType = this.inferSuperNode(node);
            }
        }
        if (rubyType == null && AstUtilities.isCall(node)) {
            rubyType = RubyMethodTypeInferencer.inferTypeFor(node, this.knowledge, this.fast);
        }
        if (rubyType == null) {
            rubyType = RubyTypeInferencer.getTypeForLiteral(node);
        }
        this.knowledge.setType(node, rubyType);
        return rubyType;
    }

    private RubyType inferSuperNode(Node node) {
        RubyIndex rubyIndex;
        RubyType rubyType = this.inferSelf(node);
        if (rubyType == null || !rubyType.isKnown()) {
            return RubyType.createUnknown();
        }
        MethodDefNode methodDefNode = AstUtilities.findMethod(new AstPath(this.knowledge.getRoot(), node));
        if (methodDefNode != null && TypeInferenceSettings.getDefault().getMethodTypeInference() && (rubyIndex = this.knowledge.getIndex()) != null) {
            RubyType rubyType2 = new RubyType();
            for (String string : rubyType.getRealTypes()) {
                IndexedMethod indexedMethod = rubyIndex.getSuperMethod(string, methodDefNode.getName(), true);
                if (indexedMethod == null) continue;
                rubyType2.append(indexedMethod.getType());
            }
            return rubyType2;
        }
        return RubyType.createUnknown();
    }

    private RubyType inferSelf(Node node) {
        Node node2 = this.knowledge.getRoot();
        AstPath astPath = new AstPath(node2, node);
        IScopingNode iScopingNode = AstUtilities.findClassOrModule(astPath);
        if (iScopingNode == null) {
            return null;
        }
        return RubyType.create(AstUtilities.getClassOrModuleName(iScopingNode));
    }

    private RubyType inferMethodNode(MethodDefNode methodDefNode) {
        Object object;
        Object object2;
        String string = methodDefNode.getName();
        RubyType rubyType = RubyMethodTypeInferencer.fastCheckType(string);
        if (rubyType == null && RubyMethodTypeInferencer.returnsReceiver(string)) {
            rubyType = this.inferSelf((Node)methodDefNode);
        }
        if (rubyType != null) {
            return rubyType;
        }
        if (TypeInferenceSettings.getDefault().getRdocTypeInference() && (object2 = AstUtilities.gatherDocumentation(this.knowledge.getParserResult().getSnapshot(), (Node)methodDefNode)) != null && (object = RDocAnalyzer.collectTypesFromComment((List<? extends String>)object2)) != null && ((RubyType)object).isKnown()) {
            return object;
        }
        object2 = new RubyType();
        object = new LinkedHashSet();
        AstUtilities.findExitPoints(methodDefNode, object);
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            Node node = (Node)iterator.next();
            ((RubyType)object2).append(this.inferType(node));
        }
        return object2;
    }

    static RubyType getTypeForLiteral(Node node) {
        switch (node.getNodeType()) {
            case ARRAYNODE: 
            case ZARRAYNODE: {
                return RubyType.ARRAY;
            }
            case DEFINEDNODE: 
            case STRNODE: 
            case DSTRNODE: 
            case XSTRNODE: 
            case DXSTRNODE: {
                return RubyType.STRING;
            }
            case FIXNUMNODE: {
                return RubyType.FIXNUM;
            }
            case BIGNUMNODE: {
                return RubyType.BIGNUM;
            }
            case HASHNODE: {
                return RubyType.HASH;
            }
            case REGEXPNODE: 
            case DREGEXPNODE: {
                return RubyType.REGEXP;
            }
            case SYMBOLNODE: 
            case DSYMBOLNODE: {
                return RubyType.SYMBOL;
            }
            case FLOATNODE: {
                return RubyType.FLOAT;
            }
            case NILNODE: {
                if (node.isInvisible()) break;
                return RubyType.NIL_CLASS;
            }
            case SCLASSNODE: 
            case UNDEFNODE: 
            case UNTILNODE: {
                return RubyType.NIL_CLASS;
            }
            case NOTNODE: {
                return RubyType.BOOLEAN;
            }
            case TRUENODE: {
                return RubyType.TRUE_CLASS;
            }
            case FALSENODE: {
                return RubyType.FALSE_CLASS;
            }
            case DOTNODE: {
                return RubyType.RANGE;
            }
            case BACKREFNODE: 
            case NTHREFNODE: {
                return new RubyType(RubyType.STRING, RubyType.NIL_CLASS);
            }
        }
        return RubyType.createUnknown();
    }

    public String toString() {
        return "RubyTypeAnalyzer[knowledge:" + this.knowledge + ']';
    }
}

