/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject.ui;

import java.util.ArrayList;
import java.util.List;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.ruby.rubyproject.RubyBaseProject;
import org.netbeans.modules.ruby.rubyproject.UpdateHelper;
import org.netbeans.modules.ruby.rubyproject.ui.TreeRootNode;
import org.netbeans.modules.ruby.spi.project.support.rake.PropertyEvaluator;
import org.netbeans.modules.ruby.spi.project.support.rake.ReferenceHelper;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;

public abstract class RubyBaseLogicalViewProvider
implements LogicalViewProvider {
    private final RubyBaseProject project;
    private final UpdateHelper helper;
    private final PropertyEvaluator evaluator;
    private final ReferenceHelper resolver;
    private List<ChangeListener> changeListeners;

    protected RubyBaseLogicalViewProvider(RubyBaseProject rubyBaseProject, UpdateHelper updateHelper, PropertyEvaluator propertyEvaluator, ReferenceHelper referenceHelper) {
        this.project = rubyBaseProject;
        assert (rubyBaseProject != null);
        this.helper = updateHelper;
        assert (updateHelper != null);
        this.evaluator = propertyEvaluator;
        assert (propertyEvaluator != null);
        this.resolver = referenceHelper;
    }

    public final RubyBaseProject getProject() {
        return this.project;
    }

    public final PropertyEvaluator getEvaluator() {
        return this.evaluator;
    }

    public final ReferenceHelper getRefHelper() {
        return this.resolver;
    }

    public final UpdateHelper getUpdateHelper() {
        return this.helper;
    }

    protected abstract Node findWithPathFinder(Node var1, FileObject var2);

    public synchronized void addChangeListener(ChangeListener changeListener) {
        if (this.changeListeners == null) {
            this.changeListeners = new ArrayList<ChangeListener>();
        }
        this.changeListeners.add(changeListener);
    }

    public synchronized void removeChangeListener(ChangeListener changeListener) {
        if (this.changeListeners == null) {
            return;
        }
        this.changeListeners.remove(changeListener);
    }

    protected Node findWithPathFinder1(Node node, FileObject fileObject) {
        Node node2;
        TreeRootNode.PathFinder pathFinder = (TreeRootNode.PathFinder)node.getLookup().lookup(TreeRootNode.PathFinder.class);
        if (pathFinder != null && (node2 = pathFinder.findPath(node, fileObject)) != null) {
            return node2;
        }
        return null;
    }

    public final Node findPath(Node node, Object object) {
        Project project = (Project)node.getLookup().lookup(Project.class);
        if (project == null) {
            return null;
        }
        if (object instanceof FileObject) {
            FileObject fileObject = (FileObject)object;
            Project project2 = FileOwnerQuery.getOwner((FileObject)fileObject);
            if (!project.equals(project2)) {
                return null;
            }
            Node[] nodeArray = node.getChildren().getNodes(true);
            for (int i = 0; i < nodeArray.length; ++i) {
                FileObject fileObject2;
                Node node2 = this.findWithPathFinder(nodeArray[i], fileObject);
                if (node2 != null) {
                    return node2;
                }
                DataObject dataObject = (DataObject)nodeArray[i].getLookup().lookup(DataObject.class);
                if (dataObject == null || !fileObject.equals(fileObject2 = dataObject.getPrimaryFile())) continue;
                return nodeArray[i];
            }
        }
        return null;
    }
}

