/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.core.stack.dataprovider.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.netbeans.modules.dlight.api.datafilter.DataFilter;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.core.stack.api.FunctionCall;
import org.netbeans.modules.dlight.core.stack.api.FunctionCallWithMetric;
import org.netbeans.modules.dlight.core.stack.api.FunctionMetric;
import org.netbeans.modules.dlight.core.stack.api.ThreadDumpProvider;
import org.netbeans.modules.dlight.core.stack.dataprovider.FunctionCallTreeTableNode;
import org.netbeans.modules.dlight.core.stack.dataprovider.StackDataProvider;
import org.netbeans.modules.dlight.core.stack.storage.StackDataStorage;
import org.netbeans.modules.dlight.spi.SourceFileInfoProvider;
import org.netbeans.modules.dlight.spi.storage.DataStorage;
import org.netbeans.modules.dlight.spi.storage.ServiceInfoDataStorage;
import org.openide.util.Lookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class StackDataProviderImpl
implements StackDataProvider {
    private final List<FunctionMetric> metricsList = Arrays.asList(FunctionMetric.CpuTimeInclusiveMetric, FunctionMetric.CpuTimeExclusiveMetric);
    private StackDataStorage storage;
    private ServiceInfoDataStorage serviceInfoDataStorage;
    private final Lock lock = new Lock();
    private final List<DataFilter> filters = new ArrayList<DataFilter>();

    StackDataProviderImpl() {
    }

    public void attachTo(DataStorage dataStorage) {
        this.storage = (StackDataStorage)dataStorage;
    }

    public void attachTo(ServiceInfoDataStorage serviceInfoDataStorage) {
        this.serviceInfoDataStorage = serviceInfoDataStorage;
    }

    @Override
    public List<FunctionMetric> getMetricsList() {
        return this.metricsList;
    }

    @Override
    public List<FunctionCallWithMetric> getCallers(List<FunctionCallWithMetric> list, List<DataTableMetadata.Column> list2, List<DataTableMetadata.Column> list3, boolean bl) {
        return this.storage.getCallers(list, list2, list3, bl);
    }

    @Override
    public List<FunctionCallWithMetric> getCallees(List<FunctionCallWithMetric> list, List<DataTableMetadata.Column> list2, List<DataTableMetadata.Column> list3, boolean bl) {
        return this.storage.getCallees(list, list2, list3, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FunctionCallWithMetric> getHotSpotFunctions(List<DataTableMetadata.Column> list, List<DataTableMetadata.Column> list2, int n) {
        ArrayList<DataFilter> arrayList = null;
        Lock lock = this.lock;
        synchronized (lock) {
            arrayList = new ArrayList<DataFilter>(this.filters);
        }
        return this.storage.getHotSpotFunctions(FunctionMetric.CpuTimeInclusiveMetric, arrayList, n);
    }

    @Override
    public List<FunctionCall> getCallStack(int n) {
        return this.storage.getCallStack(n);
    }

    public List<FunctionCallTreeTableNode> getTableView(List<DataTableMetadata.Column> list, List<DataTableMetadata.Column> list2, int n) {
        return FunctionCallTreeTableNode.getFunctionCallTreeTableNodes(this.getHotSpotFunctions(null, null, n));
    }

    public List<FunctionCallTreeTableNode> getChildren(List<FunctionCallTreeTableNode> list, List<DataTableMetadata.Column> list2, List<DataTableMetadata.Column> list3) {
        List<FunctionCallWithMetric> list4 = FunctionCallTreeTableNode.getFunctionCalls(list);
        List<FunctionCallWithMetric> list5 = this.getCallees(list4, list2, list3, false);
        return FunctionCallTreeTableNode.getFunctionCallTreeTableNodes(list5);
    }

    public FunctionCallTreeTableNode getValueAt(int n) {
        return null;
    }

    public String getTableValueAt(DataTableMetadata.Column column, int n) {
        return null;
    }

    @Override
    public SourceFileInfoProvider.SourceFileInfo getSourceFileInfo(FunctionCall functionCall) {
        Collection collection = Lookup.getDefault().lookupAll(SourceFileInfoProvider.class);
        for (SourceFileInfoProvider sourceFileInfoProvider : collection) {
            SourceFileInfoProvider.SourceFileInfo sourceFileInfo = sourceFileInfoProvider.getSourceFileInfo(functionCall.getFunction().getQuilifiedName(), -1, functionCall.getOffset(), this.serviceInfoDataStorage.getInfo());
            if (sourceFileInfo == null || !sourceFileInfo.isSourceKnown()) continue;
            return sourceFileInfo;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dataFiltersChanged(List<DataFilter> list, boolean bl) {
        if (bl) {
            return;
        }
        Lock lock = this.lock;
        synchronized (lock) {
            this.filters.clear();
            this.filters.addAll(list);
        }
    }

    @Override
    public ThreadDumpProvider getThreadDumpProvider() {
        if (this.storage instanceof ThreadDumpProvider) {
            return (ThreadDumpProvider)((Object)this.storage);
        }
        return null;
    }

    private static final class Lock {
        private Lock() {
        }
    }
}

