/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.webmodule;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.web.api.webmodule.ExtenderController;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.spi.webmodule.FrameworkConfigurationPanel;
import org.netbeans.modules.web.spi.webmodule.WebFrameworkProvider;
import org.netbeans.modules.web.spi.webmodule.WebModuleExtender;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.HelpCtx;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebModuleExtenderBridge
extends WebModuleExtender {
    private final WebFrameworkProvider framework;
    private final WebModule webModule;
    private final ExtenderController controller;
    private final FrameworkConfigurationPanel configPanel;
    private final WizardDescriptor wizard;
    private Map<String, Object> oldProps;

    public static WebModuleExtenderBridge create(WebFrameworkProvider webFrameworkProvider, WebModule webModule, ExtenderController extenderController) {
        WebModuleExtenderBridge webModuleExtenderBridge = new WebModuleExtenderBridge(webFrameworkProvider, webModule, extenderController);
        webModuleExtenderBridge.initialize();
        return webModuleExtenderBridge;
    }

    private WebModuleExtenderBridge(WebFrameworkProvider webFrameworkProvider, WebModule webModule, ExtenderController extenderController) {
        WizardDescriptor wizardDescriptor;
        this.framework = webFrameworkProvider;
        this.webModule = webModule;
        this.controller = extenderController;
        FrameworkConfigurationPanel frameworkConfigurationPanel = webFrameworkProvider.getConfigurationPanel(webModule);
        this.configPanel = frameworkConfigurationPanel != null ? frameworkConfigurationPanel : new EmptyConfigPanel();
        this.wizard = wizardDescriptor = new WizardDescriptor(new WizardDescriptor.Panel[]{new EmptyPanel()});
    }

    private void initialize() {
        this.wizard.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = (String)WebModuleExtenderBridge.this.wizard.getProperty("WizardPanel_errorMessage");
                if (string != null && string.trim().length() == 0) {
                    string = null;
                }
                WebModuleExtenderBridge.this.controller.setErrorMessage(string);
            }
        });
    }

    @Override
    public void addChangeListener(ChangeListener changeListener) {
        this.configPanel.addChangeListener(changeListener);
    }

    @Override
    public Set<FileObject> extend(WebModule webModule) {
        this.configPanel.storeSettings(this.wizard);
        return this.framework.extend(webModule);
    }

    @Override
    public JComponent getComponent() {
        return (JComponent)this.configPanel.getComponent();
    }

    @Override
    public HelpCtx getHelp() {
        return this.configPanel.getHelp();
    }

    @Override
    public boolean isValid() {
        return this.configPanel.isValid();
    }

    @Override
    public void removeChangeListener(ChangeListener changeListener) {
        this.configPanel.removeChangeListener(changeListener);
    }

    @Override
    public void update() {
        if (this.oldProps != null) {
            for (Map.Entry object : this.oldProps.entrySet()) {
                this.wizard.putProperty((String)object.getKey(), null);
            }
        }
        Map<String, Object> map = this.controller.getProperties().getProperties();
        for (Map.Entry entry : map.entrySet()) {
            this.wizard.putProperty((String)entry.getKey(), entry.getValue());
        }
        this.oldProps = map;
        this.configPanel.readSettings(this.wizard);
    }

    private static final class EmptyConfigPanel
    extends EmptyPanel
    implements FrameworkConfigurationPanel {
        private EmptyConfigPanel() {
        }

        public Component getComponent() {
            return null;
        }

        public void enableComponents(boolean bl) {
        }
    }

    private static class EmptyPanel
    implements WizardDescriptor.Panel {
        private JPanel component;

        private EmptyPanel() {
        }

        public void addChangeListener(ChangeListener changeListener) {
        }

        public Component getComponent() {
            if (this.component == null) {
                this.component = new JPanel();
            }
            return this.component;
        }

        public HelpCtx getHelp() {
            return null;
        }

        public boolean isValid() {
            return true;
        }

        public void readSettings(Object object) {
        }

        public void removeChangeListener(ChangeListener changeListener) {
        }

        public void storeSettings(Object object) {
        }
    }
}

