/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.end2end.ui.treeview;

import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;
import org.netbeans.modules.mobility.end2end.ui.treeview.MethodCheckedNodeRenderer;
import org.netbeans.modules.mobility.end2end.ui.treeview.MethodCheckedTreeBeanView;
import org.openide.explorer.view.Visualizer;
import org.openide.nodes.Node;

public class MethodCheckedNodeEditor
extends AbstractCellEditor
implements TreeCellEditor,
ItemListener {
    static final long serialVersionUID = -5087358518052291490L;
    private final MethodCheckedNodeRenderer customRenderer;
    private final JTree jtree;
    private final int checkWidth;
    private MethodCheckedTreeBeanView storage;
    private Node node = null;

    public MethodCheckedNodeEditor(JTree jTree) {
        this.jtree = jTree;
        this.customRenderer = new MethodCheckedNodeRenderer();
        this.checkWidth = this.customRenderer.getCheckBoxWidth();
        this.customRenderer.addItemListener(this);
    }

    public void setContentStorage(MethodCheckedTreeBeanView methodCheckedTreeBeanView) {
        this.storage = methodCheckedTreeBeanView;
    }

    public Object getCellEditorValue() {
        return this.customRenderer;
    }

    public boolean isCellEditable(EventObject eventObject) {
        if (eventObject instanceof MouseEvent) {
            Object object;
            Node node;
            if (!this.canEditImmediately(eventObject)) {
                return false;
            }
            MouseEvent mouseEvent = (MouseEvent)eventObject;
            TreePath treePath = this.jtree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath != null && (node = Visualizer.findNode((Object)(object = treePath.getLastPathComponent()))) != null) {
                return true;
            }
        }
        return false;
    }

    protected boolean canEditImmediately(EventObject eventObject) {
        if (eventObject instanceof MouseEvent && SwingUtilities.isLeftMouseButton((MouseEvent)eventObject)) {
            MouseEvent mouseEvent = (MouseEvent)eventObject;
            return this.inHitRegion(mouseEvent.getX(), mouseEvent.getY());
        }
        return false;
    }

    protected boolean inHitRegion(int n, int n2) {
        Rectangle rectangle;
        int n3 = this.jtree.getRowForLocation(n, n2);
        return n3 != -1 && this.jtree != null && (rectangle = this.jtree.getRowBounds(n3)) != null && n - rectangle.x < 12 && n - rectangle.x >= 0;
    }

    public synchronized Component getTreeCellEditorComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n) {
        this.node = Visualizer.findNode((Object)object);
        return this.customRenderer.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, true);
    }

    public synchronized void itemStateChanged(ItemEvent itemEvent) {
        if (this.stopCellEditing() && this.node != null) {
            this.node.setValue("isSelected", (Object)this.customRenderer.getState());
            this.storage.updateTreeNodeStates(this.node);
        }
    }
}

