/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.editor.completion;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.prefs.Preferences;
import org.netbeans.modules.editor.settings.storage.api.EditorSettings;
import org.netbeans.modules.options.editor.completion.CodeCompletionOptionsPanelController;
import org.netbeans.modules.options.editor.completion.GeneralCompletionOptionsPanelController;
import org.netbeans.modules.options.editor.spi.PreferencesCustomizer;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CodeCompletionOptionsSelector {
    public static final String CODE_COMPLETION_CUSTOMIZERS_FOLDER = "OptionsDialog/Editor/CodeCompletion/";
    private final Map<String, PreferencesCustomizer> allCustomizers = new HashMap<String, PreferencesCustomizer>();
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private final CodeCompletionOptionsPanelController.PreferencesFactory pf;
    private Set<String> mimeTypes;
    private String selectedMimeType;

    CodeCompletionOptionsSelector(CodeCompletionOptionsPanelController.PreferencesFactory preferencesFactory) {
        this.pf = preferencesFactory;
    }

    public synchronized Set<? extends String> getMimeTypes() {
        if (this.mimeTypes == null) {
            this.mimeTypes = new HashSet<String>();
            this.mimeTypes.add("");
            for (String string : EditorSettings.getDefault().getAllMimeTypes()) {
                Lookup lookup = Lookups.forPath((String)(CODE_COMPLETION_CUSTOMIZERS_FOLDER + string));
                if (lookup.lookup(PreferencesCustomizer.Factory.class) == null) continue;
                this.mimeTypes.add(string);
            }
        }
        return this.mimeTypes;
    }

    public synchronized void setSelectedMimeType(String string) {
        assert (this.getMimeTypes().contains(string)) : "'" + string + "' is not among " + this.getMimeTypes();
        if (this.selectedMimeType == null || !this.selectedMimeType.equals(string)) {
            String string2 = this.selectedMimeType;
            this.selectedMimeType = string;
            this.pcs.firePropertyChange(null, string2, string);
        }
    }

    public synchronized PreferencesCustomizer getSelectedCustomizer() {
        return this.getCustomizer(this.selectedMimeType);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    private PreferencesCustomizer getCustomizer(String string) {
        PreferencesCustomizer preferencesCustomizer = this.allCustomizers.get(string);
        if (preferencesCustomizer == null) {
            Preferences preferences = this.pf.getPreferences(string);
            if (string.length() > 0) {
                Lookup lookup = Lookups.forPath((String)(CODE_COMPLETION_CUSTOMIZERS_FOLDER + string));
                PreferencesCustomizer.Factory factory = (PreferencesCustomizer.Factory)lookup.lookup(PreferencesCustomizer.Factory.class);
                if (factory != null) {
                    preferencesCustomizer = factory.create(preferences);
                }
            } else {
                preferencesCustomizer = new GeneralCompletionOptionsPanelController(preferences);
            }
            this.allCustomizers.put(this.selectedMimeType, preferencesCustomizer);
        }
        return preferencesCustomizer;
    }
}

