/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.model.presenters.actions;

import java.util.List;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.Presenter;
import org.netbeans.modules.vmd.api.model.PropertyDescriptor;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.api.model.presenters.actions.DeletableState;

public abstract class DeletePresenter
extends Presenter {
    DeletableState canDelete() {
        return DeletableState.ALLOWED;
    }

    boolean isSilent() {
        return false;
    }

    protected abstract void delete();

    public static Presenter createSilentDeletionPresenter() {
        return new DeletePresenter(){

            boolean isSilent() {
                return true;
            }

            protected void delete() {
            }
        };
    }

    public static Presenter createIndeliblePresenter() {
        return new DeletePresenter(){

            DeletableState canDelete() {
                return DeletableState.DISALLOWED;
            }

            protected void delete() {
                throw Debug.illegalState(new Object[0]);
            }
        };
    }

    public static Presenter createUserIndeliblePresenter() {
        return new DeletePresenter(){

            DeletableState canDelete() {
                return DeletableState.DISALLOWED_FOR_USER_ONLY;
            }

            protected void delete() {
            }
        };
    }

    public static Presenter createRemoveComponentReferences() {
        return new DeletePresenter(){

            DeletableState canDelete() {
                return DeletableState.ALLOWED;
            }

            protected void delete() {
                DesignComponent designComponent = this.getComponent().getDocument().getRootComponent();
                this.search(designComponent);
            }

            private void search(DesignComponent designComponent) {
                for (DesignComponent designComponent2 : designComponent.getComponents()) {
                    if (designComponent2.getComponents() != null) {
                        this.search(designComponent2);
                    }
                    this.removeReferences(designComponent2);
                }
            }

            private void removeReferences(DesignComponent designComponent) {
                List<PropertyDescriptor> list = designComponent.getComponentDescriptor().getDeclaredPropertyDescriptors();
                if (list == null) {
                    return;
                }
                for (PropertyDescriptor propertyDescriptor : list) {
                    PropertyValue propertyValue = designComponent.readProperty(propertyDescriptor.getName());
                    if (propertyValue.getComponent() == null || propertyValue.getComponent() != this.getComponent()) continue;
                    designComponent.writeProperty(propertyDescriptor.getName(), PropertyValue.createNull());
                }
            }
        };
    }
}

