/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties.syntax;

import java.awt.Color;
import java.awt.Font;
import java.awt.SystemColor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.EventListener;
import java.util.HashSet;
import javax.swing.KeyStroke;
import javax.swing.text.AttributeSet;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.api.editor.settings.KeyBindingSettings;
import org.netbeans.api.editor.settings.MultiKeyBinding;
import org.netbeans.editor.Coloring;
import org.netbeans.modules.properties.TableViewSettings;
import org.netbeans.modules.properties.syntax.PropertiesTokenContext;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.WeakListeners;

public class EditorSettingsCopy
extends TableViewSettings {
    private static EditorSettingsCopy editorSettingsCopy;
    private Font font;
    private Color keyColor;
    private Color keyBackground;
    private Color valueColor;
    private Color valueBackground;
    private Color highlightColor;
    private Color highlightBackground;
    private Color shadowColor;
    private KeyStroke[] keyStrokesFindNext;
    private KeyStroke[] keyStrokesFindPrevious;
    private KeyStroke[] keyStrokesToggleHighlight;
    private final PropertyChangeSupport support = new PropertyChangeSupport((Object)this);
    private boolean prepared = false;
    private Lookup.Result<FontColorSettings> fontsColors = null;
    private final LookupListener fontsColorsTracker = new LookupListener(){

        public void resultChanged(LookupEvent lookupEvent) {
            EditorSettingsCopy.this.updateColors();
        }
    };
    private Lookup.Result<KeyBindingSettings> keybindings = null;
    private final LookupListener keybindingsTracker = new LookupListener(){

        public void resultChanged(LookupEvent lookupEvent) {
            EditorSettingsCopy.this.updateKeyStrokes();
        }
    };

    private EditorSettingsCopy() {
    }

    public Color getKeyColor() {
        this.prepareSettings();
        if (this.keyColor == null) {
            this.keyColor = TableViewSettings.KEY_DEFAULT_COLOR;
        }
        return this.keyColor;
    }

    public Color getKeyBackground() {
        this.prepareSettings();
        if (this.keyBackground == null) {
            this.keyBackground = TableViewSettings.KEY_DEFAULT_BACKGROUND;
        }
        return this.keyBackground;
    }

    public Color getValueColor() {
        this.prepareSettings();
        if (this.valueColor == null) {
            this.valueColor = TableViewSettings.VALUE_DEFAULT_COLOR;
        }
        return this.valueColor;
    }

    public Color getValueBackground() {
        this.prepareSettings();
        if (this.valueBackground == null) {
            this.valueBackground = TableViewSettings.VALUE_DEFAULT_BACKGROUND;
        }
        return this.valueBackground;
    }

    public Color getHighlightColor() {
        this.prepareSettings();
        if (this.highlightColor == null) {
            this.highlightColor = TableViewSettings.HIGHLIGHT_DEFAULT_COLOR;
        }
        return this.highlightColor;
    }

    public Color getHighlightBackground() {
        this.prepareSettings();
        if (this.highlightBackground == null) {
            this.highlightBackground = TableViewSettings.HIGHLIGHT_DEFAULT_BACKGROUND;
        }
        return this.highlightBackground;
    }

    public Color getShadowColor() {
        this.prepareSettings();
        if (this.shadowColor == null) {
            this.shadowColor = TableViewSettings.SHADOW_DEFAULT_COLOR;
        }
        return this.shadowColor;
    }

    public Font getFont() {
        this.prepareSettings();
        return this.font;
    }

    public KeyStroke[] getKeyStrokesFindNext() {
        this.prepareSettings();
        if (this.keyStrokesFindNext == null || this.keyStrokesFindNext.length == 0) {
            this.keyStrokesFindNext = TableViewSettings.FIND_NEXT_DEFAULT_KEYSTROKES;
        }
        return this.keyStrokesFindNext;
    }

    public KeyStroke[] getKeyStrokesFindPrevious() {
        this.prepareSettings();
        if (this.keyStrokesFindPrevious == null || this.keyStrokesFindPrevious.length == 0) {
            this.keyStrokesFindPrevious = TableViewSettings.FIND_PREVIOUS_DEFAULT_KEYSTROKES;
        }
        return this.keyStrokesFindPrevious;
    }

    public KeyStroke[] getKeyStrokesToggleHighlight() {
        this.prepareSettings();
        if (this.keyStrokesToggleHighlight == null || this.keyStrokesToggleHighlight.length == 0) {
            this.keyStrokesToggleHighlight = TableViewSettings.TOGGLE_HIGHLIGHT_DEFAULT_KEYSTROKES;
        }
        return this.keyStrokesToggleHighlight;
    }

    public void settingsUpdated() {
        if (this.prepared) {
            this.support.firePropertyChange(new PropertyChangeEvent((Object)this, null, null, null));
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.support.removePropertyChangeListener(propertyChangeListener);
    }

    public static synchronized EditorSettingsCopy getLayerInstance() {
        if (editorSettingsCopy == null) {
            editorSettingsCopy = new EditorSettingsCopy();
        }
        return editorSettingsCopy;
    }

    private void prepareSettings() {
        if (this.prepared) {
            return;
        }
        this.prepared = true;
        this.fontsColors = MimeLookup.getLookup((String)"text/x-properties").lookupResult(FontColorSettings.class);
        this.fontsColors.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this.fontsColorsTracker, this.fontsColors));
        this.keybindings = MimeLookup.getLookup((String)"text/x-properties").lookupResult(KeyBindingSettings.class);
        this.keybindings.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this.keybindingsTracker, this.keybindings));
        this.updateColors();
        this.updateKeyStrokes();
    }

    private void updateColors() {
        FontColorSettings fontColorSettings = (FontColorSettings)this.fontsColors.allInstances().iterator().next();
        String string = PropertiesTokenContext.context.getNamePrefix();
        Coloring coloring = Coloring.fromAttributeSet((AttributeSet)fontColorSettings.getTokenFontColors(string + PropertiesTokenContext.KEY.getName()));
        this.keyColor = coloring.getForeColor();
        this.keyBackground = coloring.getBackColor();
        Coloring coloring2 = Coloring.fromAttributeSet((AttributeSet)fontColorSettings.getTokenFontColors(string + PropertiesTokenContext.VALUE.getName()));
        this.valueColor = coloring2.getForeColor();
        this.valueBackground = coloring2.getBackColor();
        Coloring coloring3 = Coloring.fromAttributeSet((AttributeSet)fontColorSettings.getFontColors("highlight-search"));
        this.highlightColor = coloring3.getForeColor();
        this.highlightBackground = coloring3.getBackColor();
        Coloring coloring4 = Coloring.fromAttributeSet((AttributeSet)fontColorSettings.getFontColors("default"));
        this.font = coloring4.getFont();
        Color color = coloring4.getForeColor();
        Color color2 = coloring4.getBackColor();
        if (this.keyColor == null) {
            this.keyColor = color;
        }
        if (this.keyBackground == null) {
            this.keyBackground = color2;
        }
        if (this.valueColor == null) {
            this.valueColor = color;
        }
        if (this.valueBackground == null) {
            this.valueBackground = color2;
        }
        if (this.highlightColor == null) {
            this.highlightColor = new Color(SystemColor.textHighlightText.getRGB());
        }
        if (this.highlightBackground == null) {
            this.highlightBackground = new Color(SystemColor.textHighlight.getRGB());
        }
        if (this.shadowColor == null) {
            this.shadowColor = new Color(SystemColor.controlHighlight.getRGB());
        }
    }

    private void updateKeyStrokes() {
        KeyBindingSettings keyBindingSettings = (KeyBindingSettings)this.keybindings.allInstances().iterator().next();
        HashSet<KeyStroke> hashSet = new HashSet<KeyStroke>();
        HashSet<KeyStroke> hashSet2 = new HashSet<KeyStroke>();
        HashSet<KeyStroke> hashSet3 = new HashSet<KeyStroke>();
        for (MultiKeyBinding multiKeyBinding : keyBindingSettings.getKeyBindings()) {
            int n;
            if (multiKeyBinding.getActionName().equals("find-next")) {
                for (n = 0; n < multiKeyBinding.getKeyStrokeCount(); ++n) {
                    hashSet.add(multiKeyBinding.getKeyStroke(n));
                }
            }
            if (multiKeyBinding.getActionName().equals("find-previous")) {
                for (n = 0; n < multiKeyBinding.getKeyStrokeCount(); ++n) {
                    hashSet2.add(multiKeyBinding.getKeyStroke(n));
                }
            }
            if (!multiKeyBinding.getActionName().equals("toggle-highlight-search")) continue;
            for (n = 0; n < multiKeyBinding.getKeyStrokeCount(); ++n) {
                hashSet3.add(multiKeyBinding.getKeyStroke(n));
            }
        }
        this.keyStrokesFindNext = new KeyStroke[hashSet.size()];
        hashSet.toArray(this.keyStrokesFindNext);
        this.keyStrokesFindPrevious = new KeyStroke[hashSet2.size()];
        hashSet2.toArray(this.keyStrokesFindPrevious);
        this.keyStrokesToggleHighlight = new KeyStroke[hashSet3.size()];
        hashSet3.toArray(this.keyStrokesToggleHighlight);
        this.settingsUpdated();
    }
}

