/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.impl.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmInheritance;
import org.netbeans.modules.cnd.api.model.CsmInstantiation;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.services.CsmInheritanceUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceSupport;
import org.netbeans.modules.cnd.api.model.xref.CsmTypeHierarchyResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TypeHierarchyResolverImpl
extends CsmTypeHierarchyResolver {
    public Collection<CsmReference> getSubTypes(CsmClass csmClass, boolean bl) {
        HierarchyModelImpl hierarchyModelImpl = new HierarchyModelImpl(csmClass, true, true, !bl);
        Set<CsmClass> set = hierarchyModelImpl.getModel().get(csmClass);
        if (set != null) {
            ArrayList<CsmReference> arrayList = new ArrayList<CsmReference>();
            for (CsmClass csmClass2 : set) {
                arrayList.add(CsmReferenceSupport.createObjectReference((CsmOffsetable)csmClass2));
            }
            return arrayList;
        }
        return Collections.emptyList();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class HierarchyModelImpl {
        private Map<CsmClass, Set<CsmClass>> myMap;

        public HierarchyModelImpl(CsmClass csmClass, boolean bl, boolean bl2, boolean bl3) {
            Set<CsmClass> set;
            this.myMap = bl ? this.buildSubHierarchy(csmClass) : this.buildSuperHierarchy(csmClass);
            if (!bl3) {
                set = this.myMap.get(csmClass);
                if (set == null) {
                    set = new HashSet<CsmClass>();
                }
                this.myMap = new HashMap<CsmClass, Set<CsmClass>>();
                this.myMap.put(csmClass, set);
            }
            if (bl2) {
                set = new HashSet<CsmClass>();
                this.gatherList(csmClass, set, this.myMap);
                this.myMap = new HashMap<CsmClass, Set<CsmClass>>();
                this.myMap.put(csmClass, set);
            }
        }

        public Map<CsmClass, Set<CsmClass>> getModel() {
            return this.myMap;
        }

        private void gatherList(CsmClass csmClass, Set<CsmClass> set, Map<CsmClass, Set<CsmClass>> map) {
            Set<CsmClass> set2 = map.get(csmClass);
            if (set2 == null) {
                return;
            }
            for (CsmClass csmClass2 : set2) {
                if (set.contains(csmClass2)) continue;
                set.add(csmClass2);
                this.gatherList(csmClass2, set, map);
            }
        }

        private Map<CsmClass, Set<CsmClass>> buildSuperHierarchy(CsmClass csmClass) {
            HashMap<CsmClass, Set<CsmClass>> hashMap = new HashMap<CsmClass, Set<CsmClass>>();
            this.buildSuperHierarchy(csmClass, hashMap);
            return hashMap;
        }

        private void buildSuperHierarchy(CsmClass csmClass, Map<CsmClass, Set<CsmClass>> map) {
            Set<CsmClass> set = map.get(csmClass);
            if (set != null) {
                return;
            }
            set = new HashSet<CsmClass>();
            map.put(csmClass, set);
            Collection collection = csmClass.getBaseClasses();
            if (collection != null && collection.size() > 0) {
                for (CsmInheritance csmInheritance : collection) {
                    CsmClass csmClass2 = this.getClassDeclaration(csmInheritance);
                    if (csmClass2 == null) continue;
                    set.add(csmClass2);
                    this.buildSuperHierarchy(csmClass2, map);
                }
            }
        }

        private Map<CsmClass, Set<CsmClass>> buildSubHierarchy(CsmClass csmClass) {
            HashMap<CsmClass, Set<CsmClass>> hashMap = new HashMap<CsmClass, Set<CsmClass>>();
            CsmProject csmProject = csmClass.getContainingFile().getProject();
            this.buildSubHierarchy(csmProject.getGlobalNamespace(), hashMap);
            return hashMap;
        }

        private void buildSubHierarchy(CsmNamespace csmNamespace, Map<CsmClass, Set<CsmClass>> map) {
            Iterator iterator = csmNamespace.getNestedNamespaces().iterator();
            while (iterator.hasNext()) {
                this.buildSubHierarchy((CsmNamespace)iterator.next(), map);
            }
            for (CsmDeclaration csmDeclaration : csmNamespace.getDeclarations()) {
                if (!CsmKindUtilities.isClass((CsmObject)csmDeclaration)) continue;
                this.buildSubHierarchy(map, (CsmClass)csmDeclaration);
            }
        }

        private CsmClass getClassDeclaration(CsmInheritance csmInheritance) {
            CsmOffsetableDeclaration csmOffsetableDeclaration;
            CsmClass csmClass = CsmInheritanceUtilities.getCsmClass((CsmInheritance)csmInheritance);
            if (CsmKindUtilities.isInstantiation((CsmObject)csmClass) && CsmKindUtilities.isClass((CsmObject)(csmOffsetableDeclaration = ((CsmInstantiation)csmClass).getTemplateDeclaration()))) {
                csmClass = (CsmClass)csmOffsetableDeclaration;
            }
            return csmClass;
        }

        private void buildSubHierarchy(Map<CsmClass, Set<CsmClass>> map, CsmClass csmClass) {
            Collection collection = csmClass.getBaseClasses();
            if (collection != null && collection.size() > 0) {
                for (CsmMember csmMember : collection) {
                    CsmClass csmClass2 = this.getClassDeclaration((CsmInheritance)csmMember);
                    if (csmClass2 == null) continue;
                    Set<CsmClass> set = map.get(csmClass2);
                    if (set == null) {
                        set = new HashSet<CsmClass>();
                        map.put(csmClass2, set);
                    }
                    set.add(csmClass);
                }
            }
            for (CsmMember csmMember : csmClass.getMembers()) {
                if (!CsmKindUtilities.isClass((CsmObject)csmMember)) continue;
                this.buildSubHierarchy(map, (CsmClass)csmMember);
            }
        }
    }
}

