/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.tax;

import org.netbeans.tax.AbstractTreeDocument;
import org.netbeans.tax.CannotMergeException;
import org.netbeans.tax.InvalidArgumentException;
import org.netbeans.tax.ReadOnlyException;
import org.netbeans.tax.TreeDocumentRoot;
import org.netbeans.tax.TreeDocumentType;
import org.netbeans.tax.TreeElement;
import org.netbeans.tax.TreeNode;
import org.netbeans.tax.TreeObject;
import org.netbeans.tax.TreeObjectList;
import org.netbeans.tax.TreeUtilities;
import org.netbeans.tax.Util;
import org.netbeans.tax.event.TreeEventManager;

public class TreeDocument
extends AbstractTreeDocument
implements TreeDocumentRoot {
    public static final String PROP_VERSION = "version";
    public static final String PROP_ENCODING = "encoding";
    public static final String PROP_STANDALONE = "standalone";
    private TreeEventManager eventManager;
    private String version;
    private String encoding;
    private String standalone;
    private TreeDocumentType documentType;
    private TreeElement rootElement;
    static /* synthetic */ Class class$org$netbeans$tax$spec$Document$Child;

    public TreeDocument(String string, String string2, String string3) throws InvalidArgumentException {
        this.checkVersion(string);
        this.checkEncoding(string2);
        this.checkStandalone(string3);
        this.checkHeader(string, string2, string3);
        this.version = string;
        this.encoding = string2;
        this.standalone = string3;
        this.eventManager = new TreeEventManager();
        this.documentType = null;
        this.rootElement = null;
    }

    public TreeDocument() throws InvalidArgumentException {
        this(null, null, null);
    }

    protected TreeDocument(TreeDocument treeDocument, boolean bl) {
        super(treeDocument, bl);
        this.version = treeDocument.version;
        this.encoding = treeDocument.encoding;
        this.standalone = treeDocument.standalone;
        this.eventManager = new TreeEventManager(treeDocument.eventManager);
    }

    public Object clone(boolean bl) {
        return new TreeDocument(this, bl);
    }

    public boolean equals(Object object, boolean bl) {
        if (!super.equals(object, bl)) {
            return false;
        }
        TreeDocument treeDocument = (TreeDocument)object;
        if (!Util.equals(this.getVersion(), treeDocument.getVersion())) {
            return false;
        }
        if (!Util.equals(this.getEncoding(), treeDocument.getEncoding())) {
            return false;
        }
        if (!Util.equals(this.getStandalone(), treeDocument.getStandalone())) {
            return false;
        }
        if (!Util.equals(this.documentType, treeDocument.documentType)) {
            return false;
        }
        return Util.equals(this.rootElement, treeDocument.rootElement);
    }

    public void merge(TreeObject treeObject) throws CannotMergeException {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("TreeDocument::merge: " + treeObject);
        }
        super.merge(treeObject);
        TreeDocument treeDocument = (TreeDocument)treeObject;
        try {
            this.setVersionImpl(treeDocument.getVersion());
            this.setEncodingImpl(treeDocument.getEncoding());
            this.setStandaloneImpl(treeDocument.getStandalone());
        }
        catch (Exception exception) {
            throw new CannotMergeException(treeObject, exception);
        }
        TreeEventManager treeEventManager = this.getEventManager();
        if (treeEventManager != null) {
            treeEventManager.setFirePolicy((short)1);
        }
    }

    public final String getVersion() {
        return this.version;
    }

    private final void setVersionImpl(String string) {
        String string2 = this.version;
        this.version = string;
        this.firePropertyChange(PROP_VERSION, string2, string);
    }

    public final void setVersion(String string) throws ReadOnlyException, InvalidArgumentException {
        if (Util.equals(this.version, string)) {
            return;
        }
        this.checkReadOnly();
        this.checkVersion(string);
        this.checkHeader(string, this.encoding, this.standalone);
        this.setVersionImpl(string);
    }

    protected final void checkVersion(String string) throws InvalidArgumentException {
        TreeUtilities.checkDocumentVersion(string);
    }

    public final String getEncoding() {
        return this.encoding;
    }

    private final void setEncodingImpl(String string) {
        String string2 = this.encoding;
        this.encoding = string;
        this.firePropertyChange(PROP_ENCODING, string2, string);
    }

    public final void setEncoding(String string) throws ReadOnlyException, InvalidArgumentException {
        if (Util.equals(this.encoding, string)) {
            return;
        }
        this.checkReadOnly();
        this.checkEncoding(string);
        this.checkHeader(this.version, string, this.standalone);
        this.setEncodingImpl(string);
    }

    protected final void checkEncoding(String string) throws InvalidArgumentException {
        TreeUtilities.checkDocumentEncoding(string);
    }

    public final String getStandalone() {
        return this.standalone;
    }

    private final void setStandaloneImpl(String string) {
        String string2 = this.standalone;
        this.standalone = string;
        this.firePropertyChange(PROP_STANDALONE, string2, string);
    }

    public final void setStandalone(String string) throws ReadOnlyException, InvalidArgumentException {
        if (Util.equals(this.standalone, string)) {
            return;
        }
        this.checkReadOnly();
        this.checkStandalone(string);
        this.checkHeader(this.version, this.encoding, string);
        this.setStandaloneImpl(string);
    }

    protected final void checkStandalone(String string) throws InvalidArgumentException {
        TreeUtilities.checkDocumentStandalone(string);
    }

    public final void setHeader(String string, String string2, String string3) throws ReadOnlyException, InvalidArgumentException {
        boolean bl;
        boolean bl2 = !Util.equals(this.version, string);
        boolean bl3 = !Util.equals(this.encoding, string2);
        boolean bl4 = bl = !Util.equals(this.standalone, string3);
        if (!(bl2 || bl3 || bl)) {
            return;
        }
        this.checkReadOnly();
        if (bl2) {
            this.checkVersion(string);
        }
        if (bl3) {
            this.checkEncoding(string2);
        }
        if (bl) {
            this.checkStandalone(string3);
        }
        this.checkHeader(string, string2, string3);
        if (bl2) {
            this.setVersionImpl(string);
        }
        if (bl3) {
            this.setEncodingImpl(string2);
        }
        if (bl) {
            this.setStandaloneImpl(string3);
        }
    }

    protected final void checkHeader(String string, String string2, String string3) throws InvalidArgumentException {
        if (string == null && (string2 != null || string3 != null)) {
            throw new InvalidArgumentException(Util.THIS.getString("EXC_invalid_document_header"), new NullPointerException());
        }
    }

    public final TreeEventManager getRootEventManager() {
        return this.eventManager;
    }

    public final TreeDocumentType getDocumentType() {
        return this.documentType;
    }

    public final void setDocumentType(TreeDocumentType treeDocumentType) throws ReadOnlyException, InvalidArgumentException {
        if (treeDocumentType == null) {
            this.removeChild(this.documentType);
        } else if (this.documentType == null) {
            if (this.rootElement == null) {
                this.appendChild(treeDocumentType);
            } else {
                this.insertChildAt(treeDocumentType, 0);
            }
        } else {
            this.replaceChild(this.documentType, treeDocumentType);
        }
    }

    public final TreeElement getDocumentElement() {
        return this.rootElement;
    }

    public final void setDocumentElement(TreeElement treeElement) throws ReadOnlyException, InvalidArgumentException {
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("\nTreeDocument::setDocumentElement: oldDocumentElement = " + this.rootElement);
        }
        if (Util.THIS.isLoggable()) {
            Util.THIS.debug("            ::setDocumentElement: newDocumentElement = " + treeElement);
        }
        if (treeElement == null) {
            this.removeChild(this.rootElement);
        } else if (this.rootElement == null) {
            this.appendChild(treeElement);
        } else {
            this.replaceChild(this.rootElement, treeElement);
        }
    }

    protected TreeObjectList.ContentManager createChildListContentManager() {
        return new ChildListContentManager();
    }

    protected class ChildListContentManager
    extends AbstractTreeDocument.ChildListContentManager {
        protected ChildListContentManager() {
        }

        public TreeNode getOwnerNode() {
            return TreeDocument.this;
        }

        public void checkAssignableObject(Object object) {
            super.checkAssignableObject(object);
            this.checkAssignableClass(class$org$netbeans$tax$spec$Document$Child == null ? (class$org$netbeans$tax$spec$Document$Child = TreeDocument.class$("org.netbeans.tax.spec.Document$Child")) : class$org$netbeans$tax$spec$Document$Child, object);
        }

        public void objectInserted(TreeObject treeObject) {
            block10: {
                super.objectInserted(treeObject);
                try {
                    if (treeObject instanceof TreeDocumentType) {
                        if (TreeDocument.this.documentType != null && TreeDocument.this.documentType != treeObject) {
                            TreeDocument.this.removeChild(TreeDocument.this.documentType);
                        }
                        TreeDocument.this.documentType = (TreeDocumentType)treeObject;
                    } else if (treeObject instanceof TreeElement) {
                        if (Util.THIS.isLoggable()) {
                            Util.THIS.debug("\nTreeDocument::ChildListContentManager::objectInserted: obj = " + treeObject);
                        }
                        if (Util.THIS.isLoggable()) {
                            Util.THIS.debug("            ::                       ::objectInserted: old root element = " + TreeDocument.this.rootElement);
                        }
                        if (TreeDocument.this.rootElement != null && TreeDocument.this.rootElement != treeObject) {
                            TreeDocument.this.removeChild(TreeDocument.this.rootElement);
                        }
                        TreeDocument.this.rootElement = (TreeElement)treeObject;
                        if (Util.THIS.isLoggable()) {
                            Util.THIS.debug("            ::                       ::objectInserted: NEW root element = " + TreeDocument.this.rootElement);
                        }
                    }
                }
                catch (Exception exception) {
                    if (!Util.THIS.isLoggable()) break block10;
                    Util.THIS.debug("TreeDocument::ChildListContentManager.objectInserted", exception);
                }
            }
        }

        public void objectRemoved(TreeObject treeObject) {
            super.objectRemoved(treeObject);
            if (TreeDocument.this.documentType == treeObject) {
                TreeDocument.this.documentType = null;
            } else if (TreeDocument.this.rootElement == treeObject) {
                TreeDocument.this.rootElement = null;
            }
        }
    }
}

