/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.rest.wizard.fromdb;

import java.awt.Component;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.TypeElement;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.api.progress.aggregate.AggregateProgressFactory;
import org.netbeans.api.progress.aggregate.AggregateProgressHandle;
import org.netbeans.api.progress.aggregate.ProgressContributor;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.persistence.api.PersistenceLocation;
import org.netbeans.modules.j2ee.persistence.api.metadata.orm.Entity;
import org.netbeans.modules.j2ee.persistence.dd.common.PersistenceUnit;
import org.netbeans.modules.j2ee.persistence.provider.InvalidPersistenceXmlException;
import org.netbeans.modules.j2ee.persistence.provider.ProviderUtil;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.EntityClassesPanel;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.PersistenceGenerator;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.PersistenceGeneratorProvider;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.ProgressPanel;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.RelatedCMPHelper;
import org.netbeans.modules.j2ee.persistence.wizard.fromdb.RelatedCMPWizard;
import org.netbeans.modules.websvc.api.support.LogUtils;
import org.netbeans.modules.websvc.api.support.java.SourceUtils;
import org.netbeans.modules.websvc.rest.RestUtils;
import org.netbeans.modules.websvc.rest.codegen.EntityResourcesGenerator;
import org.netbeans.modules.websvc.rest.codegen.EntityResourcesGeneratorFactory;
import org.netbeans.modules.websvc.rest.codegen.model.EntityResourceBeanModel;
import org.netbeans.modules.websvc.rest.codegen.model.EntityResourceModelBuilder;
import org.netbeans.modules.websvc.rest.codegen.model.RuntimeJpaEntity;
import org.netbeans.modules.websvc.rest.codegen.model.TypeUtil;
import org.netbeans.modules.websvc.rest.support.PersistenceHelper;
import org.netbeans.modules.websvc.rest.support.SourceGroupSupport;
import org.netbeans.modules.websvc.rest.wizard.EntityResourcesIterator;
import org.netbeans.modules.websvc.rest.wizard.fromdb.DatabaseTablesWizardPanel;
import org.netbeans.modules.websvc.rest.wizard.fromdb.EntityResourcesSetupPanel;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DatabaseResourceWizardIterator
implements WizardDescriptor.InstantiatingIterator {
    private int index;
    private WizardDescriptor wizard;
    private WizardDescriptor.Panel[] panels;
    private static final String PROP_CMP = "wizard-is-cmp";
    private static final String PROP_HELPER = "wizard-helper";
    private static final Lookup.Result<PersistenceGeneratorProvider> PERSISTENCE_PROVIDERS = Lookup.getDefault().lookupResult(PersistenceGeneratorProvider.class);
    private RelatedCMPHelper helper;
    private ProgressPanel progressPanel;
    private PersistenceGenerator generator;

    public void initialize(WizardDescriptor wizardDescriptor) {
        this.wizard = wizardDescriptor;
        Project project = Templates.getProject((WizardDescriptor)wizardDescriptor);
        this.generator = DatabaseResourceWizardIterator.createPersistenceGenerator("jpa");
        FileObject fileObject = PersistenceLocation.getLocation((Project)project);
        this.helper = new RelatedCMPHelper(project, fileObject, this.generator);
        wizardDescriptor.putProperty(PROP_HELPER, (Object)this.helper);
        wizardDescriptor.putProperty(PROP_CMP, (Object)new Boolean(false));
        this.generator.init(wizardDescriptor);
        SourceGroup[] sourceGroupArray = SourceGroupSupport.getJavaSourceGroups(project);
        if (Templates.getTargetFolder((WizardDescriptor)wizardDescriptor) == null && sourceGroupArray.length > 0) {
            Templates.setTargetFolder((WizardDescriptor)wizardDescriptor, (FileObject)sourceGroupArray[0].getRootFolder());
        }
    }

    public Set instantiate() throws IOException {
        if (this.helper.getPersistenceUnit() != null) {
            try {
                ProviderUtil.addPersistenceUnit((PersistenceUnit)this.helper.getPersistenceUnit(), (Project)Templates.getProject((WizardDescriptor)this.wizard));
            }
            catch (InvalidPersistenceXmlException invalidPersistenceXmlException) {
                Logger.getLogger(RelatedCMPWizard.class.getName()).log(Level.FINE, "Invalid persistence.xml: " + invalidPersistenceXmlException.getPath(), invalidPersistenceXmlException);
            }
        }
        final String string = NbBundle.getMessage(RelatedCMPWizard.class, (String)"TXT_EntityClassesGeneration");
        final ProgressContributor progressContributor = AggregateProgressFactory.createProgressContributor((String)string);
        final AggregateProgressHandle aggregateProgressHandle = AggregateProgressFactory.createHandle((String)string, (ProgressContributor[])new ProgressContributor[]{progressContributor}, null, null);
        this.progressPanel = new ProgressPanel();
        final JComponent jComponent = AggregateProgressFactory.createProgressComponent((AggregateProgressHandle)aggregateProgressHandle);
        final Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    aggregateProgressHandle.start();
                    DatabaseResourceWizardIterator.this.generate(progressContributor);
                }
                catch (IOException iOException) {
                    Logger.getLogger("global").log(Level.INFO, null, iOException);
                    NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)iOException.getLocalizedMessage(), 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                }
                finally {
                    DatabaseResourceWizardIterator.this.generator.uninit();
                    aggregateProgressHandle.finish();
                }
            }
        };
        SwingUtilities.invokeLater(new Runnable(){
            private boolean first = true;

            public void run() {
                if (!this.first) {
                    RequestProcessor.getDefault().post(runnable);
                    DatabaseResourceWizardIterator.this.progressPanel.open(jComponent, string);
                } else {
                    this.first = false;
                    SwingUtilities.invokeLater(this);
                }
            }
        });
        Object[] objectArray = new Object[5];
        objectArray[0] = "JAX-RS";
        Project project = Templates.getProject((WizardDescriptor)this.wizard);
        objectArray[1] = project.getClass().getName();
        J2eeModule j2eeModule = RestUtils.getJ2eeModule(project);
        objectArray[2] = j2eeModule == null ? null : j2eeModule.getModuleVersion() + "(WAR)";
        objectArray[3] = "REST FROM DATABASE";
        LogUtils.logWsWizard((Object[])objectArray);
        return Collections.singleton(DataFolder.findFolder((FileObject)DatabaseResourceWizardIterator.getFolderForPackage(this.helper.getLocation(), this.helper.getPackageName())));
    }

    private static PersistenceGenerator createPersistenceGenerator(String string) {
        assert (string != null);
        Collection collection = PERSISTENCE_PROVIDERS.allInstances();
        for (PersistenceGeneratorProvider persistenceGeneratorProvider : collection) {
            if (!string.equals(persistenceGeneratorProvider.getGeneratorType())) continue;
            return persistenceGeneratorProvider.createGenerator();
        }
        throw new AssertionError((Object)("Could not find a persistence generator of type " + string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generate(ProgressContributor progressContributor) throws IOException {
        final Project project = Templates.getProject((WizardDescriptor)this.wizard);
        try {
            RequestProcessor.Task task;
            Object object;
            progressContributor.start(1);
            progressContributor.progress(NbBundle.getMessage(RelatedCMPWizard.class, (String)"TXT_SavingSchema"));
            this.progressPanel.setText(NbBundle.getMessage(RelatedCMPWizard.class, (String)"TXT_SavingSchema"));
            FileObject fileObject = this.helper.getDBSchemaFile();
            String string = NbBundle.getMessage(RelatedCMPWizard.class, (String)"TXT_ExtractingEntityClassesAndRelationships");
            progressContributor.progress(string);
            this.progressPanel.setText(string);
            this.helper.buildBeans();
            this.generator.generateBeans(this.progressPanel, this.helper, fileObject, progressContributor);
            Set set = this.generator.createdObjects();
            Set<Entity> set2 = this.getEntities(project, set);
            EntityResourceModelBuilder entityResourceModelBuilder = new EntityResourceModelBuilder(project, set2);
            EntityResourceBeanModel entityResourceBeanModel = entityResourceModelBuilder.build(set2);
            PersistenceHelper.PersistenceUnit persistenceUnit = new PersistenceHelper(project).getPersistenceUnit();
            RestUtils.ensureRestDevelopmentReady(project);
            FileObject fileObject2 = (FileObject)this.wizard.getProperty("targetSourceRoot");
            String string2 = null;
            String string3 = null;
            String string4 = null;
            if (fileObject2 != null) {
                string2 = SourceGroupSupport.packageForFolder(fileObject2);
                string3 = (String)this.wizard.getProperty("resourcePackage");
                string4 = (String)this.wizard.getProperty("converterPackage");
            } else {
                fileObject2 = Templates.getTargetFolder((WizardDescriptor)this.wizard);
                object = null;
                string2 = "";
                if (fileObject2 != null && (object = SourceGroupSupport.findSourceGroupForFile((SourceGroup[])(task = SourceGroupSupport.getJavaSourceGroups(project)), fileObject2)) != null) {
                    string2 = SourceGroupSupport.getPackageForFolder((SourceGroup)object, fileObject2);
                }
                string2 = string2.length() == 0 ? "" : string2 + ".";
                string3 = string2 + "service";
                string4 = string2 + "converter";
            }
            object = EntityResourcesGeneratorFactory.newInstance(project);
            ((EntityResourcesGenerator)object).initialize(entityResourceBeanModel, project, fileObject2, string2, string3, string4, persistenceUnit);
            task = RequestProcessor.getDefault().create(new Runnable((EntityResourcesGenerator)object){
                final /* synthetic */ EntityResourcesGenerator val$gen;
                {
                    this.val$gen = entityResourcesGenerator;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        RestUtils.disableRestServicesChangeListner(project);
                        this.val$gen.generate(null);
                    }
                    catch (Exception exception) {
                        Exceptions.printStackTrace((Throwable)exception);
                    }
                    finally {
                        RestUtils.enableRestServicesChangeListner(project);
                    }
                }
            });
            task.schedule(50);
        }
        catch (Throwable throwable) {
            progressContributor.finish();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DatabaseResourceWizardIterator.this.progressPanel.close();
                }
            });
            throw throwable;
        }
        progressContributor.finish();
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    private WizardDescriptor.Panel[] getPanels() {
        if (this.panels == null) {
            String string = "Templates/Persistence/RelatedCMP";
            String string2 = NbBundle.getMessage(RelatedCMPWizard.class, (String)string);
            this.panels = new WizardDescriptor.Panel[]{new DatabaseTablesWizardPanel(string2, this.wizard), new EntityClassesPanel.WizardPanel(), new EntityResourcesSetupPanel(NbBundle.getMessage(EntityResourcesIterator.class, (String)"LBL_RestResourcesAndClasses"), this.wizard)};
            String[] stringArray = this.createSteps();
            for (int i = 0; i < this.panels.length; ++i) {
                Component component = this.panels[i].getComponent();
                if (stringArray[i] == null) {
                    stringArray[i] = component.getName();
                }
                if (!(component instanceof JComponent)) continue;
                JComponent jComponent = (JComponent)component;
                jComponent.putClientProperty("WizardPanel_contentSelectedIndex", new Integer(i));
                jComponent.putClientProperty("WizardPanel_contentData", stringArray);
                jComponent.putClientProperty("WizardPanel_autoWizardStyle", Boolean.TRUE);
                jComponent.putClientProperty("WizardPanel_contentDisplayed", Boolean.TRUE);
                jComponent.putClientProperty("WizardPanel_contentNumbered", Boolean.TRUE);
            }
        }
        return this.panels;
    }

    private Set<Entity> getEntities(Project project, Set<FileObject> set) throws IOException {
        final HashSet<Entity> hashSet = new HashSet<Entity>();
        for (FileObject fileObject : set) {
            JavaSource javaSource = JavaSource.forFileObject((FileObject)fileObject);
            javaSource.runUserActionTask((Task)new Task<CompilationController>(){

                public void run(CompilationController compilationController) throws Exception {
                    compilationController.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                    TypeElement typeElement = SourceUtils.getPublicTopLevelElement((CompilationController)compilationController);
                    if (typeElement != null) {
                        String string = null;
                        TypeElement typeElement2 = compilationController.getElements().getTypeElement("javax.persistence.Table");
                        if (typeElement2 != null && (string = TypeUtil.getAnnotationValueName(compilationController, typeElement, typeElement2)) == null && (typeElement2 = compilationController.getElements().getTypeElement("javax.persistence.Entity")) != null) {
                            string = TypeUtil.getAnnotationValueName(compilationController, typeElement, typeElement2);
                        }
                        if (string != null) {
                            hashSet.add(new RuntimeJpaEntity(typeElement, string));
                        }
                    }
                }
            }, true);
        }
        return hashSet;
    }

    public void uninitialize(WizardDescriptor wizardDescriptor) {
        this.panels = null;
    }

    public WizardDescriptor.Panel current() {
        return this.getPanels()[this.index];
    }

    public String name() {
        return this.index + 1 + ". from " + this.getPanels().length;
    }

    public boolean hasNext() {
        return this.index < this.getPanels().length - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    private String[] createSteps() {
        String[] stringArray = null;
        Object object = this.wizard.getProperty("WizardPanel_contentData");
        if (object != null && object instanceof String[]) {
            stringArray = (String[])object;
        }
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        String[] stringArray2 = new String[stringArray.length - 1 + this.panels.length];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = i < stringArray.length - 1 ? stringArray[i] : this.panels[i - stringArray.length + 1].getComponent().getName();
        }
        return stringArray2;
    }

    public static FileObject getFolderForPackage(SourceGroup sourceGroup, String string) throws IOException {
        Parameters.notNull((CharSequence)"sourceGroup", (Object)sourceGroup);
        Parameters.notNull((CharSequence)"packageName", (Object)string);
        String string2 = string.replace('.', '/');
        FileObject fileObject = sourceGroup.getRootFolder().getFileObject(string2);
        if (fileObject != null) {
            return fileObject;
        }
        return FileUtil.createFolder((FileObject)sourceGroup.getRootFolder(), (String)string2);
    }
}

