/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.junit.nodes;

import java.awt.Toolkit;
import java.util.regex.Pattern;
import javax.swing.Action;
import org.netbeans.api.extexecution.print.LineConvertors;
import org.netbeans.modules.gsf.testrunner.api.TestsuiteNode;
import org.netbeans.modules.gsf.testrunner.api.Trouble;
import org.netbeans.modules.maven.junit.nodes.JUnitTestMethodNode;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.text.Line;

final class OutputUtils {
    static final Action[] NO_ACTIONS = new Action[0];
    static final String CALLSTACK_LINE_PREFIX = "at ";
    static final String CALLSTACK_LINE_PREFIX_CATCH = "[catch] ";
    private static final String JAVA_ID_START_REGEX = "\\p{javaJavaIdentifierStart}";
    private static final String JAVA_ID_PART_REGEX = "\\p{javaJavaIdentifierPart}";
    public static final String JAVA_ID_REGEX = "(?:\\p{javaJavaIdentifierStart})(?:\\p{javaJavaIdentifierPart})*";
    public static final String JAVA_ID_REGEX_FULL = "(?:\\p{javaJavaIdentifierStart})(?:\\p{javaJavaIdentifierPart})*(?:\\.(?:\\p{javaJavaIdentifierStart})(?:\\p{javaJavaIdentifierPart})*)*";
    static final String LOCATION_IN_FILE_REGEX = "(?:\\p{javaJavaIdentifierStart})(?:\\p{javaJavaIdentifierPart})*(?:\\.(?:\\p{javaJavaIdentifierStart})(?:\\p{javaJavaIdentifierPart})*)*(?:\\:[0-9]+)?";
    static final Pattern LOC_PATTERN = Pattern.compile("(?:\\p{javaJavaIdentifierStart})(?:\\p{javaJavaIdentifierPart})*(?:\\.(?:\\p{javaJavaIdentifierStart})(?:\\p{javaJavaIdentifierPart})*)*(?:\\:[0-9]+)?");

    private OutputUtils() {
    }

    static String specialTrim(String string) {
        char c;
        int n;
        int n2 = string.length();
        if (n2 == 0) {
            return string;
        }
        char[] cArray = string.toCharArray();
        for (n = 0; n < n2 && ((c = cArray[n]) == ' ' || c == '\t'); ++n) {
        }
        if (n == n2) {
            return string.substring(n2);
        }
        int n3 = n2;
        while ((c = cArray[--n3]) == ' ' || c == '\t') {
        }
        if (n == 0 && n3 == n2 - 1) {
            return string;
        }
        return string.substring(n, n3 + 1);
    }

    static void openTestsuite(TestsuiteNode testsuiteNode) {
        Node node;
        Children children = testsuiteNode.getChildren();
        if (children != null && (node = children.getNodeAt(0)) != null && node instanceof JUnitTestMethodNode) {
            FileObject fileObject = ((JUnitTestMethodNode)node).getTestcaseFileObject();
            OutputUtils.openFile(fileObject, 1);
        }
    }

    static void openCallstackFrame(Node node, String string) {
        String[] stringArray;
        JUnitTestMethodNode jUnitTestMethodNode = OutputUtils.getTestMethodNode(node);
        LineConvertors.FileLocator fileLocator = jUnitTestMethodNode.getTestcase().getSession().getFileLocator();
        if (fileLocator == null) {
            return;
        }
        int[] nArray = new int[1];
        FileObject fileObject = OutputUtils.getFile(string, nArray, fileLocator);
        if (fileObject == null && jUnitTestMethodNode.getTestcase().getTrouble() != null && (stringArray = jUnitTestMethodNode.getTestcase().getTrouble().getStackTrace()) != null && stringArray.length > 0) {
            fileObject = OutputUtils.getFile(stringArray[stringArray.length - 1], nArray, fileLocator);
        }
        OutputUtils.openFile(fileObject, nArray[0]);
    }

    static String determineStackFrame(Trouble trouble) {
        String[] stringArray = trouble.getStackTrace();
        return stringArray != null && stringArray.length != 0 ? stringArray[stringArray.length - 1] : null;
    }

    private static JUnitTestMethodNode getTestMethodNode(Node node) {
        while (!(node instanceof JUnitTestMethodNode)) {
            node = node.getParentNode();
        }
        return (JUnitTestMethodNode)node;
    }

    private static FileObject getFile(String string, int[] nArray, LineConvertors.FileLocator fileLocator) {
        String string2;
        String string3;
        int n;
        int n2;
        String string4;
        String string5;
        block13: {
            int n3;
            String string6 = OutputUtils.specialTrim(string);
            if (string6.startsWith(CALLSTACK_LINE_PREFIX_CATCH)) {
                string6 = string6.substring(CALLSTACK_LINE_PREFIX_CATCH.length());
            }
            if (string6.startsWith(CALLSTACK_LINE_PREFIX)) {
                string6 = string6.substring(CALLSTACK_LINE_PREFIX.length());
            }
            String string7 = (n3 = string6.indexOf(40)) == -1 ? string6 : string6.substring(0, n3).trim();
            String string8 = n3 == -1 ? (String)null : string6.substring(n3 + 1, string6.lastIndexOf(41));
            int n4 = string7.lastIndexOf(46);
            string5 = string7.substring(0, n4);
            String string9 = string7.substring(n4 + 1);
            string4 = null;
            n2 = -1;
            if (string8 != null && LOC_PATTERN.matcher(string8).matches()) {
                int n5 = string8.lastIndexOf(58);
                if (n5 == -1) {
                    string4 = string8;
                } else {
                    string4 = string8.substring(0, n5);
                    try {
                        n2 = Integer.parseInt(string8.substring(n5 + 1));
                        if (n2 <= 0) {
                            n2 = 1;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        if ($assertionsDisabled) break block13;
                        throw new AssertionError();
                    }
                }
            }
        }
        String string10 = string5.replace('.', '/');
        if (string4 == null) {
            n = string10.length();
            string3 = string10;
            string2 = ".java";
        } else {
            n = string10.lastIndexOf(47);
            string3 = n != -1 ? string10.substring(0, n) : string10;
            string2 = '/' + string4;
        }
        String string11 = string3 + string2;
        FileObject fileObject = fileLocator.find(string11);
        while (fileObject == null && n != -1) {
            string11 = (string3 = string3.substring(0, n)) + string2;
            fileObject = fileLocator.find(string11);
            if (fileObject != null) continue;
            n = string3.lastIndexOf(47, n - 1);
        }
        if (fileObject == null && string4 != null) {
            string11 = string4;
            fileObject = fileLocator.find(string11);
        }
        if (fileObject == null) {
            n2 = -1;
        }
        nArray[0] = n2;
        return fileObject;
    }

    public static void openFile(FileObject fileObject, int n) {
        block8: {
            if (fileObject == null) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
                if (editorCookie != null && fileObject == dataObject.getPrimaryFile()) {
                    if (n == -1) {
                        editorCookie.open();
                        break block8;
                    }
                    editorCookie.openDocument();
                    try {
                        Line line = editorCookie.getLineSet().getOriginal(n - 1);
                        if (!line.isDeleted()) {
                            line.show(Line.ShowOpenType.OPEN, Line.ShowVisibilityType.FOCUS);
                        }
                        break block8;
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        editorCookie.open();
                    }
                    break block8;
                }
                Toolkit.getDefaultToolkit().beep();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

