/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.tools.common.dbgp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.netbeans.modules.web.client.tools.common.dbgp.HttpMessage;
import org.netbeans.modules.web.client.tools.common.dbgp.InitMessage;
import org.netbeans.modules.web.client.tools.common.dbgp.Log;
import org.netbeans.modules.web.client.tools.common.dbgp.MessageBuilder;
import org.netbeans.modules.web.client.tools.common.dbgp.OnloadMessage;
import org.netbeans.modules.web.client.tools.common.dbgp.ReloadSourcesMessage;
import org.netbeans.modules.web.client.tools.common.dbgp.SourcesMessage;
import org.netbeans.modules.web.client.tools.common.dbgp.UnsufficientValueException;
import org.netbeans.modules.web.client.tools.common.dbgp.WindowsMessage;
import org.openide.util.NbBundle;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import sun.misc.BASE64Decoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Message {
    private static final String ERR_PACKET_ERROR = "ERR_PacketError";
    private static final String ERR_END_OF_STREAM = "ERR_EndOfStream";
    private static final String INIT = "init";
    private static final String ONLOAD = "onload";
    private static final String SOURCES = "sources";
    private static final String RELOADSOURCES = "reloadsources";
    private static final String WINDOWS = "windows";
    private static final String RESPONSE = "response";
    private static final String STREAM = "stream";
    private static final String HTTP = "http";
    static final String FILE_URI = "fileuri";
    static final String ISO_CHARSET = "ISO-8859-1";
    static final String UTF_8 = "UTF-8";
    private static final int MAX_PACKET_SIZE = 1024;
    protected static final String HTML_APOS = "&apos;";
    protected static final String HTML_QUOTE = "&quot;";
    protected static final String HTML_AMP = "&amp";
    protected static final String HTML_LT = "&lt";
    protected static final String HTML_GT = "&gt";
    protected static final Map<String, Character> ENTITIES = new HashMap<String, Character>();
    private Node node;
    private static DocumentBuilder BUILDER;
    private static AtomicInteger maxDataSize;

    Message(Node node) {
        this.node = node;
    }

    public static Message create(InputStream inputStream) throws IOException {
        int n = Message.getDataSize(inputStream);
        if (n < 0) {
            Message.notifyPacketError(null);
            Log.getLogger().log(Level.FINE, "Got " + n + " as data size");
            return null;
        }
        byte[] byArray = Message.getContent(inputStream, n);
        Node node = Message.getNode(byArray);
        Log.getLogger().fine("\nResponse: " + new String(byArray));
        return Message.create(node);
    }

    public static int getMaxDataSize() {
        return maxDataSize.get();
    }

    public static void setMaxDataSize(int n) {
        int n2 = maxDataSize.get();
        if (n2 < n) {
            maxDataSize.compareAndSet(n2, n);
        }
    }

    public static Message create(Node node) {
        if (node == null) {
            return null;
        }
        String string = node.getNodeName();
        if (INIT.equals(string)) {
            return new InitMessage(node);
        }
        if (ONLOAD.equals(string)) {
            return new OnloadMessage(node);
        }
        if (SOURCES.equals(string)) {
            return new SourcesMessage(node);
        }
        if (RELOADSOURCES.equals(string)) {
            return new ReloadSourcesMessage(node);
        }
        if (WINDOWS.equals(string)) {
            return new WindowsMessage(node);
        }
        if (STREAM.equals(string)) {
            return MessageBuilder.createStream(node);
        }
        if (RESPONSE.equals(string)) {
            return MessageBuilder.createResponse(node);
        }
        if (HTTP.equals(string)) {
            return new HttpMessage(node);
        }
        return null;
    }

    static byte[] getDecodedBytes(Encoding encoding, String string) {
        byte[] byArray = new byte[]{};
        if (Encoding.NONE.equals((Object)encoding) || encoding == null) {
            try {
                byArray = string.getBytes(UTF_8);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                Log.getLogger().log(Level.INFO, unsupportedEncodingException.getMessage(), unsupportedEncodingException);
            }
        } else {
            BASE64Decoder bASE64Decoder = new BASE64Decoder();
            try {
                byArray = bASE64Decoder.decodeBuffer(string);
            }
            catch (IOException iOException) {
                Log.getLogger().log(Level.INFO, iOException.getMessage(), iOException);
            }
        }
        return byArray;
    }

    static void checkValue(byte[] byArray, int n) throws UnsufficientValueException {
        if (byArray.length < n) {
            throw new UnsufficientValueException();
        }
    }

    protected static String getNodeValue(Node node) {
        return Message.getNodeValueImpl(node).toString();
    }

    protected static StringBuilder getNodeValueImpl(Node node) {
        NodeList nodeList = node.getChildNodes();
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2 instanceof Text) {
                stringBuilder.append(node2.getNodeValue());
                continue;
            }
            if (!(node2 instanceof CDATASection)) continue;
            stringBuilder.append(node2.getNodeValue());
        }
        return stringBuilder;
    }

    protected static String getAttribute(Node node, String string) {
        Node node2 = node.getAttributes().getNamedItem(string);
        return node2 == null ? null : node2.getNodeValue();
    }

    protected static int getInt(Node node, String string) {
        String string2 = Message.getAttribute(node, string);
        if (string2 == null) {
            return -1;
        }
        try {
            return Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            assert (false);
            return -1;
        }
    }

    protected static boolean getBoolean(Node node, String string) {
        return Message.getInt(node, string) > 0;
    }

    protected static Node getChild(Node node, String string) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!string.equals(node2.getNodeName())) continue;
            return node2;
        }
        return null;
    }

    protected static List<Node> getChildren(Node node, String string) {
        LinkedList<Node> linkedList = new LinkedList<Node>();
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (!string.equals(node2.getNodeName())) continue;
            linkedList.add(node2);
        }
        return linkedList;
    }

    protected Node getNode() {
        return this.node;
    }

    private static void log(ParserConfigurationException parserConfigurationException) {
        Log.getLogger().log(Level.SEVERE, null, parserConfigurationException);
    }

    private static void logDebugInfo(byte[] byArray) {
        block2: {
            try {
                Log.getLogger().log(Level.FINE, new String(byArray, UTF_8));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    private static void notifyPacketError(Exception exception) {
        Exception exception2 = exception;
        if (exception2 == null) {
            // empty if block
        }
        Log.getLogger().log(Level.SEVERE, null, exception);
    }

    private static byte[] getContent(InputStream inputStream, int n) throws IOException {
        int n2;
        int n3;
        int n4;
        byte[] byArray = new byte[n];
        for (n4 = 0; n4 < n; n4 += inputStream.read(byArray, n4, n3)) {
            n2 = n - n4;
            n3 = n2 < Message.getMaxDataSize() ? n2 : Message.getMaxDataSize();
        }
        if (n4 != n) {
            Message.notifyPacketError(null);
            Log.getLogger().log(Level.FINE, "Red " + n4 + " bytes from socket input stream," + " but expected " + n + " bytes");
            return null;
        }
        n2 = inputStream.read();
        assert (n2 == 0);
        return byArray;
    }

    static int getDataSize(InputStream inputStream) throws IOException {
        int n;
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        while ((n = inputStream.read()) > 0) {
            linkedList.add(n);
        }
        if (n == -1) {
            throw new IOException(NbBundle.getMessage(Message.class, (String)ERR_END_OF_STREAM));
        }
        byte[] byArray = new byte[linkedList.size()];
        int n2 = 0;
        for (Integer n3 : linkedList) {
            byte by = n3.byteValue();
            byArray[n2++] = by;
        }
        String string = new String(byArray, UTF_8);
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            assert (false);
            return -1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Node getNode(byte[] byArray) throws IOException {
        if (BUILDER == null || byArray == null) {
            return null;
        }
        try {
            DocumentBuilder documentBuilder = BUILDER;
            synchronized (documentBuilder) {
                Document document = BUILDER.parse(new ByteArrayInputStream(byArray));
                return document.getDocumentElement();
            }
        }
        catch (SAXException sAXException) {
            Message.notifyPacketError(sAXException);
            return null;
        }
    }

    static Message createMessage(String string) {
        try {
            byte[] byArray = string.getBytes();
            String string2 = byArray.length + "";
            byte[] byArray2 = string2.getBytes();
            byte[] byArray3 = new byte[byArray2.length + byArray.length + 2];
            System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
            byArray3[byArray2.length] = 0;
            System.arraycopy(byArray, 0, byArray3, byArray2.length + 1, byArray.length);
            byArray3[byArray3.length - 1] = 0;
            return Message.create(new ByteArrayInputStream(byArray3));
        }
        catch (IOException iOException) {
            Log.getLogger().log(Level.SEVERE, "Unable to create stopped message", iOException);
            return null;
        }
    }

    static {
        ENTITIES.put(HTML_APOS, Character.valueOf('\''));
        ENTITIES.put(HTML_QUOTE, Character.valueOf('\"'));
        ENTITIES.put(HTML_AMP, Character.valueOf('&'));
        ENTITIES.put(HTML_LT, Character.valueOf('<'));
        ENTITIES.put(HTML_GT, Character.valueOf('>'));
        maxDataSize = new AtomicInteger(1024);
        try {
            BUILDER = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            BUILDER.setEntityResolver(new StubResolver());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            Message.log(parserConfigurationException);
        }
    }

    private static class StubResolver
    implements EntityResolver {
        private StubResolver() {
        }

        public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Encoding {
        BASE64,
        NONE;


        public String toString() {
            return super.toString().toLowerCase();
        }
    }
}

