/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.tools.common.dbgp;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.web.client.tools.common.dbgp.Message;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpMessage
extends Message {
    private String id;
    private String timeStamp;
    private String encoding;
    private String responseText;
    private String type;
    private String url;
    private String methodType;
    private String postText;

    HttpMessage(Node node) {
        super(node);
    }

    public String getId() {
        if (this.id == null) {
            this.id = HttpMessage.getChild(this.getNode(), "id").getChildNodes().item(0).getNodeValue();
        }
        return this.id;
    }

    public String getTimeStamp() {
        if (this.timeStamp == null) {
            this.timeStamp = HttpMessage.getChild(this.getNode(), "timestamp").getFirstChild().getNodeValue();
        }
        return this.timeStamp;
    }

    public String getContentEncoding() {
        Map<String, String> map;
        if (this.encoding == null && (map = this.getHeader()) != null) {
            this.encoding = map.get("Content-Encoding");
        }
        return this.encoding;
    }

    public String getResponseText() {
        String string;
        Node node;
        if (this.responseText == null && (node = HttpMessage.getChild(this.getNode(), "responseText")) != null && node.getFirstChild() != null && (string = node.getFirstChild().getNodeValue()) != null && !string.equals("null")) {
            byte[] byArray = Message.getDecodedBytes(Message.Encoding.BASE64, string);
            String string2 = this.getContentEncoding();
            this.responseText = new String(byArray);
        }
        return this.responseText;
    }

    public String getType() {
        if (this.type == null) {
            this.type = HttpMessage.getChild(this.getNode(), "type").getFirstChild().getNodeValue();
        }
        return this.type;
    }

    public String getUrl() {
        if (this.url == null) {
            this.url = HttpMessage.getChild(this.getNode(), "url").getFirstChild().getNodeValue();
        }
        return this.url;
    }

    public String getMethodType() {
        if (this.methodType == null) {
            this.methodType = HttpMessage.getChild(this.getNode(), "method").getFirstChild().getNodeValue();
        }
        return this.methodType;
    }

    public String getPostText() {
        if (this.postText == null && HttpMessage.getChild(this.getNode(), "postText") != null) {
            this.postText = HttpMessage.getChild(this.getNode(), "postText").getFirstChild().getNodeValue();
        }
        return this.postText;
    }

    public boolean isLoadTriggerByUser() {
        String string = this.getChildValue("load_init");
        return string != null && !string.equals("0");
    }

    public String getUrlParams() {
        NodeList nodeList;
        Node node = HttpMessage.getChild(this.getNode(), "urlParams");
        if (node != null && (nodeList = node.getChildNodes()).getLength() > 0) {
            return nodeList.item(0).getNodeValue();
        }
        return "";
    }

    public String getChildValue(String string) {
        Node node;
        Node node2 = HttpMessage.getChild(this.getNode(), string);
        if (node2 != null && (node = node2.getFirstChild()) != null) {
            return node.getNodeValue();
        }
        return null;
    }

    public Map<String, String> getHeader() {
        Node node = HttpMessage.getChild(this.getNode(), "header");
        if (node == null) {
            return Collections.emptyMap();
        }
        NodeList nodeList = node.getChildNodes();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            Node node3 = node2.getFirstChild();
            if (node3 == null) continue;
            hashMap.put(node2.getNodeName(), node3.getNodeValue());
        }
        return hashMap;
    }
}

