/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.tools.common.dbgp;

import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.web.client.tools.common.dbgp.BaseMessageChildElement;
import org.netbeans.modules.web.client.tools.common.dbgp.Command;
import org.netbeans.modules.web.client.tools.common.dbgp.CommandMap;
import org.netbeans.modules.web.client.tools.common.dbgp.ResponseMessage;
import org.w3c.dom.Node;

public class Breakpoint
extends BaseMessageChildElement {
    protected static final String FUNCTION = "function";
    protected static final String LINENO = "lineno";
    protected static final String EXCEPTION = "exception";
    protected static final String HIT_VALUE = "hit_value";
    protected static final String HIT_CONDITION = "hit_condition";
    protected static final String HIT_COUNT = "hit_count";
    protected static final String TYPE = "type";
    protected static final String FILENAME = "filename";
    protected static final String STATE = "state";
    protected static final String ID = "id";

    Breakpoint(Node node) {
        super(node);
    }

    public String getId() {
        return this.getAttribute(ID);
    }

    public State getState() {
        String string = this.getAttribute(STATE);
        return State.valueOf(string.toUpperCase());
    }

    public String getFileURI() {
        return this.getAttribute(FILENAME);
    }

    public String getFunction() {
        return this.getAttribute(FUNCTION);
    }

    public String getException() {
        return this.getAttribute(EXCEPTION);
    }

    public Type getType() {
        String string = this.getAttribute(TYPE);
        return Type.valueOf(string.toUpperCase());
    }

    public int getLineNumber() {
        return this.getInt(LINENO);
    }

    public int getHitValue() {
        return this.getInt(HIT_VALUE);
    }

    public int getHitCount() {
        return this.getInt(HIT_COUNT);
    }

    public HitCondition getHitCondition() {
        String string = this.getAttribute(TYPE);
        return HitCondition.valueOf(string.toUpperCase());
    }

    public static class BreakpointRemoveResponse
    extends ResponseMessage {
        BreakpointRemoveResponse(Node node) {
            super(node);
        }
    }

    public static class BreakpointRemoveCommand
    extends BreakpointGetCommand {
        public BreakpointRemoveCommand(int n, String string) {
            super(CommandMap.BREAKPOINT_REMOVE.getCommand(), n, string);
        }
    }

    public static class BreakpointUpdateResponse
    extends ResponseMessage {
        BreakpointUpdateResponse(Node node) {
            super(node);
        }
    }

    public static class BreakpointUpdateCommand
    extends BreakpointGetCommand {
        public BreakpointUpdateCommand(int n, String string) {
            super(CommandMap.BREAKPOINT_UPDATE.getCommand(), n, string);
        }

        protected String getArguments() {
            this.setTemporary(false);
            this.setFileURI(null);
            this.setType(null);
            StringBuilder stringBuilder = this.getBaseArguments();
            return super.getArguments() + " " + stringBuilder.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BreakpointListResponse
    extends BreakpointGetResponse {
        BreakpointListResponse(Node node) {
            super(node);
        }

        public List<Breakpoint> getBreakpoints() {
            LinkedList<Breakpoint> linkedList = new LinkedList<Breakpoint>();
            for (Node node : BreakpointListResponse.getChildren(this.getNode(), "breakpoint")) {
                linkedList.add(new Breakpoint(node));
            }
            return linkedList;
        }
    }

    public static class BreakpointListCommand
    extends BreakpointSetCommand {
        public BreakpointListCommand(int n) {
            super(CommandMap.BREAKPOINT_LIST.getCommand(), n);
        }
    }

    public static class BreakpointGetResponse
    extends BreakpointSetResponse {
        protected static final String BREAKPOINT = "breakpoint";

        BreakpointGetResponse(Node node) {
            super(node);
        }

        public Breakpoint getBreakpoint() {
            return new Breakpoint(BreakpointGetResponse.getChild(this.getNode(), BREAKPOINT));
        }
    }

    public static class BreakpointGetCommand
    extends BreakpointSetCommand {
        static final String ID_ARG = "-d ";
        private String breakPointId;

        public BreakpointGetCommand(int n, String string) {
            this(CommandMap.BREAKPOINT_GET.getCommand(), n, string);
        }

        public BreakpointGetCommand(String string, int n, String string2) {
            super(string, n);
            this.breakPointId = string2;
        }

        protected String getArguments() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(ID_ARG);
            stringBuilder.append(this.getId());
            return stringBuilder.toString();
        }

        public String getId() {
            return this.breakPointId;
        }
    }

    public static class BreakpointSetResponse
    extends ResponseMessage {
        BreakpointSetResponse(Node node) {
            super(node);
        }

        public String getId() {
            return BreakpointSetResponse.getAttribute(this.getNode(), Breakpoint.ID);
        }

        public State getState() {
            String string = BreakpointSetResponse.getAttribute(this.getNode(), Breakpoint.STATE);
            return State.valueOf(string.toUpperCase());
        }
    }

    public static class WatchBreakpointSetCommand
    extends ConditionalBreakpointSetCommand {
        WatchBreakpointSetCommand(int n, String string) {
            super(n, string);
            this.setType(Type.WATCH);
        }
    }

    public static class ConditionalBreakpointSetCommand
    extends BreakpointSetCommand {
        private String expression;

        ConditionalBreakpointSetCommand(int n, String string) {
            super(n, Type.CONDITIONAL);
            this.expression = string;
        }

        protected String getArguments() {
            StringBuilder stringBuilder = this.getBaseArguments();
            stringBuilder.append(" ");
            stringBuilder.append(Type.CONDITIONAL.getArgumentSwitch());
            stringBuilder.append(this.expression);
            return stringBuilder.toString();
        }
    }

    public static class ExceptionBreakpointCommand
    extends BreakpointSetCommand {
        private String exception;

        ExceptionBreakpointCommand(int n, String string) {
            super(n, Type.EXCEPTION);
            this.exception = string;
        }

        protected String getArguments() {
            StringBuilder stringBuilder = this.getBaseArguments();
            stringBuilder.append(" ");
            stringBuilder.append(Type.EXCEPTION.getArgumentSwitch());
            stringBuilder.append(this.exception);
            return stringBuilder.toString();
        }
    }

    public static class ReturnBreakpointSetCommand
    extends CallBreakpointSetCommand {
        ReturnBreakpointSetCommand(int n, String string) {
            super(n, string);
            this.setType(Type.RETURN);
        }
    }

    public static class CallBreakpointSetCommand
    extends BreakpointSetCommand {
        private String functionName;

        CallBreakpointSetCommand(int n, String string) {
            super(n, Type.CALL);
            this.functionName = string;
        }

        protected String getArguments() {
            StringBuilder stringBuilder = this.getBaseArguments();
            stringBuilder.append(" ");
            stringBuilder.append(Type.CALL.getArgumentSwitch());
            stringBuilder.append(this.functionName);
            return stringBuilder.toString();
        }
    }

    public static class LineBreakpointSetCommand
    extends BreakpointSetCommand {
        LineBreakpointSetCommand(int n, String string, int n2) {
            super(n, Type.LINE);
            this.setLineNumber(n2);
            this.setFileURI(string);
        }
    }

    public static abstract class BreakpointSetCommand
    extends Command {
        protected static final String TYPE_ARG = "-t ";
        protected static final String STATE_ARG = "-s ";
        protected static final String TEMP_ARG = "-r ";
        protected static final String HIT_VALUE_ARG = "-h ";
        protected static final String HIT_CONDITION_ARG = "-o ";
        private State state = State.ENABLED;
        private Type type;
        private String fileURI;
        private boolean isTemporary;
        private int hitValue = -1;
        private HitCondition hitCondition;
        private int lineNumber = -1;
        private String condition;

        BreakpointSetCommand(int n, Type type) {
            this(CommandMap.BREAKPOINT_SET.getCommand(), n, type);
        }

        BreakpointSetCommand(String string, int n, Type type) {
            super(string, n);
            this.type = type;
        }

        BreakpointSetCommand(String string, int n) {
            super(string, n);
        }

        protected String getArguments() {
            return this.getBaseArguments().toString();
        }

        StringBuilder getBaseArguments() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.type != null) {
                stringBuilder.append(TYPE_ARG);
                stringBuilder.append((Object)this.type);
            }
            if (this.state != null) {
                stringBuilder.append(" ");
                stringBuilder.append(STATE_ARG);
                stringBuilder.append(this.state.toString());
            }
            stringBuilder.append(" ");
            stringBuilder.append(TEMP_ARG);
            stringBuilder.append(this.isTemporary ? 1 : 0);
            if (this.fileURI != null) {
                stringBuilder.append(" ");
                stringBuilder.append("-f ");
                stringBuilder.append(this.fileURI);
            }
            if (this.lineNumber != -1) {
                stringBuilder.append(" ");
                stringBuilder.append(Type.LINE.getArgumentSwitch());
                stringBuilder.append(this.lineNumber);
            }
            if (this.hitValue != -1) {
                stringBuilder.append(" ");
                stringBuilder.append(HIT_VALUE_ARG);
                stringBuilder.append(this.hitValue);
            }
            if (this.hitCondition != null) {
                stringBuilder.append(" ");
                stringBuilder.append(HIT_CONDITION_ARG);
                stringBuilder.append(this.hitCondition.toString());
            }
            if (this.condition != null) {
                stringBuilder.append(" ");
                stringBuilder.append(Type.CONDITIONAL.getArgumentSwitch());
                stringBuilder.append(this.condition);
            }
            return stringBuilder;
        }

        public void setTemporary(boolean bl) {
            this.isTemporary = bl;
        }

        public void setFileURI(String string) {
            this.fileURI = string;
        }

        public void setState(boolean bl) {
            this.state = bl ? State.ENABLED : State.DISABLED;
        }

        public void setType(Type type) {
            this.type = type;
        }

        public void setHitCondition(String string) {
            this.hitCondition = HitCondition.valueOf(string.toUpperCase());
        }

        public void setHitValue(int n) {
            this.hitValue = n;
        }

        public void setCondition(String string) {
            this.condition = string;
        }

        public void setLineNumber(int n) {
            this.lineNumber = n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        ENABLED,
        DISABLED;


        public String toString() {
            return super.toString().toLowerCase();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum Type {
        LINE("-n "),
        CALL("-m "),
        RETURN("-m "),
        EXCEPTION("-x "),
        CONDITIONAL("-- "),
        WATCH("-- ");

        private String argSwitch;

        private Type(String string2) {
            this.argSwitch = string2;
        }

        public String getArgumentSwitch() {
            return this.argSwitch;
        }

        public String toString() {
            return super.toString().toLowerCase();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum HitCondition {
        EQUAL("=="),
        GREATER(">="),
        MULTIPLE("%");

        private String value;

        private HitCondition(String string2) {
            this.value = string2;
        }

        public String toString() {
            return this.value;
        }
    }
}

