/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common.nodes;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.glassfish.common.CommandRunner;
import org.netbeans.modules.glassfish.common.nodes.DecoratorManager;
import org.netbeans.modules.glassfish.common.nodes.Hk2ItemNode;
import org.netbeans.modules.glassfish.common.nodes.Hk2ResourceContainers;
import org.netbeans.modules.glassfish.common.nodes.Hk2ResourceNode;
import org.netbeans.modules.glassfish.common.nodes.NodeTypes;
import org.netbeans.modules.glassfish.common.nodes.Refreshable;
import org.netbeans.modules.glassfish.common.ui.ConnectionPoolCustomizer;
import org.netbeans.modules.glassfish.common.ui.JdbcResourceCustomizer;
import org.netbeans.modules.glassfish.spi.Decorator;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.netbeans.modules.glassfish.spi.OperationStateListener;
import org.netbeans.modules.glassfish.spi.ResourceDecorator;
import org.netbeans.modules.glassfish.spi.ResourceDesc;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Hk2ResourcesChildren
extends Children.Keys<Object>
implements Refreshable {
    private Lookup lookup;
    private String type;
    private static final Node WAIT_NODE = Hk2ItemNode.createWaitNode();

    Hk2ResourcesChildren(Lookup lookup, String string) {
        this.lookup = lookup;
        this.type = string;
    }

    @Override
    public void updateKeys() {
        Vector<Hk2ItemNode> vector = new Vector<Hk2ItemNode>();
        String[] stringArray = NodeTypes.getChildTypes(this.type);
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                vector.add(new Hk2ItemNode(this.lookup, (Children)new Hk2Resources(this.lookup, string), NbBundle.getMessage(Hk2ResourceContainers.class, (String)("LBL_" + string)), Hk2ItemNode.REFRESHABLE_FOLDER));
            }
        }
        this.setKeys(vector);
    }

    protected void addNotify() {
        this.updateKeys();
    }

    protected void removeNotify() {
        this.setKeys(Collections.EMPTY_SET);
    }

    protected Node[] createNodes(Object object) {
        if (object instanceof Hk2ItemNode) {
            return new Node[]{(Hk2ItemNode)((Object)object)};
        }
        if (object instanceof String && object.equals(WAIT_NODE)) {
            return new Node[]{WAIT_NODE};
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Hk2Resources
    extends Children.Keys<Object>
    implements Refreshable {
        private Lookup lookup;
        private String type;
        private final Node WAIT_NODE = Hk2ItemNode.createWaitNode();

        Hk2Resources(Lookup lookup, String string) {
            this.lookup = lookup;
            this.type = string;
        }

        @Override
        public void updateKeys() {
            RequestProcessor.getDefault().post(new Runnable(){
                Vector<Object> keys = new Vector();

                public void run() {
                    GlassfishModule glassfishModule = (GlassfishModule)Hk2Resources.this.lookup.lookup(GlassfishModule.class);
                    if (glassfishModule != null) {
                        try {
                            Map<String, String> map = glassfishModule.getInstanceProperties();
                            CommandRunner commandRunner = new CommandRunner(map, new OperationStateListener[0]);
                            Decorator decorator = DecoratorManager.findDecorator(Hk2Resources.this.type, null);
                            if (decorator == null) {
                                if (Hk2Resources.this.type.equals("jdbc-resource")) {
                                    decorator = Hk2ItemNode.JDBC_MANAGED_DATASOURCES;
                                } else if (Hk2Resources.this.type.equals("jdbc-connection-pool")) {
                                    decorator = Hk2ItemNode.CONNECTION_POOLS;
                                }
                            }
                            if (decorator != null) {
                                List<ResourceDesc> list = commandRunner.getResources(Hk2Resources.this.type);
                                for (ResourceDesc resourceDesc : list) {
                                    this.keys.add((Object)new Hk2ResourceNode(Hk2Resources.this.lookup, resourceDesc, (ResourceDecorator)decorator, Hk2Resources.this.getCustomizer(Hk2Resources.this.type)));
                                }
                            }
                        }
                        catch (Exception exception) {
                            Logger.getLogger("glassfish").log(Level.INFO, exception.getLocalizedMessage(), exception);
                        }
                        Hk2Resources.this.setKeys(this.keys);
                    }
                }
            }, 0);
        }

        protected void addNotify() {
            this.updateKeys();
        }

        protected void removeNotify() {
            this.setKeys(Collections.EMPTY_SET);
        }

        protected Node[] createNodes(Object object) {
            if (object instanceof Hk2ItemNode) {
                return new Node[]{(Hk2ItemNode)((Object)object)};
            }
            if (object instanceof String && object.equals(this.WAIT_NODE)) {
                return new Node[]{this.WAIT_NODE};
            }
            return null;
        }

        private Class getCustomizer(String string) {
            Class clazz = null;
            if (string.equals("jdbc-connection-pool")) {
                clazz = ConnectionPoolCustomizer.class;
            } else if (string.equals("jdbc-resource")) {
                clazz = JdbcResourceCustomizer.class;
            }
            return clazz;
        }
    }
}

