/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.glassfish.common.BasicTask;
import org.netbeans.modules.glassfish.common.CommandRunner;
import org.netbeans.modules.glassfish.common.CommonServerSupport;
import org.netbeans.modules.glassfish.spi.GlassfishModule;
import org.netbeans.modules.glassfish.spi.OperationStateListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StopTask
extends BasicTask<GlassfishModule.OperationState> {
    private final CommonServerSupport support;

    public StopTask(CommonServerSupport commonServerSupport, OperationStateListener ... operationStateListenerArray) {
        super(commonServerSupport.getInstanceProperties(), operationStateListenerArray);
        this.support = commonServerSupport;
    }

    @Override
    public GlassfishModule.OperationState call() {
        Logger.getLogger("glassfish").log(Level.FINEST, "StopTask.call() called on thread \"" + Thread.currentThread().getName() + "\"");
        long l = System.currentTimeMillis();
        int n = 0;
        String string = (String)this.ip.get("host");
        if (string == null || string.length() == 0) {
            return this.fireOperationStateChanged(GlassfishModule.OperationState.FAILED, "MSG_START_SERVER_FAILED_NOHOST", this.instanceName);
        }
        try {
            n = Integer.valueOf((String)this.ip.get("httpportnumber"));
            if (n < 0 || n > 65535) {
                return this.fireOperationStateChanged(GlassfishModule.OperationState.FAILED, "MSG_START_SERVER_FAILED_BADPORT", this.instanceName);
            }
        }
        catch (NumberFormatException numberFormatException) {
            return this.fireOperationStateChanged(GlassfishModule.OperationState.FAILED, "MSG_START_SERVER_FAILED_BADPORT", this.instanceName);
        }
        CommandRunner commandRunner = new CommandRunner(this.ip, new OperationStateListener(){

            public void operationStateChanged(GlassfishModule.OperationState operationState, String string) {
                if (operationState == GlassfishModule.OperationState.FAILED) {
                    StopTask.this.fireOperationStateChanged(operationState, string, StopTask.this.instanceName);
                }
            }
        });
        commandRunner.stopServer();
        this.fireOperationStateChanged(GlassfishModule.OperationState.RUNNING, "MSG_STOP_SERVER_IN_PROGRESS", this.instanceName);
        while (System.currentTimeMillis() - l < 10000L) {
            if (!CommonServerSupport.isRunning(string, n)) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return this.fireOperationStateChanged(GlassfishModule.OperationState.COMPLETED, "MSG_SERVER_STOPPED", this.instanceName);
            }
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.fireOperationStateChanged(GlassfishModule.OperationState.RUNNING, "MSG_STOP_SERVER_IN_PROGRESS", this.instanceName);
        }
        return this.fireOperationStateChanged(GlassfishModule.OperationState.FAILED, "MSG_STOP_SERVER_FAILED", this.instanceName);
    }
}

