/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.netbeans.api.server.ServerInstance;
import org.netbeans.modules.glassfish.common.CommonServerSupport;
import org.netbeans.modules.glassfish.common.CreateDomain;
import org.netbeans.modules.glassfish.common.GlassfishInstance;
import org.netbeans.modules.glassfish.spi.RegisteredDDCatalog;
import org.netbeans.modules.glassfish.spi.Utils;
import org.netbeans.spi.server.ServerInstanceImplementation;
import org.netbeans.spi.server.ServerInstanceProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ChangeSupport;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GlassfishInstanceProvider
implements ServerInstanceProvider {
    static final String INSTANCE_FO_ATTR = "InstanceFOPath";
    private static volatile GlassfishInstanceProvider preludeProvider;
    private static volatile GlassfishInstanceProvider ee6Provider;
    private static String EE6_PROP_ROOT;
    private static String INSTALL_ROOT_SUFFIX;
    private static String EE6_INSTALL_ROOT_PROP;
    private static String PRELUDE_PROP_ROOT;
    private static String PRELUDE_INSTALL_ROOT_PROP;
    private static String ENABLE_EXPERIMENTAL_SUFFIX;
    private static String DISABLE_PRELUDE_SUFFIX;
    private static String EE6_DEPLOYER_FRAGMENT;
    private static String PRELUDE_DEPLOYER_FRAGMENT;
    private static String EE6_INSTANCES_PATH;
    private static String PRELUDE_INSTANCES_PATH;
    public static final Set<String> activeRegistrationSet;
    private final Map<String, GlassfishInstance> instanceMap = Collections.synchronizedMap(new HashMap());
    private final ChangeSupport support = new ChangeSupport((Object)this);
    private String[] instancesDirNames;
    private String displayName;
    private String[] uriFragments;
    private String installRootPropName;
    private String defaultDomainName;
    private String defaultPersonalDomainName;
    private String defaultInstallName;
    private String directDownloadUrl;
    private String indirectDownloadUrl;
    private String installRootKey;
    private String[] requiredFiles;
    private String[] excludedFiles;
    private boolean needsJdk6;
    private String[] javadocFilenames;

    public static List<GlassfishInstanceProvider> getProviders(boolean bl) {
        ArrayList<GlassfishInstanceProvider> arrayList = new ArrayList<GlassfishInstanceProvider>();
        if (bl) {
            GlassfishInstanceProvider.getPrelude();
            GlassfishInstanceProvider.getEe6();
        }
        if (preludeProvider != null) {
            arrayList.add(preludeProvider);
        }
        if (ee6Provider != null) {
            arrayList.add(ee6Provider);
        }
        return arrayList;
    }

    public static synchronized GlassfishInstanceProvider getEe6() {
        FileObject fileObject = FileUtil.getConfigFile((String)"GlassFish v3/Enable Experimental Features");
        String string = System.getProperty(EE6_INSTALL_ROOT_PROP);
        if (("true".equals(System.getProperty(PRELUDE_PROP_ROOT + ENABLE_EXPERIMENTAL_SUFFIX)) || null != string && string.trim().length() > 0 || null != fileObject) && ee6Provider == null) {
            ee6Provider = new GlassfishInstanceProvider(new String[]{EE6_DEPLOYER_FRAGMENT}, new String[]{EE6_INSTANCES_PATH}, NbBundle.getMessage(GlassfishInstanceProvider.class, (String)"STR_V3_SERVER_NAME", (Object[])new Object[0]), EE6_INSTALL_ROOT_PROP, NbBundle.getMessage(GlassfishInstanceProvider.class, (String)"STR_V3_AUTO_REGISTERED_NAME", (Object[])new Object[0]), NbBundle.getMessage(GlassfishInstanceProvider.class, (String)"STR_V3_AUTO_CREATED_NAME", (Object[])new Object[0]), "GlassFish_v3", "http://java.net/download/glassfish/v3-preview/promoted/latest-glassfish.zip", "http://serverplugins.netbeans.org/glassfishv3/ee6zipfilename.txt", "last-v3ee6-install-root", new String[]{"lib" + File.separator + "schemas" + File.separator + "web-app_3_0.xsd"}, new String[0], true, new String[]{"docs/javadocee6.jar"});
        }
        return ee6Provider;
    }

    public static synchronized GlassfishInstanceProvider getPrelude() {
        String[] stringArray;
        String[] stringArray2;
        if ("true".equals(System.getProperty(PRELUDE_PROP_ROOT + DISABLE_PRELUDE_SUFFIX))) {
            return preludeProvider;
        }
        FileObject fileObject = FileUtil.getConfigFile((String)"GlassFish v3/Enable Experimental Features");
        String string = System.getProperty(EE6_INSTALL_ROOT_PROP);
        if (!("true".equals(System.getProperty(PRELUDE_PROP_ROOT + ENABLE_EXPERIMENTAL_SUFFIX)) || null != fileObject || null != string && string.trim().length() >= 1)) {
            stringArray2 = new String[]{PRELUDE_DEPLOYER_FRAGMENT, EE6_DEPLOYER_FRAGMENT};
            stringArray = new String[]{PRELUDE_INSTANCES_PATH, EE6_INSTANCES_PATH};
        } else {
            stringArray2 = new String[]{PRELUDE_DEPLOYER_FRAGMENT};
            stringArray = new String[]{PRELUDE_INSTANCES_PATH};
        }
        if (preludeProvider == null) {
            preludeProvider = new GlassfishInstanceProvider(stringArray2, stringArray, NbBundle.getMessage(GlassfishInstanceProvider.class, (String)"STR_PRELUDE_SERVER_NAME", (Object[])new Object[0]), PRELUDE_PROP_ROOT + INSTALL_ROOT_SUFFIX, NbBundle.getMessage(GlassfishInstanceProvider.class, (String)"STR_PRELUDE_AUTO_REGISTERED_NAME", (Object[])new Object[0]), NbBundle.getMessage(GlassfishInstanceProvider.class, (String)"STR_PRELUDE_AUTO_CREATED_NAME", (Object[])new Object[0]), "GlassFish_v3_Prelude", "http://java.net/download/glassfish/v3-prelude/release/glassfish-v3-prelude-ml.zip", "http://serverplugins.netbeans.org/glassfishv3/preludezipfilename.txt", "last-install-root", new String[0], new String[]{"lib" + File.separator + "schemas" + File.separator + "web-app_3_0.xsd"}, false, new String[]{"docs/javaee5-doc-api.zip"});
        }
        return preludeProvider;
    }

    private GlassfishInstanceProvider(String[] stringArray, String[] stringArray2, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String[] stringArray3, String[] stringArray4, boolean bl, String[] stringArray5) {
        this.instancesDirNames = stringArray2;
        this.displayName = string;
        this.uriFragments = stringArray;
        this.installRootPropName = string2;
        this.defaultDomainName = string3;
        this.defaultPersonalDomainName = string4;
        this.defaultInstallName = string5;
        this.directDownloadUrl = string6;
        this.indirectDownloadUrl = string7;
        this.installRootKey = string8;
        this.requiredFiles = stringArray3;
        this.excludedFiles = stringArray4;
        this.needsJdk6 = bl;
        this.javadocFilenames = stringArray5;
    }

    public static synchronized boolean initialized() {
        return preludeProvider != null || ee6Provider != null;
    }

    public static Logger getLogger() {
        return Logger.getLogger("glassfish");
    }

    private static RegisteredDDCatalog getDDCatalog() {
        return (RegisteredDDCatalog)Lookup.getDefault().lookup(RegisteredDDCatalog.class);
    }

    private static void refreshCatalogFromFirstInstance(GlassfishInstanceProvider glassfishInstanceProvider, RegisteredDDCatalog registeredDDCatalog) {
        GlassfishInstance glassfishInstance = glassfishInstanceProvider.getFirstServerInstance();
        if (null != glassfishInstance) {
            registeredDDCatalog.refreshRunTimeDDCatalog(glassfishInstanceProvider, glassfishInstance.getGlassfishRoot());
        }
    }

    public String[] getAssociatedJavaDoc() {
        return (String[])this.javadocFilenames.clone();
    }

    private GlassfishInstance getFirstServerInstance() {
        if (!this.instanceMap.isEmpty()) {
            return this.instanceMap.values().iterator().next();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addServerInstance(GlassfishInstance glassfishInstance) {
        Map<String, GlassfishInstance> map = this.instanceMap;
        synchronized (map) {
            try {
                RegisteredDDCatalog registeredDDCatalog;
                this.instanceMap.put(glassfishInstance.getDeployerUri(), glassfishInstance);
                if (this.instanceMap.size() == 1 && null != (registeredDDCatalog = GlassfishInstanceProvider.getDDCatalog())) {
                    registeredDDCatalog.refreshRunTimeDDCatalog(this, glassfishInstance.getGlassfishRoot());
                }
                this.writeInstanceToFile(glassfishInstance);
            }
            catch (IOException iOException) {
                GlassfishInstanceProvider.getLogger().log(Level.INFO, null, iOException);
            }
        }
        this.support.fireChange();
    }

    public String getDefaultInstallName() {
        return this.defaultInstallName;
    }

    public String getDirectDownloadUrl() {
        return this.directDownloadUrl;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getIndirectDownloadUrl() {
        return this.indirectDownloadUrl;
    }

    public String getInstallRootKey() {
        return this.installRootKey;
    }

    public String getInstallRootProperty() {
        return this.installRootPropName;
    }

    public String[] getRequiredFiles() {
        return (String[])this.requiredFiles.clone();
    }

    public String[] getExcludedFiles() {
        return (String[])this.excludedFiles.clone();
    }

    public String getNameOfBits() {
        return this.displayName;
    }

    public String getUriFragment() {
        return this.uriFragments[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeServerInstance(GlassfishInstance glassfishInstance) {
        boolean bl = false;
        Map<String, GlassfishInstance> map = this.instanceMap;
        synchronized (map) {
            if (this.instanceMap.remove(glassfishInstance.getDeployerUri()) != null) {
                RegisteredDDCatalog registeredDDCatalog;
                bl = true;
                this.removeInstanceFromFile(glassfishInstance.getDeployerUri());
                if (this.instanceMap.size() == 0 && null != (registeredDDCatalog = GlassfishInstanceProvider.getDDCatalog())) {
                    registeredDDCatalog.refreshRunTimeDDCatalog(this, null);
                }
            }
        }
        if (bl) {
            this.support.fireChange();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Lookup getLookupFor(ServerInstance serverInstance) {
        Map<String, GlassfishInstance> map = this.instanceMap;
        synchronized (map) {
            for (GlassfishInstance glassfishInstance : this.instanceMap.values()) {
                if (!glassfishInstance.getCommonInstance().equals(serverInstance)) continue;
                return glassfishInstance.getLookup();
            }
            return null;
        }
    }

    public ServerInstanceImplementation getInternalInstance(String string) {
        this.init();
        return this.instanceMap.get(string);
    }

    public <T> T getInstanceByCapability(String string, Class<T> clazz) {
        Object object = null;
        this.init();
        GlassfishInstance glassfishInstance = this.instanceMap.get(string);
        if (glassfishInstance != null) {
            object = glassfishInstance.getLookup().lookup(clazz);
        }
        return (T)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> getInstancesByCapability(Class<T> clazz) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        this.init();
        Map<String, GlassfishInstance> map = this.instanceMap;
        synchronized (map) {
            for (GlassfishInstance glassfishInstance : this.instanceMap.values()) {
                Object object = glassfishInstance.getLookup().lookup(clazz);
                if (object == null) continue;
                arrayList.add(object);
            }
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ServerInstance> getInstances() {
        ArrayList<ServerInstance> arrayList = new ArrayList<ServerInstance>();
        this.init();
        Map<String, GlassfishInstance> map = this.instanceMap;
        synchronized (map) {
            for (GlassfishInstance glassfishInstance : this.instanceMap.values()) {
                arrayList.add(glassfishInstance.getCommonInstance());
            }
        }
        return arrayList;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.support.addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.support.removeChangeListener(changeListener);
    }

    public boolean hasServer(String string) {
        return this.getInstance(string) != null;
    }

    public ServerInstance getInstance(String string) {
        this.init();
        GlassfishInstance glassfishInstance = this.instanceMap.get(string);
        return glassfishInstance == null ? null : glassfishInstance.getCommonInstance();
    }

    public String formatUri(String string, String string2, int n) {
        return "[" + string + "]" + this.uriFragments[0] + ":" + string2 + ":" + n;
    }

    String getInstancesDirName() {
        return this.instancesDirNames[0];
    }

    Collection<GlassfishInstance> getInternalInstances() {
        this.init();
        return this.instanceMap.values();
    }

    boolean requiresJdk6OrHigher() {
        return this.needsJdk6;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        Map<String, GlassfishInstance> map = this.instanceMap;
        synchronized (map) {
            if (this.instanceMap.isEmpty()) {
                try {
                    this.registerDefaultInstance();
                    this.loadServerInstances();
                }
                catch (RuntimeException runtimeException) {
                    GlassfishInstanceProvider.getLogger().log(Level.INFO, null, runtimeException);
                }
                RegisteredDDCatalog registeredDDCatalog = GlassfishInstanceProvider.getDDCatalog();
                if (null != registeredDDCatalog) {
                    if (this.equals(preludeProvider)) {
                        registeredDDCatalog.registerPreludeRunTimeDDCatalog(this);
                    } else {
                        registeredDDCatalog.registerEE6RunTimeDDCatalog(this);
                    }
                    GlassfishInstanceProvider.refreshCatalogFromFirstInstance(this, registeredDDCatalog);
                }
            }
        }
    }

    private void loadServerInstances() {
        for (int i = 0; i < this.instancesDirNames.length; ++i) {
            FileObject[] fileObjectArray;
            FileObject fileObject = this.getRepositoryDir(this.instancesDirNames[i], false);
            if (fileObject == null || (fileObjectArray = fileObject.getChildren()) == null || fileObjectArray.length <= 0) continue;
            for (int j = 0; j < fileObjectArray.length; ++j) {
                try {
                    GlassfishInstance glassfishInstance = this.readInstanceFromFile(fileObjectArray[j], this.uriFragments[i]);
                    if (glassfishInstance != null) {
                        this.instanceMap.put(glassfishInstance.getDeployerUri(), glassfishInstance);
                        continue;
                    }
                    GlassfishInstanceProvider.getLogger().finer("Unable to create glassfish instance for " + fileObjectArray[j].getPath());
                    continue;
                }
                catch (IOException iOException) {
                    GlassfishInstanceProvider.getLogger().log(Level.INFO, null, iOException);
                }
            }
        }
    }

    private GlassfishInstance readInstanceFromFile(FileObject fileObject, String string) throws IOException {
        GlassfishInstance glassfishInstance = null;
        String string2 = GlassfishInstanceProvider.getStringAttribute(fileObject, "installfolder");
        String string3 = GlassfishInstanceProvider.getStringAttribute(fileObject, "homefolder");
        if (string2 == null) {
            string2 = string3;
        }
        if (GlassfishInstanceProvider.isValidHomeFolder(string2) && GlassfishInstanceProvider.isValidGlassfishFolder(string3)) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            Enumeration enumeration = fileObject.getAttributes();
            while (enumeration.hasMoreElements()) {
                String string4 = (String)enumeration.nextElement();
                String string5 = GlassfishInstanceProvider.getStringAttribute(fileObject, string4);
                hashMap.put(string4, string5);
            }
            hashMap.put(INSTANCE_FO_ATTR, fileObject.getName());
            glassfishInstance = GlassfishInstance.create(hashMap, this);
        } else {
            GlassfishInstanceProvider.getLogger().finer("GlassFish folder " + fileObject.getPath() + " is not a valid install.");
            fileObject.delete();
        }
        return glassfishInstance;
    }

    private void writeInstanceToFile(GlassfishInstance glassfishInstance) throws IOException {
        String string = glassfishInstance.getGlassfishRoot();
        if (string == null) {
            GlassfishInstanceProvider.getLogger().log(Level.SEVERE, NbBundle.getMessage(GlassfishInstanceProvider.class, (String)"MSG_NullServerFolder"));
            return;
        }
        String string2 = glassfishInstance.getDeployerUri();
        FileObject fileObject = this.getRepositoryDir(this.instancesDirNames[0], true);
        FileObject[] fileObjectArray = fileObject.getChildren();
        FileObject fileObject2 = null;
        for (int i = 0; i < fileObjectArray.length; ++i) {
            if (!string2.equals(fileObjectArray[i].getAttribute("url"))) continue;
            fileObject2 = fileObjectArray[i];
        }
        if (fileObject2 == null) {
            String string3 = FileUtil.findFreeFileName((FileObject)fileObject, (String)"instance", null);
            fileObject2 = fileObject.createData(string3);
        }
        CommonServerSupport commonServerSupport = glassfishInstance.getCommonSupport();
        Map<String, String> map = commonServerSupport.getInstanceProperties();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String string4 = entry.getKey();
            if (GlassfishInstanceProvider.filterKey(string4)) continue;
            fileObject2.setAttribute(string4, (Object)entry.getValue());
        }
        commonServerSupport.setProperty(INSTANCE_FO_ATTR, fileObject2.getName());
        commonServerSupport.setFileObject(fileObject2);
    }

    private static boolean filterKey(String string) {
        return INSTANCE_FO_ATTR.equals(string);
    }

    private void removeInstanceFromFile(String string) {
        FileObject fileObject = this.getInstanceFileObject(string);
        if (fileObject != null && fileObject.isValid()) {
            try {
                fileObject.delete();
            }
            catch (IOException iOException) {
                GlassfishInstanceProvider.getLogger().log(Level.INFO, null, iOException);
            }
        }
    }

    private FileObject getInstanceFileObject(String string) {
        for (String string2 : this.instancesDirNames) {
            FileObject fileObject = this.getRepositoryDir(string2, false);
            if (fileObject == null) continue;
            FileObject[] fileObjectArray = fileObject.getChildren();
            for (int i = 0; i < fileObjectArray.length; ++i) {
                String string3 = GlassfishInstanceProvider.getStringAttribute(fileObjectArray[i], "url");
                if (string3 == null || !string3.equals(string)) continue;
                return fileObjectArray[i];
            }
        }
        return null;
    }

    private FileObject getRepositoryDir(String string, boolean bl) {
        FileObject fileObject = FileUtil.getConfigFile((String)string);
        if (fileObject == null && bl) {
            try {
                fileObject = FileUtil.createFolder((FileObject)FileUtil.getConfigRoot(), (String)string);
            }
            catch (IOException iOException) {
                GlassfishInstanceProvider.getLogger().log(Level.INFO, null, iOException);
            }
        }
        return fileObject;
    }

    private static boolean isValidHomeFolder(String string) {
        boolean bl = false;
        if (string != null) {
            File file = new File(string);
            bl = file.exists();
        }
        return bl;
    }

    private static boolean isValidGlassfishFolder(String string) {
        boolean bl = false;
        if (string != null) {
            File file = new File(string);
            bl = file.exists();
        }
        return bl;
    }

    private static String getStringAttribute(FileObject fileObject, String string) {
        return GlassfishInstanceProvider.getStringAttribute(fileObject, string, null);
    }

    private static String getStringAttribute(FileObject fileObject, String string, String string2) {
        String string3 = string2;
        Object object = fileObject.getAttribute(string);
        if (object instanceof String) {
            string3 = (String)object;
        }
        return string3;
    }

    private static int getIntAttribute(FileObject fileObject, String string, int n) {
        int n2 = n;
        String string2 = GlassfishInstanceProvider.getStringAttribute(fileObject, string);
        if (string2 != null) {
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                GlassfishInstanceProvider.getLogger().log(Level.FINER, numberFormatException.getLocalizedMessage(), numberFormatException);
            }
        }
        return n2;
    }

    private void registerDefaultInstance() {
        boolean bl;
        boolean bl2 = bl = !NbPreferences.forModule(this.getClass()).getBoolean("first_run", false);
        if (bl) {
            try {
                String string = System.getProperty(this.installRootPropName);
                if (null != string) {
                    File file = new File(string);
                    if (GlassfishInstanceProvider.isValidHomeFolder(string) && file.exists()) {
                        HashMap<String, String> hashMap = new HashMap<String, String>();
                        hashMap.put("installfolder", file.getCanonicalPath());
                        hashMap.put("homefolder", file.getCanonicalPath() + File.separator + "glassfish");
                        if (Utils.canWrite(file)) {
                            hashMap.put("displayName", this.defaultDomainName);
                            hashMap.put("httpportnumber", Integer.toString(8080));
                            hashMap.put("adminPort", Integer.toString(4848));
                            GlassfishInstance glassfishInstance = GlassfishInstance.create(hashMap, this);
                            NbPreferences.forModule(this.getClass()).putBoolean("first_run", true);
                        } else {
                            hashMap.put("displayName", this.defaultPersonalDomainName);
                            String string2 = System.getProperty("netbeans.user");
                            String string3 = "Glassfishv3PreludeDomain";
                            hashMap.put("domainsfolder", string2);
                            hashMap.put("domainname", string3);
                            CreateDomain createDomain = new CreateDomain("anonymous", "", new File(file, "glassfish"), hashMap, this);
                            createDomain.start();
                        }
                    }
                }
            }
            catch (IOException iOException) {
                GlassfishInstanceProvider.getLogger().log(Level.INFO, iOException.getLocalizedMessage(), iOException);
            }
        }
    }

    static {
        EE6_PROP_ROOT = "org.glassfish.v3ee6.";
        INSTALL_ROOT_SUFFIX = "installRoot";
        EE6_INSTALL_ROOT_PROP = EE6_PROP_ROOT + INSTALL_ROOT_SUFFIX;
        PRELUDE_PROP_ROOT = "org.glassfish.v3.";
        PRELUDE_INSTALL_ROOT_PROP = PRELUDE_PROP_ROOT + INSTALL_ROOT_SUFFIX;
        ENABLE_EXPERIMENTAL_SUFFIX = "enableExperimentalFeatures";
        DISABLE_PRELUDE_SUFFIX = "disablePreludeSupport";
        EE6_DEPLOYER_FRAGMENT = "deployer:gfv3ee6";
        PRELUDE_DEPLOYER_FRAGMENT = "deployer:gfv3";
        EE6_INSTANCES_PATH = "/GlassFishEE6/Instances";
        PRELUDE_INSTANCES_PATH = "/GlassFish/Instances";
        activeRegistrationSet = Collections.synchronizedSet(new HashSet());
    }
}

