/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.common;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.glassfish.common.ExecSupport;
import org.netbeans.modules.glassfish.common.GlassfishInstance;
import org.netbeans.modules.glassfish.common.GlassfishInstanceProvider;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateDomain
extends Thread {
    static final String PORTBASE = "portbase";
    private final String uname;
    private final String pword;
    private final File platformLocation;
    private final Map<String, String> map;
    private final Map<String, String> ip;
    private GlassfishInstanceProvider gip;

    public CreateDomain(String string, String string2, File file, Map<String, String> map, GlassfishInstanceProvider glassfishInstanceProvider) {
        this.uname = string;
        this.pword = string2;
        this.platformLocation = file;
        this.ip = map;
        this.map = new HashMap<String, String>();
        this.gip = glassfishInstanceProvider;
        this.map.putAll(map);
        CreateDomain.computePorts(map, this.map);
    }

    private static void computePorts(Map<String, String> map, Map<String, String> map2) {
        int n = 8900;
        int n2 = (new Date().toString() + map.get("domainsfolder") + map.get("domainname")).hashCode() % 40000;
        n2 = n2 < 0 ? -n2 : n2;
        int n3 = n + n2 + 80;
        int n4 = n + n2 + 48;
        map.put("httpportnumber", Integer.toString(n3));
        map.put("adminPort", Integer.toString(n4));
        map2.put("httpportnumber", Integer.toString(n3));
        map2.put("adminPort", Integer.toString(n4));
        map2.put(PORTBASE, Integer.toString(n + n2));
    }

    @Override
    public void run() {
        Process process = null;
        File file = this.platformLocation;
        int n = 0;
        if (null != file && file.exists()) {
            Object object;
            String string = file.getAbsolutePath();
            String string2 = string + File.separator + "bin" + File.separator + "asadmin";
            if ("\\".equals(File.separator)) {
                string2 = string2 + ".bat";
            }
            String string3 = this.map.get("domainname");
            String string4 = this.map.get("domainsfolder");
            File file2 = CreateDomain.createTempPasswordFile(this.pword, "changeit");
            if (file2 == null) {
                return;
            }
            String[] stringArray = "".equals(this.pword) ? new String[]{string2, "create-domain", "--domaindir", string4, "--portbase", this.map.get(PORTBASE), "--user", this.uname, string3} : new String[]{string2, "create-domain", "--domaindir", string4, "--portbase", this.map.get(PORTBASE), "--user", this.uname, "--passwordfile", file2.getAbsolutePath(), string3};
            ProgressHandle progressHandle = null;
            try {
                object = new ExecSupport();
                process = Runtime.getRuntime().exec(stringArray);
                PDCancel pDCancel = new PDCancel(process, string4 + File.separator + string3);
                progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(this.getClass(), (String)"LBL_Creating_personal_domain"), (Cancellable)pDCancel);
                progressHandle.start();
                ((ExecSupport)object).displayProcessOutputs(process, NbBundle.getMessage(this.getClass(), (String)"LBL_outputtab"), NbBundle.getMessage(this.getClass(), (String)"LBL_RunningCreateDomainCommand"));
            }
            catch (MissingResourceException missingResourceException) {
                CreateDomain.showInformation(missingResourceException.getLocalizedMessage());
            }
            catch (IOException iOException) {
                CreateDomain.showInformation(iOException.getLocalizedMessage());
            }
            catch (InterruptedException interruptedException) {
                CreateDomain.showInformation(interruptedException.getLocalizedMessage());
            }
            catch (RuntimeException runtimeException) {
                CreateDomain.showInformation(runtimeException.getLocalizedMessage());
                ErrorManager.getDefault().notify(1, (Throwable)runtimeException);
            }
            if (null != process) {
                try {
                    n = process.waitFor();
                    if (!file2.delete()) {
                        CreateDomain.showInformation(NbBundle.getMessage(this.getClass(), (String)"MSG_delete_password_failed", (Object)file2.getAbsolutePath()));
                    }
                }
                catch (InterruptedException interruptedException) {
                    n = -1;
                    ErrorManager.getDefault().notify(1, (Throwable)interruptedException);
                }
            } else {
                n = -1;
            }
            if (null != progressHandle) {
                progressHandle.finish();
            }
            if (0 == n) {
                object = GlassfishInstance.create(this.ip, this.gip);
                NbPreferences.forModule(this.getClass()).putBoolean("first_run", true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File createTempPasswordFile(String string, String string2) {
        PrintWriter printWriter = null;
        File file = null;
        try {
            file = File.createTempFile("admin", null);
            file.deleteOnExit();
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            printWriter = new PrintWriter(fileOutputStream);
            printWriter.println("AS_ADMIN_ADMINPASSWORD=" + string);
            printWriter.println("AS_ADMIN_PASSWORD=" + string);
            printWriter.println("AS_ADMIN_MASTERPASSWORD=" + string2);
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify(1, (Throwable)iOException);
        }
        finally {
            if (printWriter != null) {
                printWriter.close();
            }
        }
        return file;
    }

    private static void showInformation(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 1);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            }
        });
    }

    private static void showError(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            }
        });
    }

    static class PDCancel
    implements Cancellable {
        private final Process p;
        private final String dirname;
        private boolean notFired = true;

        PDCancel(Process process, String string) {
            this.p = process;
            this.dirname = string;
        }

        public synchronized boolean isNotFired() {
            return this.notFired;
        }

        public synchronized boolean cancel() {
            this.notFired = false;
            this.p.destroy();
            File file = new File(this.dirname);
            if (file.exists()) {
                FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
                try {
                    fileObject.delete();
                }
                catch (IOException iOException) {
                    Logger.getLogger(this.getClass().getName()).log(Level.FINER, "", iOException);
                    CreateDomain.showError(NbBundle.getMessage(GlassfishInstanceProvider.class, (String)"ERR_Failed_cleanup", (Object)this.dirname));
                }
            }
            return true;
        }
    }
}

